/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.action;

import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.rootstrap.RootstrapListenerManager;
import org.tizen.nativeplatform.rootstrap.RootstrapSelectionManager;
import org.tizen.sbilib.ide.PluginManager;

public class RootstrapSelectionAction
extends Action {
    protected final String BUNDLE_NAME = String.valueOf(RootstrapSelectionAction.class.getPackage().getName()) + ".RootstrapUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(RootstrapSelectionAction.class);
    protected IProject project;
    protected TableViewer viewer;
    protected Shell shell;

    public RootstrapSelectionAction(Shell shell, IProject project, TableViewer viewer) {
        this.project = project;
        this.viewer = viewer;
        this.shell = shell;
    }

    public void run() {
        this.action();
    }

    protected void action() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                Table table = RootstrapSelectionAction.this.viewer.getTable();
                TableItem[] item = table.getSelection();
                PlatformRootstrap selected = (PlatformRootstrap)item[0].getData();
                if (RootstrapSelectionAction.this.project != null) {
                    if (!RootstrapSelectionAction.this.verifyActiveRootstrap(RootstrapSelectionAction.this.project, selected)) {
                        RootstrapSelectionAction.this.showErrorSelectRootstrap(RootstrapSelectionAction.this.project, selected);
                        return;
                    }
                    RootstrapSelectionAction.this.setActiveRootstrap(RootstrapSelectionAction.this.project, selected);
                }
            }

            @Override
            public boolean doCheckEnable() {
                return true;
            }
        });
    }

    private void setActiveRootstrap(IProject project, PlatformRootstrap rootstrap) {
        String rootId = rootstrap.getId();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = info.getDefaultConfiguration();
        String targetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)config);
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String toolId = sbi.getToolchainIDFromTargetID(targetId);
        PluginManager pm = PluginManager.getInstance();
        String newTargetId = pm.makeTargetId(rootId, toolId);
        pm.createTarget(rootId, toolId, newTargetId);
        pm.reInit();
        PlatformConfigurationManager.setBuildTargetName((IConfiguration)config, (String)newTargetId);
        RootstrapSelectionManager.setSelectedRootstrap((PlatformRootstrap)rootstrap);
        RootstrapListenerManager.notifyChangedRootstrap();
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    private void showErrorSelectRootstrap(IProject project, PlatformRootstrap rootstrap) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = info.getDefaultConfiguration();
        String message = String.format(this.resources.getString("Action.Msg.Error.SelectRootstrap"), rootstrap.getId(), config.getName());
        DialogUtil.openErrorDialog((String)message);
    }

    private boolean verifyActiveRootstrap(IProject project, PlatformRootstrap rootstrap) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = info.getDefaultConfiguration();
        String rootArch = rootstrap.getArchitecture();
        return !(PlatformConfigurationManager.isEmulatorConfiguration((IConfiguration)config) ? !PlatformConfigurationManager.isEmulatorArch((String)rootArch) : PlatformConfigurationManager.isDeviceConfiguration((IConfiguration)config) && !PlatformConfigurationManager.isDeviceArch((String)rootArch));
    }

    private void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    private static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }
}

