/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.commander.rpm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.console.MessageConsoleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.model.Package;
import org.tizen.nativeplatform.pkg.model.PkgInfo;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.pkg.tools.RpmTool;
import org.tizen.nativeplatform.pkg.tools.ZypperTool;
import org.tizen.nativeplatform.pkg.tools.ZypperXmlParser;
import org.tizen.nativeplatform.pkgmgr.PackageManagerOutputReceiver;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.types.PkgInstallTypes;
import org.tizen.nativeplatform.util.CharacterStripper;

public abstract class RpmCommanderCommon
implements IPkgCommander {
    protected final String PKGTYPE = "rpm";
    protected final String CONSOLE_NAME = "Platform Internal";
    protected final String CMD_DELIMITER = ";";
    protected final String LOG_COMMAND_PREFIX = "[command]";
    protected final String LOG_RESULT_PREFIX = "[result]";
    protected final String LOG_INFO_PREFIX = "[info]";
    protected final String NL = System.getProperty("line.separator");
    protected final String WS = " ";
    protected final String TMP_DIR = "/tmp";
    protected final String CMD_RESET_REPO = "rm -rf /etc/zypp/repos.d/*";
    protected final String CMD_RESET_RPM_DB = "rm -f /var/lib/rpm/__db*";
    protected final String CMD_FILE_FILE = "ls %s 2>/dev/null";
    protected final String CMD_EXPORT_PROXY = "export http_proxy=%s";
    protected final String CMD_READLINK = "/usr/bin/readlink -f %s";
    protected final Logger logger = LoggerFactory.getLogger(RpmCommanderCommon.class);
    protected String http_proxy;
    protected PackageManagerOutputReceiver rec;

    protected abstract PackageManagerOutputReceiver getNewOuputReceiver();

    @Override
    public abstract Map<String, PkgStatus> getLocalPkgList();

    @Override
    public abstract ICommandStatus copyFilesToTmpDir(String[] var1);

    @Override
    public abstract ICommandStatus copyFile(String var1, String var2);

    @Override
    public abstract ICommandStatus installLocalPkg(String[] var1, boolean var2, IProgressMonitor var3);

    @Override
    public abstract ICommandStatus installLocalPkg(String[] var1, String var2, IProgressMonitor var3);

    @Override
    public abstract ICommandStatus installRemotePkg(String[] var1, IProgressMonitor var2);

    protected abstract ICommandStatus execute(String var1, IProgressMonitor var2);

    protected abstract ICommandStatus execute(String var1, int var2, IProgressMonitor var3);

    protected abstract ICommandStatus execute(String var1, IProgressMonitor var2, boolean var3);

    protected abstract ICommandStatus execute(String var1, PackageManagerOutputReceiver var2, IProgressMonitor var3);

    protected abstract ICommandStatus execute(String var1, PackageManagerOutputReceiver var2, int var3, IProgressMonitor var4);

    protected abstract ICommandStatus execute(String var1, PackageManagerOutputReceiver var2, IProgressMonitor var3, boolean var4);

    protected abstract void changeUpdateMode();

    @Override
    public void actionBeforeUsingZypper() {
    }

    public RpmCommanderCommon() {
        this.setConsole(true, null);
    }

    public RpmCommanderCommon(boolean useConsoleLog, String consoleName) {
        this.setConsole(useConsoleLog, consoleName);
    }

    public RpmCommanderCommon(String consoleName) {
        this.setConsole(true, consoleName);
    }

    public void setConsole(boolean useConsoleLog, String consoleName) {
        if (useConsoleLog) {
            this.rec = consoleName != null && !consoleName.isEmpty() ? this.getNewOuputReceiver(consoleName) : this.getNewOuputReceiverWithConsole();
        }
    }

    @Override
    public PackageManagerOutputReceiver getOutputReceiver() {
        return this.rec;
    }

    @Override
    public void cancelExecution() {
        if (this.rec != null) {
            this.rec.setCancel(true);
        }
    }

    @Override
    public String getLogs() {
        if (this.rec == null || this.rec.getLog() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = this.rec.getLog();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String log = stringArray[n2];
            sb.append(log);
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public void setHttpProxy(String proxy) {
        if (proxy == null) {
            return;
        }
        this.http_proxy = proxy;
        this.printResultLog(String.format("Set proxy: %s", proxy));
    }

    @Override
    public String getArchFromRemoteFile(String filePath) {
        return "";
    }

    @Override
    public String getNameFromRemoteFile(String filePath) {
        return "";
    }

    @Override
    public String getVerFromRemoteFile(String filePath) {
        return "";
    }

    @Override
    public String[] getInfoFromFile(String filePath) {
        return null;
    }

    @Override
    public String getArchFromFile(String filePath) {
        return "";
    }

    @Override
    public String getNameFromFile(String filePath) {
        return "";
    }

    @Override
    public String getVerFromFile(String filePath) {
        return "";
    }

    @Override
    public String[] getArch(String pkg) {
        PackageManagerOutputReceiver hrec;
        String command = this.makeCommand(this.getResetRpmDb(), RpmTool.pkgArchCommand(pkg));
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        List<String> value = status.getValues();
        String arch = "";
        if (value != null && !value.isEmpty()) {
            arch = value.get(value.size() - 1);
            String[] stringArray = arch.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                result.add(s.trim());
                ++n2;
            }
        }
        if (!result.isEmpty()) {
            this.printResultLog(String.format("Checked arch: %s (%s)", arch, pkg));
        } else {
            this.printResultLog(String.format("Failed to get arch: (%s)", pkg));
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String[] getName(String pkg) {
        PackageManagerOutputReceiver hrec;
        String command = this.makeCommand(this.getResetRpmDb(), RpmTool.pkgNameCommand(pkg));
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            return null;
        }
        List<String> value = status.getValues();
        ArrayList<String> result = new ArrayList<String>();
        String name = "";
        if (value != null && !value.isEmpty()) {
            name = value.get(value.size() - 1);
            String[] stringArray = name.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                result.add(s.trim());
                ++n2;
            }
        }
        if (!result.isEmpty()) {
            this.printResultLog(String.format("Checked name: %s (%s)", name, pkg));
        } else {
            this.printResultLog(String.format("Failed to get name: (%s)", pkg));
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String[] getVer(String pkg) {
        return this.getVer(pkg, IPkgCommander.TOOL.RPM);
    }

    @Override
    public String[] getVer(String pkg, IPkgCommander.TOOL tool) {
        String version = "";
        ArrayList<String> result = new ArrayList<String>();
        if (tool.equals((Object)IPkgCommander.TOOL.ZYPPER)) {
            PackageManagerOutputReceiver hrec;
            String command = this.makeCommand(this.getResetRpmDb(), ZypperTool.versionCommand(pkg));
            ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
            if (!status.isOk()) {
                return new String[0];
            }
            List<String> value = status.getValues();
            if (value != null && !value.isEmpty() && (version = value.get(value.size() - 1)).startsWith("Version")) {
                String[] vers = version.split(" ");
                result.add(vers[vers.length - 1]);
            }
        } else if (tool.equals((Object)IPkgCommander.TOOL.RPM)) {
            PackageManagerOutputReceiver hrec;
            String command = this.makeCommand(this.getResetRpmDb(), RpmTool.pkgFullVerCommand(pkg));
            ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
            if (!status.isOk()) {
                return new String[0];
            }
            List<String> value = status.getValues();
            if (value != null && !value.isEmpty()) {
                version = value.get(value.size() - 1);
                String[] stringArray = version.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    result.add(s.trim());
                    ++n2;
                }
            }
        }
        if (!result.isEmpty()) {
            this.printResultLog(String.format("Checked version: %s (%s)", version, pkg));
        } else {
            this.printResultLog(String.format("Failed to get version: (%s)", pkg));
        }
        return result.toArray(new String[0]);
    }

    @Override
    public boolean is80386File(String filePath) {
        return false;
    }

    @Override
    public boolean isArmFile(String filePath) {
        return false;
    }

    @Override
    public ICommandStatus installLocalPkg(String file, IProgressMonitor monitor) {
        String[] files = new String[]{file};
        return this.installLocalPkg(files, false, monitor);
    }

    @Override
    public ICommandStatus installLocalPkg(String file, boolean isEfl, IProgressMonitor monitor) {
        String[] files = new String[]{file};
        return this.installLocalPkg(files, isEfl, monitor);
    }

    @Override
    public ICommandStatus installLocalPkg(String file, String tool, IProgressMonitor monitor) {
        String[] files = new String[]{file};
        return this.installLocalPkg(files, tool, monitor);
    }

    @Override
    public ICommandStatus installLocalPkg(String[] files, IProgressMonitor monitor) {
        return this.installLocalPkg(files, false, monitor);
    }

    @Override
    public ICommandStatus installRemotePkg(String pkg, IProgressMonitor monitor) {
        String[] pkgs = new String[]{pkg};
        return this.installRemotePkg(pkgs, monitor);
    }

    @Override
    public ICommandStatus uninstallPkg(String[] pkgs, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        String command = this.makeCommand(this.getResetRpmDb(), RpmTool.uninstallCommand(pkgs));
        ICommandStatus status = this.execute(command, monitor);
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        return status;
    }

    @Override
    public ICommandStatus uninstallPkg(String pkg, IProgressMonitor monitor) {
        String[] pkgs = new String[]{pkg};
        return this.uninstallPkg(pkgs, monitor);
    }

    private List<String> getPkgDependencies(String pkg) {
        ArrayList<String> result = new ArrayList<String>();
        String command = this.makeCommand(this.getResetRpmDb(), RpmTool.pkgRequiresCommand(pkg));
        ICommandStatus status = this.execute(command, null);
        if (status.isOk()) {
            List<String> value = status.getValues();
            for (String str : value) {
                if ((str = str.trim()).startsWith("spawn") || str.startsWith("[sudo]")) continue;
                result.add(str);
            }
        }
        return result;
    }

    private List<String> getPkgInstalledFiles(String pkg) {
        ArrayList<String> result = new ArrayList<String>();
        String command = this.makeCommand(this.getResetRpmDb(), RpmTool.installedFileListCommand(pkg));
        ICommandStatus status = this.execute(command, null);
        if (status.isOk()) {
            List<String> value = status.getValues();
            for (String str : value) {
                if ((str = str.trim()).startsWith("spawn") || str.startsWith("[sudo]")) continue;
                result.add(str);
            }
        }
        return result;
    }

    private PkgInfo parsePkgInfo(String pkg, IPkgCommander.TOOL type, List<String> log) {
        String name = "";
        String ver = "";
        String rel = "";
        String arch = "";
        String size = "";
        String repo = "";
        String vendor = "";
        String summary = "";
        String installed = "";
        boolean isInstalled = false;
        StringBuffer sbDesc = new StringBuffer();
        ArrayList<String> installedFiles = new ArrayList<String>();
        ArrayList<String> dependencies = new ArrayList<String>();
        boolean descStart = false;
        boolean requiresStart = false;
        for (String str : log) {
            String key;
            String[] strs = (str = str.trim()).split(":");
            if (strs.length > 1) {
                key = strs[0].trim();
                if (key.equals("Name")) {
                    name = strs[1] != null ? strs[1].trim() : "";
                } else if (key.equals("Version")) {
                    ver = strs[1] != null ? strs[1].trim() : "";
                } else if (key.equals("Release")) {
                    rel = strs[1] != null ? strs[1].trim() : "";
                } else if (key.equals("Arch") || key.equals("Architecture")) {
                    arch = strs[1] != null ? strs[1].trim() : "";
                } else if (key.equals("Installed Size") || key.equals("Size")) {
                    size = strs[1] != null ? strs[1].trim() : "";
                } else if (key.equals("Repository")) {
                    repo = strs[1] != null ? strs[1].trim() : "";
                } else if (key.equals("Vendor")) {
                    vendor = strs[1] != null ? strs[1].trim() : "";
                } else if (key.equals("Summary")) {
                    summary = strs[1] != null ? strs[1].trim() : "";
                } else if (key.equals("Installed")) {
                    installed = strs[1] != null ? strs[1].trim() : "";
                }
            } else if (strs.length == 1) {
                key = strs[0].trim();
                if (key.equals("Description")) {
                    descStart = true;
                    requiresStart = false;
                } else if (key.equals("Requires")) {
                    requiresStart = true;
                    descStart = false;
                }
            }
            if (descStart && !str.startsWith("Description")) {
                sbDesc.append(str);
            }
            if (!requiresStart || str.startsWith("Requires")) continue;
            dependencies.add(str);
        }
        if (type == IPkgCommander.TOOL.RPM) {
            isInstalled = true;
            dependencies.addAll(this.getPkgDependencies(pkg));
            installedFiles.addAll(this.getPkgInstalledFiles(pkg));
        } else if (type == IPkgCommander.TOOL.ZYPPER) {
            if (installed.equals("Yes")) {
                isInstalled = true;
            } else if (installed.equals("No")) {
                isInstalled = false;
            }
        }
        if (!rel.isEmpty()) {
            ver = String.valueOf(ver) + "-" + rel;
        }
        if (name.isEmpty()) {
            return null;
        }
        PkgInfo info = new PkgInfo().setName(name).setArch(arch).setVer(ver).setSize(size).setStatus(isInstalled).setRepo(repo).setVendor(vendor).setDesc(sbDesc.toString()).setSummary(summary).setDependencies(dependencies).setInstalledFiles(installedFiles);
        return info;
    }

    @Override
    public PkgInfo getPkgInfo(String pkg, IPkgCommander.TOOL type) {
        ICommandStatus status = null;
        if (type == IPkgCommander.TOOL.ZYPPER) {
            String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.pkgInfoCommand(pkg));
            PackageManagerOutputReceiver hrec = this.getNewOuputReceiver();
            status = this.execute(command, hrec, null);
        } else if (type == IPkgCommander.TOOL.RPM) {
            String command = this.makeCommand(this.getResetRpmDb(), RpmTool.pkgInfoCommand(pkg));
            status = this.execute(command, null);
        } else {
            return null;
        }
        if (!status.isOk()) {
            this.printResultLog("Failed to get remote package list");
            return null;
        }
        return this.parsePkgInfo(pkg, type, status.getValues());
    }

    @Override
    public List<PkgStatus> getAllPkgList() {
        Map<String, PkgStatus> pkgMap = this.getAllPkgMap();
        ArrayList<PkgStatus> list = new ArrayList<PkgStatus>();
        if (pkgMap != null && !pkgMap.isEmpty()) {
            for (Map.Entry<String, PkgStatus> set : pkgMap.entrySet()) {
                list.add(set.getValue());
            }
        }
        return list;
    }

    @Override
    public Map<String, PkgStatus> getAllPkgMap() {
        HashMap<String, PkgStatus> allPkgs = new HashMap<String, PkgStatus>();
        Map<String, PkgStatus> localPkgs = this.getLocalPkgList();
        Map<String, PkgStatus> remotePkgs = this.getRemotePkgList();
        if (remotePkgs != null) {
            allPkgs.putAll(remotePkgs);
        }
        if (localPkgs != null) {
            if (!allPkgs.isEmpty()) {
                for (Map.Entry<String, PkgStatus> e : localPkgs.entrySet()) {
                    String name = e.getKey();
                    if (remotePkgs != null && remotePkgs.containsKey(name)) {
                        PkgStatus pkg = remotePkgs.get(name);
                        if (pkg.isInstalled()) continue;
                        PkgStatus lpkg = e.getValue();
                        pkg.setInstalledVer(lpkg.getInstalledVer());
                        allPkgs.remove(name);
                        allPkgs.put(name, pkg);
                        continue;
                    }
                    allPkgs.put(name, e.getValue());
                }
            } else {
                allPkgs.putAll(localPkgs);
            }
        }
        this.printResultLog(String.format("Get all package list: %d", allPkgs.size()));
        return allPkgs;
    }

    @Override
    public Map<String, PkgStatus> getRemotePkgList() {
        ICommandStatus status;
        if (!this.checkPkgInstalled("zypper")) {
            this.printResultLog("\"zypper\" package does not installed.");
            return null;
        }
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.remotePkgListCommandWithXmlOut());
        PackageManagerOutputReceiver hrec = this.getNewOuputReceiver();
        ICommandStatus setDnsInfoStatus = this.copyFile("/etc/resolv.conf", "/etc/resolv.conf");
        if (!setDnsInfoStatus.isOk()) {
            this.printResultLog("Failed to copy resolv.conf file");
        }
        if (!(status = this.execute(command, hrec, 10000, null)).isOk()) {
            this.printResultLog("Failed to get remote package list");
            return null;
        }
        Map<String, PkgStatus> result = null;
        List<String> value = status.getValues();
        if (value != null && value.size() > 0) {
            String xml = this.makeNewlineString(value);
            ZypperXmlParser parser = new ZypperXmlParser();
            parser.setDoc(xml);
            String log = parser.getAllMessages();
            this.printLog(log);
            result = parser.getPkgList();
        }
        if (result != null) {
            this.printResultLog(String.format("Get remote package list: %d", result.size()));
        } else {
            this.printResultLog("Failed to get remote package list");
        }
        return result;
    }

    public Map<String, PkgStatus> getLocalPkgList(String tag) {
        String[] splitStr;
        PackageManagerOutputReceiver hrec;
        String command = this.makeCommand(this.getResetRpmDb(), RpmTool.pkgListByTagCommand(tag));
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            this.printResultLog("Failed to get local package list");
            return null;
        }
        HashMap<String, PkgStatus> pkgMap = new HashMap<String, PkgStatus>();
        List<String> value = status.getValues();
        String content = "";
        if (value != null && value.size() > 0) {
            for (String s : value) {
                if (!(s = s.trim()).startsWith("<pkg>")) continue;
                content = s;
                break;
            }
        }
        String[] stringArray = splitStr = content.split("</pkg>");
        int n = splitStr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] part = (s = s.replaceAll(" ", "").replaceAll("<pkg>", "")).split(",");
            if (part.length == 3) {
                String name = part[0];
                String version = part[1];
                String arch = part[2];
                Package pkg = new Package(name, version, arch);
                PkgStatus origStatus = (PkgStatus)pkgMap.get(name);
                if (origStatus == null) {
                    PkgStatus newStatus = new PkgStatus(pkg);
                    newStatus.setInstalledVer(version);
                    newStatus.setInstallInfo(PkgInstallTypes.INSTALLED);
                    pkgMap.put(name, newStatus);
                } else {
                    origStatus.setInstalledVer(version);
                    origStatus.setInstallInfo(PkgInstallTypes.INSTALLED);
                }
            }
            ++n2;
        }
        this.printResultLog(String.format("Get local package list: %d", pkgMap.size()));
        return pkgMap;
    }

    @Override
    public List<Repository> getRepoList() {
        PackageManagerOutputReceiver hrec;
        List<Repository> result = new ArrayList<Repository>();
        if (!this.checkPkgInstalled("zypper")) {
            this.printResultLog("Failed to get repository list. \"zypper\" package is not installed");
            return result;
        }
        String command = this.makeCommand(this.getResetRpmDb(), ZypperTool.repoListCommandXmlOut());
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            this.printResultLog("Failed to get repository list");
            return result;
        }
        List<String> value = status.getValues();
        if (value != null && value.size() > 0) {
            String xml = this.makeNewlineString(value);
            ZypperXmlParser parser = new ZypperXmlParser();
            parser.setDoc(xml);
            String log = parser.getAllMessages();
            this.printLog(log);
            result = parser.getRepoList();
        }
        if (result != null) {
            this.printResultLog(String.format("Get repository list: %d", result.size()));
        } else {
            this.printResultLog("Failed to get repository list");
        }
        return result;
    }

    public ICommandStatus refreshRepoListXmlOut() {
        PackageManagerOutputReceiver hrec;
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.refreshRepoCommandXmlOut());
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), 10000, null);
        if (status == null || !status.isOk()) {
            this.printResultLog("Failed to refresh repository");
        } else {
            List<String> value = status.getValues();
            if (value != null && value.size() > 0) {
                String xml = this.makeNewlineString(value);
                ZypperXmlParser parser = new ZypperXmlParser();
                parser.setDoc(xml);
                String log = parser.getAllMessages();
                this.printLog(log);
            }
        }
        return status;
    }

    @Override
    public ICommandStatus refreshRepoList() {
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.refreshRepoCommand());
        ICommandStatus status = this.execute(command, 10000, null);
        if (status == null || !status.isOk()) {
            this.printResultLog("Failed to refresh repository");
        }
        return status;
    }

    private ICommandStatus addRepoXmlOut(String name, String url) {
        PackageManagerOutputReceiver hrec;
        String command = ZypperTool.addRemoteRepoCommandXmlOut(name, url);
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            this.printResultLog("Failed to add repository");
        } else {
            List<String> value = status.getValues();
            if (value != null && value.size() > 0) {
                String xml = this.makeNewlineString(value);
                ZypperXmlParser parser = new ZypperXmlParser();
                parser.setDoc(xml);
                String log = parser.getAllMessages();
                this.printLog(log);
            }
        }
        return status;
    }

    @Override
    public ICommandStatus addRepo(String name, String url) {
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.addRemoteRepoCommand(name, url));
        ICommandStatus status = this.execute(command, null);
        if (!status.isOk()) {
            this.printResultLog("Failed to add repository");
        }
        return status;
    }

    public ICommandStatus addLocalRepoXmlOut(String name, String path) {
        PackageManagerOutputReceiver hrec;
        String command = ZypperTool.addLocalRepoCommandXmlOut(name, path);
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            this.printResultLog("Failed to add local repository");
        } else {
            List<String> value = status.getValues();
            if (value != null && value.size() > 0) {
                String xml = this.makeNewlineString(value);
                ZypperXmlParser parser = new ZypperXmlParser();
                parser.setDoc(xml);
                String log = parser.getAllMessages();
                this.printLog(log);
            }
        }
        return status;
    }

    @Override
    public ICommandStatus addLocalRepo(String name, String path) {
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.addLocalRepoCommand(name, path));
        ICommandStatus status = this.execute(command, null);
        if (!status.isOk()) {
            this.printResultLog("Failed to add local repository");
        }
        return status;
    }

    public ICommandStatus removeRepoXmlOut(String name) {
        PackageManagerOutputReceiver hrec;
        String command = ZypperTool.removeRepoCommandXmlOut(name);
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            this.printResultLog("Failed to remove repository");
        } else {
            List<String> value = status.getValues();
            if (value != null && value.size() > 0) {
                String xml = this.makeNewlineString(value);
                ZypperXmlParser parser = new ZypperXmlParser();
                parser.setDoc(xml);
                String log = parser.getAllMessages();
                this.printLog(log);
            }
        }
        return status;
    }

    @Override
    public ICommandStatus removeRepo(String name) {
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.removeRepoCommand(name));
        ICommandStatus status = this.execute(command, null);
        if (!status.isOk()) {
            this.printResultLog("Failed to add repository");
        }
        return status;
    }

    @Override
    public boolean checkPkgInstalled(String pkg) {
        PackageManagerOutputReceiver hrec;
        boolean ret = false;
        String command = this.makeCommand(this.getResetRpmDb(), RpmTool.pkgListCommand(pkg));
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            return ret;
        }
        List<String> value = status.getValues();
        if (value != null) {
            for (String s : value) {
                if (!s.trim().startsWith(pkg)) continue;
                ret = true;
                pkg = s;
                break;
            }
        }
        if (ret) {
            this.printResultLog(String.format("Checked package: %s", pkg));
        } else {
            this.printResultLog(String.format("Failed to check package: %s", pkg));
        }
        return ret;
    }

    @Override
    public boolean existsFile(String file) {
        PackageManagerOutputReceiver hrec;
        boolean ret = false;
        String command = String.format("ls %s 2>/dev/null", file);
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null, false);
        if (status == null || !status.isOk()) {
            return ret;
        }
        List<String> value = status.getValues();
        if (value != null) {
            for (String s : value) {
                if (!s.trim().equals(file)) continue;
                ret = true;
                break;
            }
        }
        if (ret) {
            this.printResultLog(String.format("Checked file: %s", file));
        } else {
            this.printResultLog(String.format("Failed to check file: %s", file));
        }
        return ret;
    }

    @Override
    public String canonicalizePath(String path) {
        PackageManagerOutputReceiver hrec;
        String command = String.format("/usr/bin/readlink -f %s", path);
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null, false);
        if (status == null || !status.isOk()) {
            return null;
        }
        List<String> value = status.getValues();
        if (value != null) {
            for (String s : value) {
                String resultPath = s.trim();
                if (!this.existsFile(resultPath)) continue;
                return resultPath;
            }
        }
        return null;
    }

    @Override
    public void resetRepo() {
        PackageManagerOutputReceiver hrec;
        String command = this.makeCommand("rm -rf /etc/zypp/repos.d/*");
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            this.printResultLog("Failed to reset repository");
        }
        this.printResultLog("Reset repository");
    }

    private Map<String, PkgStatus> getWhatProvidesWithZypper(String capability) {
        String command = this.makeCommand(this.getProxyCommand(), ZypperTool.whatProvideCommandXmlOut(capability));
        PackageManagerOutputReceiver hrec = this.getNewOuputReceiver();
        ICommandStatus status = this.execute(command, hrec, 10000, null);
        Map<String, PkgStatus> result = null;
        if (status == null || !status.isOk()) {
            return result;
        }
        List<String> value = status.getValues();
        if (value != null && value.size() > 0) {
            String xml = this.makeNewlineString(value);
            ZypperXmlParser parser = new ZypperXmlParser();
            parser.setDoc(xml);
            String log = parser.getAllMessages();
            this.printLog(log);
            result = parser.getWhatProvideList();
        }
        if (result != null) {
            this.printResultLog(String.format("Get what provides of %s", capability));
        } else {
            this.printResultLog(String.format("Failed to get what provides of %s", capability));
        }
        return result;
    }

    private Map<String, PkgStatus> getWhatProvidesWithRpm(String capability) {
        String command = this.makeCommand(RpmTool.whatProvideCommand(capability));
        ICommandStatus status = this.execute(command, null, true);
        HashMap<String, PkgStatus> result = new HashMap<String, PkgStatus>();
        if (status == null || !status.isOk()) {
            return result;
        }
        List<String> values = status.getValues();
        String pkgName = "";
        String pkgVersion = "";
        String pkgArchitecture = "";
        if (values != null && values.size() > 0) {
            for (String s : values) {
                int index = s.indexOf(58);
                if (index < 0) continue;
                String key = s.substring(0, index).trim();
                String value = s.substring(index + 1).trim();
                if (key.equals("Name")) {
                    pkgName = value;
                    continue;
                }
                if (key.equals("Version")) {
                    pkgVersion = value;
                    continue;
                }
                if (key.equals("Architecture")) {
                    pkgArchitecture = value;
                    continue;
                }
                if (!key.equals("Release") || value.isEmpty()) continue;
                pkgVersion = String.valueOf(pkgVersion) + "-" + value;
            }
        }
        Package pkg = new Package(pkgName, pkgVersion, pkgArchitecture);
        PkgStatus newStatus = new PkgStatus(pkg);
        newStatus.setInstalledVer(pkgVersion);
        newStatus.setInstallInfo(PkgInstallTypes.INSTALLED);
        result.put(pkgName, newStatus);
        return result;
    }

    @Override
    public Map<String, PkgStatus> getWhatProvides(String capability, IPkgCommander.TOOL type) {
        if (type == IPkgCommander.TOOL.ZYPPER) {
            return this.getWhatProvidesWithZypper(capability);
        }
        if (type == IPkgCommander.TOOL.RPM) {
            return this.getWhatProvidesWithRpm(capability);
        }
        return null;
    }

    @Override
    public PkgInstallTypes searchPkg(String pkg) {
        pkg = String.format("/^%s$/", pkg);
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.searchPkgCommandWithXmlOut(pkg));
        PackageManagerOutputReceiver hrec = this.getNewOuputReceiver();
        ICommandStatus status = this.execute(command, hrec, null);
        PkgInstallTypes result = PkgInstallTypes.NOT_EXISTS;
        if (!status.isOk()) {
            this.printResultLog("Failed to get remote package list");
            return result;
        }
        List<String> value = status.getValues();
        if (value != null && value.size() > 0) {
            String xml = this.makeNewlineString(value);
            ZypperXmlParser parser = new ZypperXmlParser();
            parser.setDoc(xml);
            String log = parser.getSolvableMessages();
            if (log.equals("installed")) {
                result = PkgInstallTypes.INSTALLED;
            } else if (log.equals("not-installed")) {
                result = PkgInstallTypes.NOT_INSTALLED;
            }
        }
        return result;
    }

    @Override
    public String getSrcPkgName(String pkg) {
        PackageManagerOutputReceiver hrec;
        String tag = "INFO:%{SourceRPM}::%{Version}-%{Release}";
        String command = this.makeCommand(this.getResetRpmDb(), RpmTool.aPkgInfoByTagCommand(tag, pkg));
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), null);
        if (!status.isOk()) {
            return "";
        }
        List<String> value = status.getValues();
        if (value != null && !value.isEmpty()) {
            String info = value.get(value.size() - 1);
            if (!info.startsWith("INFO:")) {
                return "";
            }
            String content = info.substring(5);
            String[] splited = content.split("::");
            if (splited.length != 2) {
                return "";
            }
            String srcPkg = splited[0];
            String version = splited[1];
            int idx = srcPkg.indexOf(version);
            String result = srcPkg.substring(0, idx - 1);
            return result;
        }
        return "";
    }

    private ICommandStatus upgradeXmlOut(IProgressMonitor monitor) {
        PackageManagerOutputReceiver hrec;
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.distUpgradeCommandXmlOut());
        ICommandStatus status = this.execute(command, hrec = this.getNewOuputReceiver(), monitor);
        if (!status.isOk()) {
            this.printResultLog("Failed to upgrade dist");
        } else {
            List<String> value = status.getValues();
            if (value != null && value.size() > 0) {
                String xml = this.makeNewlineString(value);
                ZypperXmlParser parser = new ZypperXmlParser();
                parser.setDoc(xml);
                String log = parser.getAllMessages();
                this.printLog(log);
            }
        }
        return status;
    }

    @Override
    public ICommandStatus upgrade(IProgressMonitor monitor) {
        String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.distUpgradeCommand());
        ICommandStatus status = this.execute(command, null);
        if (!status.isOk()) {
            this.printResultLog("Failed to upgrade dist");
        }
        return status;
    }

    protected String getResetRpmDb() {
        return "rm -f /var/lib/rpm/__db*";
    }

    protected String getProxyCommand() {
        if (this.http_proxy != null && !this.http_proxy.isEmpty()) {
            return String.format("export http_proxy=%s", this.http_proxy);
        }
        return "";
    }

    protected String getResultString(String msg) {
        return "[result] " + msg;
    }

    protected String getInfoString(String msg) {
        return "[info] " + msg;
    }

    protected PackageManagerOutputReceiver getNewOuputReceiverWithConsole() {
        return this.getNewOuputReceiver("Platform Internal");
    }

    protected PackageManagerOutputReceiver getNewOuputReceiver(String consoleName) {
        ConsoleManager cm = new ConsoleManager(consoleName, true);
        MessageConsoleStream mcs = cm.getMessageConsoleStream();
        PackageManagerOutputReceiver rec = new PackageManagerOutputReceiver();
        rec.setMessageConsoleStream(mcs);
        return rec;
    }

    protected String makeNewlineString(List<String> list) {
        StringBuffer sbXml = new StringBuffer();
        for (String s : list) {
            sbXml.append(String.valueOf(s) + this.NL);
        }
        String stripXml = CharacterStripper.stripShellEscapseSequence(CharacterStripper.stripInvalidXMLChar(sbXml.toString()));
        return stripXml;
    }

    protected void printLog(String log) {
        if (this.rec == null) {
            return;
        }
        if (log.isEmpty()) {
            return;
        }
        this.rec.setPrintConsole(true);
        this.rec.processNewLines(log.split(this.NL));
    }

    protected void printResultLog(String log) {
        this.printLog(this.getResultString(log));
    }

    protected void pringInfoLog(String log) {
        this.printLog(this.getInfoString(log));
    }

    protected void activateConsole() {
        if (this.rec != null) {
            this.rec.getMsgConsoleStream().getConsole().activate();
        }
    }

    protected void printCommandLog(String command) {
        if (this.rec == null) {
            return;
        }
        String[] log = new String[]{String.valueOf(this.NL) + "[command]" + " " + command};
        this.activateConsole();
        this.rec.setPrintConsole(true);
        this.rec.processNewLines(log);
    }

    protected String makeCommand(String ... cmds) {
        StringBuffer sbCommand = new StringBuffer();
        int size = cmds.length;
        int i = 0;
        while (i < size) {
            String cmd = cmds[i];
            if (!(cmd = cmd.trim()).isEmpty()) {
                if (i != size - 1) {
                    cmd = cmd.endsWith(";") ? cmd : String.valueOf(cmd) + ";";
                }
                sbCommand.append(cmd);
            }
            ++i;
        }
        return sbCommand.toString();
    }

    @Override
    public ICommandStatus unCompressArchivedFile(String rdsFiles) {
        return null;
    }
}

