/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.commander.rpm;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativeplatform.pkg.commander.IPkgVersionComparer;

public class RpmVersionComparer
implements IPkgVersionComparer {
    @Override
    public int compare(String ver1, String ver2) {
        List<String> tokList1 = RpmVersionComparer.tokenizeVersionString(ver1);
        List<String> tokList2 = RpmVersionComparer.tokenizeVersionString(ver2);
        int maxTokens = tokList1.size() > tokList2.size() ? tokList1.size() : tokList2.size();
        int i = 0;
        while (i < maxTokens) {
            if (i == tokList1.size()) {
                return -1;
            }
            if (i == tokList2.size()) {
                return 1;
            }
            String tok1 = tokList1.get(i);
            String tok2 = tokList2.get(i);
            int value1 = -1;
            int value2 = -1;
            try {
                value1 = Integer.parseInt(tok1);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                value2 = Integer.parseInt(tok2);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            if (value1 > value2) {
                return 1;
            }
            if (value1 < value2) {
                return -1;
            }
            int result = tok1.compareTo(tok2);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    private static List<String> tokenizeVersionString(String ver) {
        ArrayList<String> result = new ArrayList<String>();
        int oldStatus = 2;
        String buf = "";
        int i = 0;
        while (i < ver.length()) {
            char c = ver.charAt(i);
            int newStatus = c >= '0' && c <= '9' ? 0 : (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' ? 1 : 2);
            if (oldStatus != newStatus) {
                if (!buf.isEmpty()) {
                    result.add(buf);
                }
                buf = newStatus != 2 ? String.valueOf(c) : "";
                oldStatus = newStatus;
            } else if (newStatus != 2) {
                buf = String.valueOf(buf) + String.valueOf(c);
            }
            ++i;
        }
        if (!buf.isEmpty()) {
            result.add(buf);
        }
        return result;
    }
}

