/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.pkgmgr.ui.RepoCommonDialog;
import org.tizen.nativeplatform.repo.commander.RepoManager;

public class AddRepoDialog
extends RepoCommonDialog {
    private String url = null;

    protected AddRepoDialog(Shell parentShell) {
        super(parentShell);
    }

    public AddRepoDialog(Shell parentShell, String tab, boolean supportLocalRepo) {
        super(parentShell);
        this.supportLocalRepo = supportLocalRepo;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell, this.resources.getString("AddRepo.Title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createRepoComposite(parent);
        return composite;
    }

    @Override
    protected void initControls() {
        this.remoteCheckBt.setSelection(true);
        this.remoteText.setEnabled(true);
        if (this.supportLocalRepo) {
            this.localCheckBt.setSelection(false);
            this.localText.setEnabled(false);
            this.browseBt.setEnabled(false);
        }
    }

    protected void okPressed() {
        if (this.remoteCheckBt.getSelection()) {
            this.url = this.remoteText.getText();
            if (this.url == null || this.url.isEmpty()) {
                DialogUtil.openErrorDialog((String)this.resources.getString("AddRepo.Msg.Error.URLEmpty"));
                return;
            }
            this.type = RepoManager.REMOTE_REPO_TYPE;
        } else if (this.localCheckBt.getSelection()) {
            this.url = this.localText.getText();
            if (this.url == null || this.url.isEmpty()) {
                DialogUtil.openErrorDialog((String)this.resources.getString("AddRepo.Msg.Error.URLEmpty"));
                return;
            }
            this.type = RepoManager.LOCAL_REPO_TYPE;
        }
        this.url = this.url.trim();
        super.okPressed();
    }

    public String getRepositoryURL() {
        return this.url;
    }
}

