/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.tizen.common.util.HostUtil;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;

public class CommonBuildCommandUtil {
    public static int LIMIT_COMMAND_LENGTH = 800;

    public static Process createProcess(String command, String workingDir, Map<String, String> newEnv, boolean includeStdErr) throws InterruptedException {
        Process proc;
        String[] fullCommand = HostUtil.getCommand((String)command);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.redirectErrorStream(includeStdErr);
        pb.command(fullCommand);
        if (newEnv != null) {
            pb.environment().clear();
            pb.environment().putAll(newEnv);
        }
        if (workingDir != null) {
            pb.directory(new File(workingDir));
        }
        try {
            proc = pb.start();
        }
        catch (IOException e) {
            throw new InterruptedException(String.format("Creating process failed! : %s => %s", command, e.getMessage()));
        }
        return proc;
    }

    public static String[] splitCommandArgs(String args) {
        ArrayList<String> argList = new ArrayList<String>();
        if (args.length() > LIMIT_COMMAND_LENGTH) {
            String[] splited = args.split("' ");
            StringBuffer newArgs = new StringBuffer();
            int length = splited.length;
            int i = 0;
            while (i < length) {
                String arg = splited[i];
                if (i == length - 1) {
                    newArgs.append(arg);
                } else if (newArgs.length() < LIMIT_COMMAND_LENGTH) {
                    newArgs.append(arg).append("' ");
                } else {
                    newArgs.append(arg).append("'");
                    newArgs.length();
                    argList.add(newArgs.toString());
                    newArgs = new StringBuffer();
                }
                ++i;
            }
            if (newArgs.length() > 0) {
                argList.add(newArgs.toString());
            }
        } else {
            argList.add(args);
        }
        return argList.toArray(new String[0]);
    }

    public static String getRandomNum() {
        Random rd = new Random();
        rd.setSeed(System.currentTimeMillis());
        int value = rd.nextInt(Integer.MAX_VALUE);
        return Integer.toString(value);
    }

    public static boolean verifySudoPasswd(String passwd) {
        boolean result;
        block4: {
            if (passwd == null || passwd.isEmpty()) {
                return false;
            }
            String scriptFile = PlatformInstances.getScriptProvider().getSudoAskScript(passwd);
            if (scriptFile == null) {
                return false;
            }
            result = false;
            try {
                String command = String.format("SUDO_ASKPASS=\"%s\" sudo -A -k true", scriptFile);
                result = HostCommandLauncher.execute(command);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                if (scriptFile == null) break block4;
                PlatformInstances.getScriptProvider().cleanUpScript(scriptFile);
            }
        }
        return result;
    }
}

