/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;

public class PlatformConfigurationEnvVarSupplier
implements IConfigurationEnvironmentVariableSupplier {
    public final String ENV_PATH_DELIMITER_WINDOWS = ";";
    public final String ENV_PATH_DELIMITER_LINUX = ":";

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        if (variableName.equals("SBI_SYSROOT")) {
            String basePath = PlatformConfigurationManager.getRootstrapPath((IConfiguration)configuration);
            String sysrootPath = "";
            sysrootPath = OSChecker.isWindows() ? basePath : sbi.getPlatformRootstrapPath(basePath);
            if (sysrootPath == null) {
                sysrootPath = "";
            }
            return new BuildEnvVar("SBI_SYSROOT", sysrootPath, 1, null);
        }
        if (variableName.equals("BUILD_TYPE")) {
            String buildtype = "";
            buildtype = configuration.getBaseId().contains("org.tizen.nativeide.config.sbi.gcc45.platform.debug") ? "Debug" : (configuration.getBaseId().contains("org.tizen.nativeide.config.sbi.gcc45.platform.release") ? "Release" : "");
            return new BuildEnvVar("BUILD_TYPE", buildtype, 1, null);
        }
        if (variableName.equals("TOOLCHAIN_PREFIX")) {
            String target = PlatformConfigurationManager.getBuildTargetName((IConfiguration)configuration);
            if (target == null) {
                return null;
            }
            String toolchain = sbi.getToolchainIDFromTargetID(target);
            String value = SmartBuildInterface.getInstance().getToolchainPropertyValue(toolchain, "TOOLCHAIN_PREFIX");
            return new BuildEnvVar("TOOLCHAIN_PREFIX", value, 1, null);
        }
        if (variableName.equals("MSYSBIN_PATH")) {
            String msysBinPath = this.getEnvMsysBinPath();
            return new BuildEnvVar("MSYSBIN_PATH", msysBinPath, 1, null);
        }
        if (variableName.equals("PATH")) {
            String path = this.getEnvPath();
            return new BuildEnvVar("PATH", path, 1, null);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        String[] buildEnvs;
        String[] envs;
        ArrayList<IBuildEnvironmentVariable> list = new ArrayList<IBuildEnvironmentVariable>();
        String[] stringArray = envs = (buildEnvs = new String[]{"SBI_SYSROOT", "BUILD_TYPE", "TOOLCHAIN_PREFIX", "PATH", "MSYSBIN_PATH"});
        int n = envs.length;
        int n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            list.add(this.getVariable(env, configuration, provider));
            ++n2;
        }
        return list.toArray(new IBuildEnvironmentVariable[0]);
    }

    private String getEnvPath() {
        if (OSChecker.isWindows()) {
            return "${MSYSBIN_PATH};${PATH}";
        }
        return "${PATH}";
    }

    private String getEnvMsysBinPath() {
        return SmartBuildInterface.getInstance().getMsysBinPath();
    }
}

