/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformLaunchWizard;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;

public class PlatformEFLLaunchSettingPage
extends PlatformLaunchSettingPage {
    private final String BUNDLE_NAME = String.valueOf(PlatformEFLLaunchSettingPage.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private String[] appId;
    private String[] executablePath;
    private String prevAppId = "";
    private String prevExec = "";
    private String appIdLabelText;
    private Combo appIdCombo;

    public PlatformEFLLaunchSettingPage(PlatformLaunchWizard wizard, Shell shell, String pageName, IProject project, IConfiguration config, PkgCommandTarget cmdTarget, String mode) {
        super(wizard, shell, pageName, project, config, cmdTarget, mode);
        this.appId = PlatformLaunchUtil.getAppId((IProject)project);
        this.executablePath = PlatformLaunchUtil.getProgramPath((IProject)project);
        if (this.appId != null && this.appId.length > 0) {
            this.prevAppId = this.appId[0];
        }
        if (this.executablePath != null && this.executablePath.length > 0) {
            this.prevExec = this.executablePath[0];
        }
        if (this.isDebug) {
            this.commandInitText = this.prevExec;
            this.appIdLabelText = "Application to be debug:";
        } else {
            this.commandInitText = "/usr/bin/launch_app";
            this.argumentsInitText = this.prevAppId;
            this.appIdLabelText = "Application to be run:";
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.createInfoComposite(composite);
        this.createAppComboComposite(composite);
        this.createRunCommandComposite(composite, false);
        if (this.isDebug) {
            this.createDebugOptionComposite(composite, false);
        }
        this.setControl((Control)composite);
    }

    private void createAppComboComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label appIdLabel = new Label(composite, 0);
        appIdLabel.setText(this.appIdLabelText);
        this.appIdCombo = new Combo(composite, 8);
        GridData gridData = new GridData(768);
        this.appIdCombo.setLayoutData((Object)gridData);
        this.appIdCombo.setItems(this.appId);
        this.appIdCombo.select(0);
        this.appIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String newAppId = ((Combo)evt.getSource()).getText();
                int index = ((Combo)evt.getSource()).getSelectionIndex();
                String newExec = PlatformEFLLaunchSettingPage.this.executablePath[index];
                String command = PlatformEFLLaunchSettingPage.this.commandText.getText().trim();
                String args = PlatformEFLLaunchSettingPage.this.argumentsText.getText().trim();
                if (!PlatformEFLLaunchSettingPage.this.prevAppId.equals(newAppId)) {
                    String newArgs;
                    String newCommand = PlatformLaunchUtil.changeCommand((String)command, (String)PlatformEFLLaunchSettingPage.this.prevAppId, (String)PlatformEFLLaunchSettingPage.this.prevExec, (String)newAppId, (String)newExec);
                    if (newCommand != null) {
                        PlatformEFLLaunchSettingPage.this.commandText.setText(newCommand);
                    }
                    if ((newArgs = PlatformLaunchUtil.changeCommand((String)args, (String)PlatformEFLLaunchSettingPage.this.prevAppId, (String)PlatformEFLLaunchSettingPage.this.prevExec, (String)newAppId, (String)newExec)) != null) {
                        PlatformEFLLaunchSettingPage.this.argumentsText.setText(newArgs);
                    }
                    PlatformEFLLaunchSettingPage.this.prevAppId = newAppId;
                    PlatformEFLLaunchSettingPage.this.prevExec = newExec;
                }
            }
        });
    }

    @Override
    public String getSelectedApp() {
        return this.appIdCombo.getText();
    }
}

