/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.pkg.model.PkgStatus;

public class PackageTableSelectionAdapter
extends SelectionAdapter {
    private TableViewer pkgViewer;
    private int selectedColumn = 0;

    public PackageTableSelectionAdapter(TableViewer v) {
        this.pkgViewer = v;
    }

    public void widgetSelected(SelectionEvent e) {
        this.selectedColumn = this.pkgViewer.getTable().indexOf((TableColumn)e.widget);
        this.pkgViewer.getTable().setSortColumn((TableColumn)e.widget);
        if (this.pkgViewer.getTable().getSortDirection() == 1024) {
            this.pkgViewer.getTable().setSortDirection(128);
        } else {
            this.pkgViewer.getTable().setSortDirection(1024);
        }
        this.pkgViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int result = 0;
                PkgStatus status_1 = (PkgStatus)e1;
                PkgStatus status_2 = (PkgStatus)e2;
                IPackage pkg_1 = status_1.getPackage();
                IPackage pkg_2 = status_2.getPackage();
                switch (PackageTableSelectionAdapter.this.selectedColumn) {
                    case 1: {
                        if (PackageTableSelectionAdapter.this.pkgViewer.getTable().getSortDirection() == 1024) {
                            result = pkg_1.getName().compareTo(pkg_2.getName());
                            break;
                        }
                        result = pkg_2.getName().compareTo(pkg_1.getName());
                        break;
                    }
                    case 2: {
                        if (PackageTableSelectionAdapter.this.pkgViewer.getTable().getSortDirection() == 1024) {
                            result = status_1.getInstalledVer().compareTo(status_2.getInstalledVer());
                            break;
                        }
                        result = status_2.getInstalledVer().compareTo(status_1.getInstalledVer());
                        break;
                    }
                    case 3: {
                        if (PackageTableSelectionAdapter.this.pkgViewer.getTable().getSortDirection() == 1024) {
                            result = status_1.getNewVer().compareTo(status_2.getNewVer());
                            break;
                        }
                        result = status_2.getNewVer().compareTo(status_1.getNewVer());
                        break;
                    }
                    case 4: {
                        if (PackageTableSelectionAdapter.this.pkgViewer.getTable().getSortDirection() == 1024) {
                            result = pkg_1.getArch().compareTo(pkg_2.getArch());
                            break;
                        }
                        result = pkg_2.getArch().compareTo(pkg_1.getArch());
                        break;
                    }
                }
                return result;
            }
        });
        this.updateCheck();
    }

    private void updateCheck() {
        int recentTableIndex = this.pkgViewer.getTable().getItemCount();
        int i = 0;
        while (i < recentTableIndex) {
            TableItem item = this.pkgViewer.getTable().getItem(i);
            PkgStatus pkg = (PkgStatus)item.getData();
            item.setChecked(pkg.isChecked());
            ++i;
        }
    }
}

