/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.repo.commander;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.nativeplatform.filefilter.RpmFileFilter;
import org.tizen.nativeplatform.repo.commander.IRepoValidator;

public class LocalRepoValidator
implements IRepoValidator {
    private IPath path = null;

    public LocalRepoValidator(IPath path) {
        this.path = path;
    }

    public LocalRepoValidator(String path) {
        if (path != null) {
            this.path = new Path(path);
        }
    }

    @Override
    public boolean validate() {
        File repoDir = this.path.toFile();
        if (!repoDir.isDirectory()) {
            return false;
        }
        File dataDir = this.path.append("repodata").toFile();
        if (!dataDir.exists()) {
            return false;
        }
        String[] files = repoDir.list(new RpmFileFilter());
        return files.length != 0;
    }

    @Override
    public List<String> availableArchs() {
        File repoDir = this.path.toFile();
        if (!repoDir.isDirectory()) {
            return null;
        }
        String[] files = repoDir.list(new RpmFileFilter());
        if (files.length == 0) {
            return null;
        }
        ArrayList<String> archs = new ArrayList<String>();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            int dotIndex = f.lastIndexOf(46);
            f = f.substring(0, dotIndex);
            dotIndex = f.lastIndexOf(46);
            if (!archs.contains(f = f.substring(dotIndex + 1))) {
                archs.add(f);
            }
            ++n2;
        }
        if (archs.size() == 0) {
            return null;
        }
        return archs;
    }
}

