/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.repo.commander;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IPath;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.repo.commander.IRepoValidator;
import org.tizen.nativeplatform.repo.commander.LocalRepoMounter;
import org.tizen.nativeplatform.repo.commander.LocalRepoValidator;
import org.tizen.nativeplatform.repo.commander.RemoteRepoValidator;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.repo.model.RepositoryProvider;
import org.tizen.nativeplatform.types.CmdTargetTypes;

public class RepoManager {
    public static String REMOTE_REPO_TYPE = "remote";
    public static String LOCAL_REPO_TYPE = "local";

    public static IRepoValidator getValidator(IPath path) {
        return new LocalRepoValidator(path);
    }

    public static IRepoValidator getValidator(String url) {
        if (RepoManager.isLocalUrl(url)) {
            return new LocalRepoValidator(url);
        }
        return new RemoteRepoValidator(url);
    }

    public static boolean isRemoteUrl(String url) {
        return !RepoManager.isLocalUrl(url);
    }

    public static boolean isLocalUrl(String url) {
        return url.startsWith("/") || url.startsWith("file:/") || url.startsWith("file://") || url.startsWith("dir:/") || url.startsWith("dir://") || url.startsWith("~/");
    }

    public static String getURLType(String url) {
        if (RepoManager.isLocalUrl(url)) {
            return LOCAL_REPO_TYPE;
        }
        return REMOTE_REPO_TYPE;
    }

    public static boolean isLocalType(String type) {
        boolean result = LOCAL_REPO_TYPE.equals(type.trim());
        return result;
    }

    public static boolean isRemoteType(String type) {
        boolean result = REMOTE_REPO_TYPE.equals(type.trim());
        return result;
    }

    public static List<Repository> createRepoList(List<String> repos) {
        ArrayList<Repository> repoList = new ArrayList<Repository>();
        int idx = 0;
        for (String repo : repos) {
            String name = String.format("url%d", idx++);
            if (RepoManager.isLocalUrl(repo = repo.trim())) {
                repoList.add(new Repository(name, repo, LOCAL_REPO_TYPE));
                continue;
            }
            repoList.add(new Repository(name, repo, REMOTE_REPO_TYPE));
        }
        return repoList;
    }

    public static void updateRepoToRootstrap(PkgCommandTarget target) {
        PlatformRootstrap rootstrap = target.getRootstrap();
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(rootstrap.getPath());
        int idx = 0;
        List<Repository> repos = rootstrap.getRepoList();
        for (Repository repo : repos) {
            String url = repo.getUri();
            String type = repo.getType();
            String name = String.format("url%d", idx++);
            if (RepoManager.isLocalType(type) && RepoManager.isLocalUrl(url)) {
                IPath repoPath = LocalRepoMounter.mountLocalRepository(rootstrapPath, url, null);
                if (repoPath == null) continue;
                target.getCommander(CmdTargetTypes.ROOTSTRAP).addLocalRepo(name, repoPath.toOSString());
                continue;
            }
            target.getCommander(CmdTargetTypes.ROOTSTRAP).addRepo(name, url);
        }
    }

    public static void updateRepoInfoToRootstrap(PkgCommandTarget target) {
        RepositoryProvider.INSTANCE.getBuildsystemRepos().clear();
        PlatformRootstrap rootstrap = target.getRootstrap();
        int idx = 0;
        List<Repository> repos = rootstrap.getRepoList();
        for (Repository repo : repos) {
            String url = repo.getUri();
            String name = String.format("url%d", idx++);
            RepositoryProvider.INSTANCE.getBuildsystemRepos().add(new Repository(name, url));
        }
    }

    public static void updateRepoInfoToDevice(List<Repository> repos) {
        RepositoryProvider.INSTANCE.getDeviceRepos().clear();
        RepositoryProvider.INSTANCE.getDeviceRepos().addAll(repos);
    }

    public static void updateRepoToDevice(PkgCommandTarget target) {
        IPkgCommander commander = target.getDeviceCommander();
        if (commander != null) {
            commander.resetRepo();
            int idx = 0;
            CopyOnWriteArrayList<Repository> repos = RepositoryProvider.INSTANCE.getDeviceRepos();
            for (Repository repo : repos) {
                String name = String.format("url%d", idx++);
                commander.addRepo(name, repo.getUri());
            }
        }
    }

    public static void addReposToRootstrap(PkgCommandTarget target) {
        PlatformRootstrap rootstrap = target.getRootstrap();
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(rootstrap.getPath());
        int idx = 0;
        List<Repository> repos = rootstrap.getRepoList();
        for (Repository repo : repos) {
            String url = repo.getUri();
            String type = repo.getType();
            String name = String.format("url%d", idx++);
            if (RepoManager.isLocalType(type) && RepoManager.isLocalUrl(url)) {
                IPath repoPath = LocalRepoMounter.mountLocalRepository(rootstrapPath, url, null);
                if (repoPath == null) continue;
                RepositoryProvider.INSTANCE.getBuildsystemRepos().add(new Repository(name, url));
                target.getCommander(CmdTargetTypes.ROOTSTRAP).addLocalRepo(name, repoPath.toOSString());
                continue;
            }
            RepositoryProvider.INSTANCE.getBuildsystemRepos().add(new Repository(name, url));
            target.getCommander(CmdTargetTypes.ROOTSTRAP).addRepo(name, url);
        }
    }
}

