/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.templateengine.process;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.nativeplatform.PlatformConfigurationManager;

public class SetDefaultIncludePaths
extends ProcessRunner {
    ProcessArgument[][] optionArray;

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (projectHandle == null) {
            return;
        }
        ProcessArgument optionList = args[1];
        this.optionArray = optionList.getComplexArrayValue();
        ArrayList<ICLanguageSettingEntry> list = new ArrayList<ICLanguageSettingEntry>();
        ProcessArgument[][] processArgumentArray = this.optionArray;
        int n = this.optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument[] op = processArgumentArray[n2];
            String option = op[0].getSimpleValue();
            CIncludePathEntry entry = CDataUtil.createCIncludePathEntry((String)option, (int)0);
            list.add((ICLanguageSettingEntry)entry);
            ++n2;
        }
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription(projectHandle);
        ArrayList providers = new ArrayList(((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders());
        for (ILanguageSettingsProvider p : providers) {
            if (!p.getId().equals("org.eclipse.cdt.ui.UserLanguageSettingsProvider")) continue;
            this.saveEntries(projectHandle, p, list);
            break;
        }
    }

    private ICConfigurationDescription getConfigurationDescription(IProject project) {
        IConfiguration config = PlatformConfigurationManager.getDefaultConfiguration((IProject)project);
        ICConfigurationDescription cfgDescription = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)config);
        return cfgDescription;
    }

    private void saveEntries(IProject project, ILanguageSettingsProvider provider, List<ICLanguageSettingEntry> entries) {
        String cLanguageId = "org.eclipse.cdt.core.gcc";
        String cppLanguageId = "org.eclipse.cdt.core.g++";
        if (provider instanceof ILanguageSettingsEditableProvider) {
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription(project);
            IProject rc = project;
            if (entries != null && rc != null) {
                List cppParentEntries;
                IContainer parent = rc instanceof IProject ? null : rc.getParent();
                List cParentEntries = LanguageSettingsManager.getSettingEntriesUpResourceTree((ILanguageSettingsProvider)provider, (ICConfigurationDescription)cfgDescription, (IResource)parent, (String)cLanguageId);
                if (entries.equals(cParentEntries)) {
                    entries = null;
                }
                if (entries.equals(cppParentEntries = LanguageSettingsManager.getSettingEntriesUpResourceTree((ILanguageSettingsProvider)provider, (ICConfigurationDescription)cfgDescription, (IResource)parent, (String)cppLanguageId))) {
                    entries = null;
                }
            }
            ((ILanguageSettingsEditableProvider)provider).setSettingEntries(cfgDescription, (IResource)rc, cLanguageId, entries);
            ((ILanguageSettingsEditableProvider)provider).setSettingEntries(cfgDescription, (IResource)rc, cppLanguageId, entries);
        }
    }
}

