/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.rds.IRpmRapidDeployer;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.CachePackageChecksum;
import org.tizen.nativeplatform.util.CommonBuildCommandUtil;
import org.tizen.nativeplatform.util.LRCaching;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;

public class RpmRapidDeployer
implements IRpmRapidDeployer {
    private IProject project;
    private IPkgCommander commander;
    private List<IPackage> packages;
    private CmdTargetTypes cmdType;
    private final Logger logger = LoggerFactory.getLogger(RpmRapidDeployer.class);

    public RpmRapidDeployer(IProject project, IPkgCommander commander, List<IPackage> packages) {
        this.project = project;
        this.commander = commander;
        this.packages = packages;
        this.cmdType = commander.getCommandType();
    }

    public boolean process() {
        StringBuffer sbPkgList = new StringBuffer();
        for (IPackage pkg : this.packages) {
            sbPkgList.append(pkg.getPath());
            sbPkgList.append(" ");
        }
        String pkgList = sbPkgList.toString().trim();
        Map sourceChecksums = null;
        try {
            sourceChecksums = CachePackageChecksum.getPkgChecksum((IProject)this.project, (String)pkgList);
        }
        catch (InterruptedException e) {
            this.logger.error(PlatformLaunchMessages.FAILED_CHECK_FILE_CHECKSUM, (Throwable)e);
            return false;
        }
        if (sourceChecksums == null || sourceChecksums.isEmpty()) {
            return false;
        }
        StringBuffer sbCheckFiles = new StringBuffer();
        for (String file : sourceChecksums.keySet()) {
            sbCheckFiles.append("'");
            sbCheckFiles.append(new Path(file).removeFirstSegments(1).toOSString());
            sbCheckFiles.append("' ");
        }
        String needCheckFiles = sbCheckFiles.toString().trim();
        Map<String, String> targetChecksums = this.getTargetChecksumMap(needCheckFiles);
        if (targetChecksums == null) {
            return false;
        }
        ArrayList<String> copyList = new ArrayList<String>();
        ArrayList<String> addList = new ArrayList<String>();
        ArrayList<String> remainList = new ArrayList<String>();
        ArrayList<String> removeList = new ArrayList<String>();
        String copyFileList = this.groupFiles(sourceChecksums, targetChecksums, copyList, addList, remainList, removeList);
        if (this.isDeviceCommander()) {
            if (!addList.isEmpty()) {
                this.logger.error("RDS is canceled because there is an added file");
                return false;
            }
            if (copyList.size() > 20) {
                this.logger.error("RDS is canceled because changed files are more than 20");
                return false;
            }
        }
        Map smackInfo = null;
        if (this.isDeviceCommander() && (smackInfo = PlatformLaunchUtil.getSmackInfo((IPkgCommander)this.commander, (String)copyFileList)) == null) {
            return false;
        }
        if (!this.processCopiedFiles(copyList)) {
            return false;
        }
        if (!this.processAddedFiles(addList, smackInfo)) {
            return false;
        }
        if (!this.processRemovedFiles(removeList)) {
            return false;
        }
        return !this.isDeviceCommander() || this.applySmack(smackInfo);
    }

    private boolean processCopiedFiles(List<String> fileList) {
        for (String file : fileList) {
            String targetFilePath = new Path(file).removeFirstSegments(1).toOSString();
            String cashingDir = PlatformInstances.getBuildCommandUtil().getCachingDir(this.project);
            if (cashingDir == null) {
                this.logger.error(String.format("Failed to get cashing directory", new Object[0]));
                return false;
            }
            String srcFilePath = new Path(cashingDir).append(file).toOSString();
            ICommandStatus status = this.commander.copyFile(srcFilePath, targetFilePath);
            if (status != null && status.isOk()) continue;
            this.logger.error(String.format("Failed to copy files [%s]", srcFilePath));
            return false;
        }
        return true;
    }

    private boolean processAddedFiles(List<String> fileList, Map<String, String[]> smackInfo) {
        for (String file : fileList) {
            Path filePath = new Path(file);
            String targetFilePath = filePath.removeFirstSegments(1).toOSString();
            String targetPath = filePath.removeFirstSegments(1).removeLastSegments(1).toOSString();
            String cashingDir = PlatformInstances.getBuildCommandUtil().getCachingDir(this.project);
            if (cashingDir == null) {
                this.logger.error(String.format("Failed to get cashing directory", new Object[0]));
                return false;
            }
            String srcFilePath = new Path(cashingDir).append(file).toOSString();
            ICommandStatus status = this.commander.makeDir(targetPath);
            if (status == null || !status.isOk()) {
                this.logger.error(String.format("Failed to make directory [%s]", targetPath));
                return false;
            }
            status = this.commander.copyFile(srcFilePath, targetFilePath);
            if (status == null || !status.isOk()) {
                this.logger.error(String.format("Failed to copy files [%s]", srcFilePath));
                return false;
            }
            if (smackInfo == null || !this.isDeviceCommander()) continue;
            String[] labels = new String[]{"_", "_"};
            smackInfo.put(targetFilePath, labels);
        }
        return true;
    }

    private boolean processRemovedFiles(List<String> fileList) {
        for (String file : fileList) {
            ICommandStatus status = this.commander.removeFile(file);
            if (status != null && status.isOk()) continue;
            this.logger.error(String.format("Failed to remove files [%s]", file));
            return false;
        }
        return true;
    }

    private boolean isDeviceCommander() {
        return this.cmdType == CmdTargetTypes.DEVICE;
    }

    private boolean applySmack(Map<String, String[]> smackInfo) {
        if (!smackInfo.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        for (Map.Entry<String, String[]> entry : smackInfo.entrySet()) {
            String[] value;
            String file = entry.getKey();
            ICommandStatus status = this.commander.changeSmack(file, (value = entry.getValue())[0], value[1]);
            if (status != null && status.isOk()) continue;
            this.logger.error(String.format("Failed to change smack [%s]", file));
            return false;
        }
        return true;
    }

    private String groupFiles(Map<String, String> sourceChecksums, Map<String, String> targetChecksums, List<String> copyList, List<String> addList, List<String> remainList, List<String> removeList) {
        StringBuffer sbCopyFiles = new StringBuffer();
        for (Map.Entry<String, String> entry : sourceChecksums.entrySet()) {
            String key = entry.getKey();
            String s_value = entry.getValue();
            String target_key = new Path(key).removeFirstSegments(1).toOSString();
            if (targetChecksums.containsKey(target_key)) {
                String d_value = targetChecksums.get(target_key);
                if (!s_value.equals(d_value)) {
                    copyList.add(key);
                    sbCopyFiles.append("\"" + target_key + "\" ");
                    continue;
                }
                remainList.add(key);
                continue;
            }
            if (key.equals("-")) continue;
            addList.add(key);
        }
        return sbCopyFiles.toString().trim();
    }

    private Map<String, String> getTargetChecksumMap(String fileList) {
        HashMap<String, String> checksumMap = new HashMap<String, String>();
        String[] args = fileList.length() > CommonBuildCommandUtil.LIMIT_COMMAND_LENGTH ? CommonBuildCommandUtil.splitCommandArgs((String)fileList) : new String[]{fileList};
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!arg.isEmpty()) {
                ICommandStatus status = this.commander.getMd5Checksum(arg);
                if (status == null) {
                    return null;
                }
                List values = status.getValues();
                if (values == null) {
                    this.logger.error(String.format("%s: src:%s", PlatformLaunchMessages.FAILED_CHECK_FILE_CHECKSUM, arg));
                    return null;
                }
                Map<String, String> data = this.getChecksumMap(values);
                if (data.isEmpty()) {
                    this.logger.error(String.format("%s: checksum is empty. src:%s", PlatformLaunchMessages.FAILED_CHECK_FILE_CHECKSUM, arg));
                    return null;
                }
                checksumMap.putAll(data);
            }
            ++n2;
        }
        return checksumMap;
    }

    private Map<String, String> getChecksumMap(List<String> sources) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String value : sources) {
            String[] v = value.split("  ");
            if (v.length != 2) continue;
            String key = v[1].startsWith(".") ? v[1].substring(1) : v[1];
            result.put(key, v[0]);
        }
        return result;
    }

    public boolean processFast() {
        if (LRCaching.getWorkingSize() == 0 && LRCaching.getStagingSize() == 0) {
            return false;
        }
        StringBuffer sbPkgList = new StringBuffer();
        for (IPackage pkg : this.packages) {
            sbPkgList.append(new Path(pkg.getPath()).lastSegment());
            sbPkgList.append(" ");
        }
        String pkgList = sbPkgList.toString().trim();
        String cashingDir = PlatformInstances.getBuildCommandUtil().getCachingDir(this.project);
        if (cashingDir == null) {
            this.logger.error(String.format("Failed to get cashing directory", new Object[0]));
            return false;
        }
        String projectName = new Path(cashingDir).lastSegment();
        String cacheKeys = LRCaching.getCacheKeys((String)pkgList, (String)projectName);
        Map workingChecksums = new HashMap();
        Map stagingWorkingChecksums = new HashMap();
        HashMap tempWorkingChecksums = new HashMap();
        workingChecksums = LRCaching.getWorkingCacheAsMap((String)cacheKeys);
        stagingWorkingChecksums = LRCaching.getStagingCacheAsMap((String)cacheKeys);
        if (stagingWorkingChecksums.size() == 0) {
            return false;
        }
        tempWorkingChecksums.putAll(workingChecksums);
        Set tempWorkingEntries = tempWorkingChecksums.entrySet();
        Set stagingEntries = stagingWorkingChecksums.entrySet();
        tempWorkingEntries.removeAll(stagingEntries);
        if (tempWorkingEntries.size() == 0) {
            return true;
        }
        ArrayList<String> copyList = new ArrayList<String>();
        StringBuffer smackinfoCopyFiles = new StringBuffer();
        for (Map.Entry tempWorkingEntry : tempWorkingEntries) {
            String key = (String)tempWorkingEntry.getKey();
            copyList.add(key);
            String smackedValue = new Path(key).removeFirstSegments(1).toString();
            smackinfoCopyFiles.append("\"" + smackedValue + "\" ");
        }
        tempWorkingEntries.clear();
        if (copyList.size() > 20) {
            return false;
        }
        String smackinfoList = smackinfoCopyFiles.toString().trim();
        Map smackInfo = null;
        if (this.isDeviceCommander() && (smackInfo = PlatformLaunchUtil.getSmackInfo((IPkgCommander)this.commander, (String)smackinfoList)) == null) {
            return false;
        }
        if (copyList.size() > 2 && this.isDeviceCommander()) {
            this.processCopiedFilesWithZip(copyList);
        } else {
            this.processCopiedFiles(copyList);
        }
        return !this.isDeviceCommander() || this.applySmack(smackInfo);
    }

    private boolean processCopiedFilesWithZip(List<String> fileList) {
        StringBuffer fileStrings = new StringBuffer();
        for (String str : fileList) {
            fileStrings.append(str);
            fileStrings.append(" ");
        }
        String rdsTarFileName = String.valueOf(fileList.size()) + "rdsFiles.tar";
        String compressedFileList = fileStrings.toString().trim();
        String command = PlatformInstances.getScriptProvider().genCompressFilesScript(this.project, compressedFileList, rdsTarFileName);
        if (command == null) {
            return false;
        }
        boolean result = false;
        try {
            if (!HostCommandLauncher.execute((String)command)) {
                return false;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            PlatformInstances.getScriptProvider().cleanUpScript(command);
        }
        if (!this.transferToDevice(rdsTarFileName)) {
            return false;
        }
        ICommandStatus status = this.commander.unCompressArchivedFile(rdsTarFileName);
        if (status == null) {
            return false;
        }
        return result;
    }

    private boolean transferToDevice(String tarFileName) {
        String targetFilePath;
        String cachingDir = PlatformInstances.getBuildCommandUtil().getCachingDir(this.project);
        if (cachingDir == null) {
            this.logger.error(String.format("Failed to get cashing directory", new Object[0]));
            return false;
        }
        String srcFilePath = String.valueOf(cachingDir) + "/" + tarFileName;
        ICommandStatus status = this.commander.copyFile(srcFilePath, targetFilePath = "/tmp/" + tarFileName);
        if (status == null || !status.isOk()) {
            this.logger.error(String.format("Failed to copy files [%s]", srcFilePath));
            return false;
        }
        return true;
    }
}

