/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.action;

import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.model.PlatformRootstrap;

public class DebugSourceOpeningAction
extends Action {
    protected final String BUNDLE_NAME = String.valueOf(DebugSourceOpeningAction.class.getPackage().getName()) + ".RootstrapUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(DebugSourceOpeningAction.class);
    protected IProject project;
    protected TableViewer viewer;
    protected Shell shell;

    public DebugSourceOpeningAction(Shell shell, IProject project, TableViewer viewer) {
        this.project = project;
        this.viewer = viewer;
        this.shell = shell;
    }

    public void run() {
        this.action();
    }

    protected void action() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                Table table = DebugSourceOpeningAction.this.viewer.getTable();
                TableItem[] item = table.getSelection();
                PlatformRootstrap selected = (PlatformRootstrap)item[0].getData();
                String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(selected.getPath());
                String defaultPath = new Path(rootstrapPath).append("usr").append("src").append("debug").toString();
                File debugSrcPath = new File(defaultPath);
                if (!debugSrcPath.exists()) {
                    String msg = String.format("There is no any debug source in \"%s\" rootstrap.\nTry it again after installing debug packages using \"Manage Packages\" menu.", selected.getId());
                    DialogUtil.openMessageDialog((String)msg);
                    return;
                }
                FileDialog fd = new FileDialog(DebugSourceOpeningAction.this.shell, 4100);
                fd.setText("Select debug source file");
                fd.setFilterPath(defaultPath);
                String[] extensions = new String[]{"*.c;*.cpp;*.h", "*.*"};
                fd.setFilterExtensions(extensions);
                String filepath = fd.open();
                if (filepath != null) {
                    File file = new File(filepath);
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public boolean doCheckEnable() {
                return true;
            }
        });
    }

    protected void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    protected static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }
}

