/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.action;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.repo.commander.LocalRepoMounter;
import org.tizen.nativeplatform.rootstrap.CommonRootstrapManager;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.RootstrapListenerManager;
import org.tizen.nativeplatform.rootstrap.RootstrapSelectionManager;
import org.tizen.sbilib.ide.PluginManager;

public class RootstrapRemovalAction
extends Action {
    protected final String BUNDLE_NAME = String.valueOf(RootstrapRemovalAction.class.getPackage().getName()) + ".RootstrapUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(RootstrapRemovalAction.class);
    protected IProject project;
    protected TableViewer viewer;
    protected Shell shell;

    public RootstrapRemovalAction(Shell shell, IProject project, TableViewer viewer) {
        this.project = project;
        this.viewer = viewer;
        this.shell = shell;
    }

    public void run() {
        this.action();
    }

    protected void action() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                IProject[] projs;
                Table table = RootstrapRemovalAction.this.viewer.getTable();
                TableItem[] item = table.getSelection();
                final PlatformRootstrap selected = (PlatformRootstrap)item[0].getData();
                PlatformRootstrap defaultRootstrap = CommonRootstrapManager.getDefaultRootstrap((String)selected.getArchitecture());
                if (defaultRootstrap == null) {
                    String msg = String.format("%s %s", RootstrapRemovalAction.this.resources.getString("Action.Msg.Error.RemoveDefault"), RootstrapRemovalAction.this.resources.getString("Action.Msg.Error.DefaultRootstrap.Not.Existed"));
                    DialogUtil.openErrorDialog((String)msg);
                    return;
                }
                if (defaultRootstrap.getId().equals(selected.getId())) {
                    DialogUtil.openErrorDialog((String)RootstrapRemovalAction.this.resources.getString("Action.Msg.Error.RemoveDefault"));
                    return;
                }
                IWorkspace works = ResourcesPlugin.getWorkspace();
                IProject[] iProjectArray = projs = works.getRoot().getProjects();
                int n = projs.length;
                int n2 = 0;
                while (n2 < n) {
                    IManagedProject managedProject;
                    IConfiguration config;
                    IProject proj = iProjectArray[n2];
                    IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)proj);
                    if (info != null && (config = info.getDefaultConfiguration()) != null && (managedProject = config.getManagedProject()) != null) {
                        String projectArtifactType;
                        String string = projectArtifactType = managedProject.getProjectType() != null ? managedProject.getProjectType().getBuildArtefactType().getId() : null;
                        if (projectArtifactType == "org.tizen.nativeide.buildArtefactType.platform") {
                            RootstrapRemovalAction.this.setActiveRootstrap(proj, defaultRootstrap);
                        }
                    }
                    ++n2;
                }
                final List failedPaths = LocalRepoMounter.umountLocalRepository((PlatformRootstrap)selected, null);
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(RootstrapRemovalAction.this.shell);
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask((this).RootstrapRemovalAction.this.resources.getString("Action.Msg.Progress.Removing"), -1);
                            if (failedPaths.size() != 0) {
                                throw new InterruptedException();
                            }
                            RootstrapInstances.getRootstrapManager().removeRootstrap(selected.getId());
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    RootstrapRemovalAction.this.logger.error(RootstrapRemovalAction.this.resources.getString("Action.Msg.Error.RemoveFailed"), (Throwable)e);
                    DialogUtil.openErrorDialog((String)String.format("%s\n * %s", RootstrapRemovalAction.this.resources.getString("Action.Msg.Error.RemoveFailed"), e.getMessage()));
                    return;
                }
                catch (InterruptedException e) {
                    RootstrapRemovalAction.this.logger.error(RootstrapRemovalAction.this.resources.getString("Action.Msg.Error.RemoveFailed"), (Throwable)e);
                    DialogUtil.openErrorDialog((String)String.format("%s\n * %s", RootstrapRemovalAction.this.resources.getString("Action.Msg.Error.RemoveFailed"), e.getMessage()));
                    return;
                }
            }

            @Override
            public boolean doCheckEnable() {
                return true;
            }
        });
    }

    private void setActiveRootstrap(IProject project, PlatformRootstrap rootstrap) {
        String rootId = rootstrap.getId();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = info.getDefaultConfiguration();
        String targetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)config);
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String toolId = sbi.getToolchainIDFromTargetID(targetId);
        PluginManager pm = PluginManager.getInstance();
        String newTargetId = pm.makeTargetId(rootId, toolId);
        pm.createTarget(rootId, toolId, newTargetId);
        pm.reInit();
        PlatformConfigurationManager.setBuildTargetName((IConfiguration)config, (String)newTargetId);
        RootstrapSelectionManager.setSelectedRootstrap((PlatformRootstrap)rootstrap);
        RootstrapListenerManager.notifyChangedRootstrap();
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    private void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    private static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }
}

