/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.core;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.build.model.SBIModel;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.util.RootstrapUtil;

public class RootstrapRemover {
    protected static PlatformRootstrap latestTempRootstrap = null;
    protected static final Logger logger = LoggerFactory.getLogger(RootstrapRemover.class);

    public static void setLatestTempRootstrap(PlatformRootstrap rootstrap) {
        latestTempRootstrap = rootstrap;
    }

    public static boolean remove(String id, String arch) throws InterruptedException {
        String path = RootstrapUtil.getUserRootstrapPath((String)id);
        RootstrapRemover.remove(id, arch, path);
        return true;
    }

    public static boolean remove(String id, String arch, String path) throws InterruptedException {
        String checkDir = String.format("%s/local/BUILD-ROOTS/scratch.%s.0/proc", path, arch);
        if (new File(checkDir).exists()) {
            HostCommandLauncher.executeSudo((String)String.format("sudo -S umount %s", checkDir));
        }
        if (new File(checkDir = String.format("%s/local/BUILD-ROOTS/scratch.%s.0/dev/pts", path, arch)).exists()) {
            HostCommandLauncher.executeSudo((String)String.format("sudo -S umount %s", checkDir));
        }
        HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", path), null);
        return true;
    }

    public static void cleanUpRootstrap(String pluginPath, String rootstrapPath) throws InterruptedException {
        if (pluginPath != null) {
            HostCommandLauncher.execute((String)String.format("rm -rf %s", pluginPath));
            try {
                SBIModel.reinitialize();
            }
            catch (SBIException e1) {
                throw new InterruptedException(e1.getMessage());
            }
        }
        if (rootstrapPath != null) {
            HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", rootstrapPath), null);
        }
    }

    public static void removeLatestTempDirForRootstrap() {
        if (latestTempRootstrap == null) {
            return;
        }
        String id = latestTempRootstrap.getId();
        String arch = latestTempRootstrap.getArchitecture();
        String path = latestTempRootstrap.getPath();
        if (id == null || arch == null || path == null || id.isEmpty() || arch.isEmpty() || path.isEmpty()) {
            return;
        }
        try {
            if (!path.isEmpty() && new File(path).exists()) {
                String checkDir = String.format("%s/%s/local/BUILD-ROOTS/scratch.%s.0/proc", path, id, arch);
                if (new File(checkDir).exists()) {
                    HostCommandLauncher.executeSudo((String)String.format("sudo -S umount %s", checkDir));
                }
                if (new File(checkDir = String.format("%s/%s/local/BUILD-ROOTS/scratch.%s.0/dev/pts", path, id, arch)).exists()) {
                    HostCommandLauncher.executeSudo((String)String.format("sudo -S umount %s", checkDir));
                }
                if (new File(checkDir = String.format("%s/%s/", path, id)).exists()) {
                    HostCommandLauncher.executeSudo((String)String.format("rm -rf %s", checkDir));
                }
                HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", path));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            logger.error(String.format("Failed to remove temp rootstrap directory: %s", path), (Throwable)e);
        }
    }
}

