/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.ui.shortcut;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchConfiguration;
import org.tizen.nativeplatform.launcher.ui.shortcut.PlatformProjectCommonLaunchShortcut;
import org.tizen.sdblib.IDevice;

public class PlatformProjectCoredumpLaunchShortcut
extends PlatformProjectCommonLaunchShortcut {
    @Override
    protected void searchAndLaunch(Object[] elements, String mode) {
        this.isCoredump = true;
        super.searchAndLaunch(elements, mode);
    }

    @Override
    protected ILaunchConfiguration createConfiguration(IProject project, String mode) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getCLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(project.getName()));
            this.setPkgCommandTarget(project);
            TizenLaunchConfiguration tc = new TizenLaunchConfiguration(wc);
            tc.setCoredumpDefaults();
            this.setAttributes(wc, project);
            wc.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, true);
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                String buildConfigID = projDes.getActiveConfiguration().getId();
                wc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
                String buildConfigName = projDes.getActiveConfiguration().getName();
                wc.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", buildConfigName);
                IDevice device = LaunchUtils.getCurrentDeployDevice();
                if (device != null) {
                    LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)wc, (IDevice)device);
                }
            }
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
            config = wc.doSave();
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log((Throwable)ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.tizen.nativeplatform.launch.PlatformLaunchConfigurationTypeForCore");
    }

    @Override
    boolean needCheckDeviceRootOn() {
        return true;
    }
}

