/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.launcher.factory.PkgFilterFactory;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.launcher.rpm.RpmPackageLauncher;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingPkgPage;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingProcPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCommonLaunchWizard;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.LaunchTypes;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class PlatformAttachLaunchWizard
extends PlatformCommonLaunchWizard {
    private int pid;
    private String procName;
    private IPkgFilter pkgFilter = PkgFilterFactory.getFilter(PlatformProjectUtil.getPkgType());
    private static final String SETTING_PKG_PAGE = "setting_pkg";
    private static final String SETTING_PROC_PAGE = "setting_proc";

    public PlatformAttachLaunchWizard(Shell shell, IProject project, IConfiguration config, PkgCommandTarget target, String mode) {
        super(shell, project, config, target, mode);
    }

    public PlatformAttachLaunchWizard(Shell shell, ILaunchConfiguration launchConfig, IProject project, IConfiguration config, PkgCommandTarget target, String mode, boolean isPlatformVersion3) {
        super(shell, launchConfig, project, config, target, mode);
        this.isPlatformVersion3 = isPlatformVersion3;
    }

    @Override
    public void addPages() {
        PlatformLaunchSettingPkgPage page1 = new PlatformLaunchSettingPkgPage(this, this.shell, SETTING_PKG_PAGE, this.project, this.config, this.target);
        page1.disableDeviceGroup();
        this.addPage((IWizardPage)page1);
        this.addPage((IWizardPage)new PlatformLaunchSettingProcPage(this, this.shell, SETTING_PROC_PAGE, this.project, this.config, this.target));
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
        dialog.addPageChangingListener((IPageChangingListener)this);
    }

    @Override
    public String getProgramPath() {
        return this.programPath;
    }

    public int getPid() {
        return this.pid;
    }

    public String getProcName() {
        return this.procName;
    }

    @Override
    public boolean performFinish() {
        PlatformLaunchSettingProcPage page = (PlatformLaunchSettingProcPage)this.getPage(SETTING_PROC_PAGE);
        if (page == null) {
            return false;
        }
        this.programPath = page.getProgramPath();
        this.pid = page.getPid();
        IWizardContainer container = this.getContainer();
        this.reinstallOp = page.getReinstallOp();
        this.procName = page.getProcName();
        this.pid = page.getPid();
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 1);
                    monitor.subTask(PlatformLaunchMessages.CHECK_PKG_STATUS);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.openLogDialog(PlatformLaunchMessages.FAILED_INSTALL_PKGS, e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.openLogDialog(PlatformLaunchMessages.FAILED_INSTALL_PKGS, e.getMessage());
        }
        return true;
    }

    @Override
    public void pageChanged(PageChangedEvent event) {
        WizardPage currentPage = (WizardPage)event.getSelectedPage();
        if (currentPage.getName().equals(SETTING_PKG_PAGE)) {
            this.getContainer().updateButtons();
        }
    }

    @Override
    public void handlePageChanging(PageChangingEvent event) {
        WizardPage currentPage = (WizardPage)event.getCurrentPage();
        WizardPage targetPage = (WizardPage)event.getTargetPage();
        if (currentPage.getName().equals(SETTING_PKG_PAGE) && targetPage.getName().equals(SETTING_PROC_PAGE)) {
            PlatformLaunchSettingPkgPage pkgPage = (PlatformLaunchSettingPkgPage)currentPage;
            PlatformLaunchSettingProcPage procPage = (PlatformLaunchSettingProcPage)targetPage;
            pkgPage.savePkgInstallInfo();
            final List<IPackage> checkedRootstrapPkgs = pkgPage.getCheckedRootstrapPackage();
            IWizardContainer container = this.getContainer();
            try {
                container.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("", 1);
                        PlatformAttachLaunchWizard.this.deviceLog = "";
                        PlatformAttachLaunchWizard.this.rootstrapLog = "";
                        PlatformAttachLaunchWizard.this.devicePackages.clear();
                        PlatformAttachLaunchWizard.this.rootstrapPackages.clear();
                        try {
                            PlatformAttachLaunchWizard.this.launchConfig.getWorkingCopy();
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                            new InterruptedException(e1.getMessage());
                        }
                        if (checkedRootstrapPkgs != null && !checkedRootstrapPkgs.isEmpty()) {
                            PlatformAttachLaunchWizard.this.rootstrapPackages.addAll(PlatformAttachLaunchWizard.this.pkgFilter.filter(CmdTargetTypes.ROOTSTRAP, checkedRootstrapPkgs));
                        }
                        PlatformAttachLaunchWizard.this.reinstallOp = true;
                        RpmPackageLauncher pkgLauncher = new RpmPackageLauncher(PlatformAttachLaunchWizard.this.project, PlatformAttachLaunchWizard.this.target, PlatformAttachLaunchWizard.this.devicePackages, PlatformAttachLaunchWizard.this.rootstrapPackages, PlatformAttachLaunchWizard.this.reinstallOp);
                        try {
                            try {
                                pkgLauncher.debugLaunchPkgs(LaunchTypes.ATTACH, PlatformAttachLaunchWizard.this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            catch (InterruptedException e) {
                                new InterruptedException(e.getMessage());
                                monitor.done();
                                PlatformAttachLaunchWizard.this.rootstrapLog = pkgLauncher.getRootstrapLog();
                                PlatformAttachLaunchWizard.this.deviceLog = pkgLauncher.getDeviceLog();
                            }
                        }
                        finally {
                            monitor.done();
                            PlatformAttachLaunchWizard.this.rootstrapLog = pkgLauncher.getRootstrapLog();
                            PlatformAttachLaunchWizard.this.deviceLog = pkgLauncher.getDeviceLog();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.openErrorDialog(e.toString());
                this.cancelChanging(event);
                return;
            }
            procPage.validate();
        }
    }

    @Override
    public void openErrorDialog(final String error) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                DialogUtil.openErrorDialog((String)error);
            }
        });
    }
}

