/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.repo.commander.LocalRepoMounter;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.sbilib.ide.Rootstrap;
import org.w3c.dom.Document;

public class PlatformRootstrap
extends Rootstrap {
    private String http_proxy;
    private boolean checked;
    private boolean initialized;
    private String id = null;
    private String name = null;
    private String arch = null;
    private String version = null;
    private String supportToolchainType = null;
    private IPath rootstrapPath = null;
    private String confFilePath = null;
    private boolean isDefualt = false;
    private List<Repository> reposURLs = new ArrayList<Repository>();
    public static final String PROPERTY_REPO_URLS = "REPOSITORY_URLS";
    public static final String PROPERTY_CONFIGURATION_FILE = "CONFIGURATION_FILE";
    public static final String PROPERTY_DEFAULT = "DEFAULT";
    public static final String SUPPORTED_TOOLCHAIN_TYPE = "tizen.platform";
    public static final String DEFAULT_VERSION = "1.0";
    private static final String URL_SEP = "|";
    private static final String URL_SEP_REGEXP = "[|]";

    public PlatformRootstrap(Document dom, File file) {
        super(dom, file);
        this.initRepositories();
    }

    public PlatformRootstrap(String id, String name, String arch, String rootstrapPath, List<Repository> reposURLs, String confFile, boolean initialized) {
        super(null, null);
        this.id = id;
        this.name = name;
        this.arch = arch;
        this.version = DEFAULT_VERSION;
        this.rootstrapPath = new Path(rootstrapPath);
        this.supportToolchainType = SUPPORTED_TOOLCHAIN_TYPE;
        this.reposURLs = reposURLs;
        this.initialized = initialized;
        this.confFilePath = confFile;
    }

    public PlatformRootstrap(Document dom, File file, boolean isInit) {
        this(dom, file);
        this.initialized = isInit;
    }

    private void initRepositories() {
        String repositories = this.getRepositories();
        if (repositories != null && repositories.split(URL_SEP_REGEXP).length >= 1) {
            int idx = 0;
            String[] stringArray = repositories.split(URL_SEP_REGEXP);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                String name = String.format("url%d", idx++);
                if (RepoManager.isLocalUrl(url)) {
                    this.reposURLs.add(new Repository(name, url, RepoManager.LOCAL_REPO_TYPE));
                } else {
                    this.reposURLs.add(new Repository(name, url, RepoManager.REMOTE_REPO_TYPE));
                }
                ++n2;
            }
        }
    }

    public String getId() {
        if (this.dom == null) {
            return this.id;
        }
        return super.getId();
    }

    public String getArchitecture() {
        if (this.dom == null) {
            return this.arch;
        }
        return super.getArchitecture();
    }

    public String getPath() {
        if (this.dom == null) {
            return this.rootstrapPath.toString();
        }
        return super.getPath();
    }

    public String getText() {
        return this.getName();
    }

    public String getProxy() {
        return this.http_proxy;
    }

    public IPath getConfFile() {
        String confFilePath = this.getProperty(PROPERTY_CONFIGURATION_FILE);
        if (confFilePath == null) {
            if (this.confFilePath == null) {
                return null;
            }
            return new Path(this.confFilePath);
        }
        if (confFilePath.equals(Boolean.FALSE.toString())) {
            return null;
        }
        return new Path(confFilePath);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean isChecked) {
        this.checked = isChecked;
    }

    public void setConfFile(IPath path) {
        this.setElement("property", "key", PROPERTY_CONFIGURATION_FILE, "value", path.toOSString());
        this.confFilePath = path.toOSString();
    }

    public void setInitialized(boolean isInitialized) {
        this.initialized = isInitialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean checkInitialized() {
        boolean exists = RootstrapProxy.getProxy().checkInitialized(this);
        this.setInitialized(exists);
        return exists;
    }

    public String getRepositories() {
        return this.getPropertyValue(PROPERTY_REPO_URLS);
    }

    private void saveRepositories() {
        StringBuffer sb = new StringBuffer();
        List<String> repoList = this.getJustRepoURLs();
        int i = 0;
        while (i < repoList.size()) {
            sb.append(repoList.get(i));
            if (i != repoList.size() - 1) {
                sb.append(URL_SEP);
            }
            ++i;
        }
        this.setElement("property", "key", PROPERTY_REPO_URLS, "value", sb.toString());
    }

    public List<Repository> getRepoList() {
        return this.reposURLs;
    }

    public List<String> getJustRepoURLs() {
        ArrayList<String> repos = new ArrayList<String>();
        for (Repository repo : this.reposURLs) {
            repos.add(repo.getUri());
        }
        return repos;
    }

    public boolean modifyRepoURL(String url, String newUrl) {
        for (Repository repo : this.reposURLs) {
            if (!repo.getUri().equals(url)) continue;
            repo.setUri(newUrl);
            this.saveRepositories();
            return true;
        }
        return false;
    }

    public boolean addRepoURL(String url) {
        if (RepoManager.isLocalUrl(url)) {
            return this.addRepoURL(url, RepoManager.LOCAL_REPO_TYPE);
        }
        return this.addRepoURL(url, RepoManager.REMOTE_REPO_TYPE);
    }

    public boolean containRepository(String url) {
        for (Repository repo : this.reposURLs) {
            if (!repo.getUri().equals(url)) continue;
            return true;
        }
        return false;
    }

    public boolean addRepoURL(String url, String type) {
        if (type == null) {
            type = RepoManager.REMOTE_REPO_TYPE;
        }
        for (Repository repo : this.reposURLs) {
            if (!repo.getUri().equals(url)) continue;
            repo.setType(type);
            this.saveRepositories();
            return true;
        }
        Repository newRepository = new Repository();
        newRepository.setUri(url);
        newRepository.setType(type);
        this.reposURLs.add(newRepository);
        this.saveRepositories();
        return true;
    }

    public boolean removeRepoURL(String url) {
        return this.removeRepoURL(url, RepoManager.getURLType(url));
    }

    public Repository getRepository(String url) {
        for (Repository repo : this.reposURLs) {
            if (!repo.getUri().equals(url)) continue;
            return repo;
        }
        return null;
    }

    public boolean moveupRepository(String url) {
        int idx = 0;
        Repository targetRepository = null;
        for (Repository repo : this.reposURLs) {
            if (url.equals(repo.getUri())) {
                targetRepository = repo;
                break;
            }
            ++idx;
        }
        if (idx <= 0) {
            return false;
        }
        this.reposURLs.add(idx - 1, targetRepository);
        this.reposURLs.remove(idx + 1);
        this.saveRepositories();
        return true;
    }

    public boolean movedownRepository(String url) {
        int idx = 0;
        int maxIdx = this.reposURLs.size() - 1;
        Repository targetRepository = null;
        for (Repository repo : this.reposURLs) {
            if (url.equals(repo.getUri())) {
                targetRepository = repo;
                break;
            }
            ++idx;
        }
        if (idx >= maxIdx) {
            return false;
        }
        this.reposURLs.add(idx + 2, targetRepository);
        this.reposURLs.remove(idx);
        this.saveRepositories();
        return true;
    }

    public boolean removeRepoURL(String url, String type) {
        Repository targetRepo = null;
        if (RepoManager.isLocalType(type)) {
            if (LocalRepoMounter.umountLocalRepository(url, null)) {
                targetRepo = this.getRepository(url);
            }
        } else {
            targetRepo = this.getRepository(url);
        }
        if (targetRepo != null) {
            this.reposURLs.remove(targetRepo);
            this.saveRepositories();
            return true;
        }
        return false;
    }
}

