/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.contexts.IContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeplatform.linux.rootstrap.action.ActionCreatedByManual;
import org.tizen.nativeplatform.linux.rootstrap.action.ActionImportRootstrap;
import org.tizen.nativeplatform.linux.rootstrap.action.DebugSourceOpeningAction;
import org.tizen.nativeplatform.linux.rootstrap.action.PackageManagerAction;
import org.tizen.nativeplatform.linux.rootstrap.action.RootstrapExportAction;
import org.tizen.nativeplatform.linux.rootstrap.action.RootstrapRemovalAction;
import org.tizen.nativeplatform.linux.rootstrap.action.RootstrapSelectionAction;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.rootstrap.view.ui.IRootstrapViewProvider;
import org.tizen.nativeplatform.rootstrap.view.ui.RootstrapView;

public class RootstrapViewProvider
implements IRootstrapViewProvider {
    private final String BUNDLE_NAME = String.valueOf(RootstrapViewProvider.class.getPackage().getName()) + ".RootstrapUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private final Logger logger = LoggerFactory.getLogger(RootstrapViewProvider.class);
    private RootstrapView view;
    private Action actionSetDefault;
    private Action actionPkgMgr;
    private Action actionRemove;
    private Action actionExport;
    private Action actionOpenDbgsrc;

    public void setRootstrapView(RootstrapView view) {
        this.view = view;
    }

    public void fillToolbar(IToolBarManager toolbarManager) {
        String defaultGroup = this.resources.getString("View.Toolbar.Group.Default");
        toolbarManager.add((IContributionItem)new Separator(defaultGroup));
        ActionCreatedByManual createAction = new ActionCreatedByManual(this.view.getShell());
        toolbarManager.appendToGroup(defaultGroup, (IAction)createAction);
        ActionImportRootstrap importAction = new ActionImportRootstrap(this.view, this.view.getShell());
        toolbarManager.appendToGroup(defaultGroup, (IAction)importAction);
    }

    public void updateToolbarEnable(IToolBarManager toolbarManager) {
    }

    public void fillContextMenu(IMenuManager manager) {
        this.makeActions();
        this.activateContext();
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSetDefault);
        manager.add((IAction)this.actionRemove);
        manager.add((IAction)this.actionExport);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionOpenDbgsrc);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionPkgMgr);
    }

    private void makeActions() {
        Shell shell = this.view.getShell();
        IProject project = this.view.getProject();
        TableViewer viewer = this.view.getTableViewer();
        Table table = viewer.getTable();
        TableItem[] item = table.getSelection();
        PlatformRootstrap selectedRootstrap = (PlatformRootstrap)item[0].getData();
        this.actionSetDefault = new RootstrapSelectionAction(shell, project, viewer);
        this.actionSetDefault.setText(this.resources.getString("View.Contextmenu.Select"));
        this.actionSetDefault.setId("platform.rootstrap.select");
        this.actionRemove = new RootstrapRemovalAction(shell, project, viewer);
        this.actionRemove.setText(this.resources.getString("View.Contextmenu.Remove"));
        this.actionRemove.setId("platform.rootstrap.remove");
        this.actionExport = new RootstrapExportAction(shell, project, viewer);
        this.actionExport.setText(this.resources.getString("View.Contextmenu.Export"));
        this.actionExport.setId("platform.rootstrap.export");
        this.actionOpenDbgsrc = new DebugSourceOpeningAction(shell, project, viewer);
        this.actionOpenDbgsrc.setText(this.resources.getString("View.Contextmenu.OpenDbgsrc"));
        this.actionOpenDbgsrc.setId("platform.rootstrap.opendebugsrc");
        this.actionPkgMgr = new PackageManagerAction(shell, project, selectedRootstrap);
        this.actionPkgMgr.setText(this.resources.getString("View.Contextmenu.Manage"));
        this.actionPkgMgr.setId("platform.rootstrap.managepkg");
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.view.getSite().getService(IContextService.class);
        contextService.activateContext("org.tizen.nativeplatform.rootstrap.setdefault.context");
        contextService.activateContext("org.tizen.nativeplatform.rootstrap.lauchpkgmgr.context");
        contextService.activateContext("org.tizen.nativeplatform.rootstrap.remove.context");
        contextService.activateContext("org.tizen.nativeplatform.rootstrap.export.context");
        contextService.activateContext("org.tizen.nativeplatform.rootstrap.change.conffile.context");
        contextService.activateContext("org.tizen.nativeplatform.rootstrap.open.debugsource");
    }
}

