/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.rootstrap.util.SnapshotListParser;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapGenWizard;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapSettingPage1;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;

public class RootstrapSettingPage5
extends RootstrapSettingPage1 {
    private final String BUNDLE_NAME = String.valueOf(RootstrapSettingPage5.class.getPackage().getName()) + ".RootstrapWizardUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private Combo urlCombo;
    private Button searchBt;
    private RootstrapGenWizard wizard;
    private TableViewer tableViewer;
    private Label snapshotLabel;
    private Label snapshotUrl;
    private Table table;
    private boolean validateData = false;
    private final String COMBO_SEPARATOR_1 = "[Default base URL]";
    private final String COMBO_SEPARATOR_2 = "[History]";
    private final String[] predefinedUrl = new String[]{"[Default base URL]", "http://168.219.244.109/releases/tztv-2.4-product-main2016/product/Hawk-P/", "http://168.219.244.109/snapshots/tztv-2.4-product-main2016/product/Hawk-P/", "http://168.219.244.109/snapshots/tztv-2.4-product-main2016/product/Hawk-M_FHD/", "http://168.219.244.109/snapshots/tztv-2.4-product-main2016/product/Hawk-M_HTV/", "http://168.219.244.109/snapshots/tztv-2.4-product-main2016/product/Hawk-M_LFD/", "http://168.219.244.109/snapshots/tztv-2.4-product-main2016/product/Hawk-M_UHD/", "http://168.219.244.109/snapshots/tztv-2.4-product-main2016/product/Jazz-M/", "http://168.219.244.109/snapshots/tztv-2.4-product-main2016/product/NT16M/", "http://168.219.244.109/snapshots/tztv-2.4-product-main2016/product/emulator/", "[History]"};
    protected final Logger logger = LoggerFactory.getLogger(RootstrapSettingPage5.class);

    public RootstrapSettingPage5(RootstrapGenWizard wizard, String pageName, Shell shell) {
        super(pageName, shell);
        this.wizard = wizard;
        this.setTitle(this.resources.getString("RootstrapPage5.Title"));
        this.setTitle(this.resources.getString("RootstrapPage5.Desc"));
        this.setErrorMessage(null);
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createBaseURLComposite(composite);
        this.createSnapshotComposite(composite);
        this.createSnapshotListTableComposite(composite);
        this.setControl((Control)composite);
        this.setInput();
        this.setDefaultURL();
    }

    private void setDefaultURL() {
        String latestSnapshot = PreferencesManager.getSnapshotLatest();
        if (latestSnapshot == null || latestSnapshot.isEmpty()) {
            this.urlCombo.select(1);
        } else {
            this.urlCombo.setText(latestSnapshot);
        }
        this.searchBt.notifyListeners(13, null);
    }

    private void setInput() {
        ArrayList<String> input = new ArrayList<String>();
        input.addAll(Arrays.asList(this.predefinedUrl));
        String history = PreferencesManager.getSnapshotHistory();
        if (!history.isEmpty()) {
            String[] histories = history.split("\\|");
            List<String> data = Arrays.asList(histories);
            Collections.reverse(data);
            input.addAll(data);
        }
        this.urlCombo.setItems(input.toArray(new String[0]));
    }

    private void createBaseURLComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label baseurlLabel = new Label(composite, 0);
        baseurlLabel.setText(this.resources.getString("RootstrapPage5.Label.BaseUrl"));
        this.urlCombo = new Combo(composite, 0);
        this.urlCombo.setLayoutData((Object)gridData);
        this.urlCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 13) {
                    RootstrapSettingPage5.this.searchBt.notifyListeners(13, null);
                    e.doit = false;
                }
            }
        });
        this.urlCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String url = RootstrapSettingPage5.this.urlCombo.getText();
                if (url.equals("[Default base URL]") || url.equals("[History]") || url.isEmpty()) {
                    RootstrapSettingPage5.this.urlCombo.setText("");
                    RootstrapSettingPage5.this.searchBt.setEnabled(false);
                    String[] emptyItems = new String[]{};
                    RootstrapSettingPage5.this.tableViewer.setInput((Object)emptyItems);
                    RootstrapSettingPage5.this.tableViewer.refresh();
                } else {
                    RootstrapSettingPage5.this.searchBt.setEnabled(true);
                    RootstrapSettingPage5.this.updateSnapshotList(url.trim());
                }
                RootstrapSettingPage5.this.validPageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.urlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String url = RootstrapSettingPage5.this.urlCombo.getText();
                if (url.isEmpty()) {
                    RootstrapSettingPage5.this.searchBt.setEnabled(false);
                } else {
                    RootstrapSettingPage5.this.searchBt.setEnabled(true);
                }
                RootstrapSettingPage5.this.validPageComplete();
            }
        });
        this.searchBt = new Button(composite, 0);
        this.searchBt.setText(this.resources.getString("RootstrapPage5.Button.Search"));
        this.searchBt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent event) {
                String url = RootstrapSettingPage5.this.urlCombo.getText();
                if (url.isEmpty()) {
                    DialogUtil.openErrorDialog((String)RootstrapSettingPage5.this.resources.getString("RootstrapPage5.Error.inputBaseUrl"));
                    return;
                }
                RootstrapSettingPage5.this.updateSnapshotList(url);
                RootstrapSettingPage5.this.validPageComplete();
            }
        });
    }

    private void updateSnapshotList(String url) {
        String[] snapshots = this.getAndupdateSnapshotList(url);
        this.tableViewer.setInput((Object)snapshots);
        this.tableViewer.refresh();
        if (snapshots != null && snapshots.length > 0) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(this.tableViewer.getElementAt(0)), true);
            this.saveHistory(url);
            this.saveLatestSnapshot(url);
            this.updateData();
            this.setInput();
            this.urlCombo.setText(url);
        } else {
            String[] emptyItems = new String[]{};
            this.tableViewer.setInput((Object)emptyItems);
            this.tableViewer.refresh();
        }
    }

    private void createSnapshotComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.snapshotLabel = new Label(composite, 0);
        this.snapshotLabel.setText(this.resources.getString("RootstrapPage5.Label.Snapshots"));
        this.snapshotUrl = new Label(composite, 8);
        this.snapshotUrl.setLayoutData((Object)gridData);
        this.snapshotUrl.setText("snapshotUrl");
    }

    private void saveLatestSnapshot(String url) {
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        PreferencesManager.setSnapshotLatest((String)url);
    }

    private void saveHistory(String url) {
        String history;
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        if ((history = PreferencesManager.getSnapshotHistory()) == null || history.isEmpty()) {
            String value = String.valueOf(url) + "|";
            PreferencesManager.setSnapshotHistory((String)value);
        } else {
            String[] splited = history.split("\\|");
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = splited;
            int n = splited.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.equals(url)) {
                    list.add(s);
                }
                ++n2;
            }
            list.add(url);
            if (list.size() > 3) {
                list.remove(0);
            }
            StringBuffer sb = new StringBuffer(list.size());
            for (String s : list) {
                sb.append(s);
                sb.append("|");
            }
            PreferencesManager.setSnapshotHistory((String)sb.toString());
        }
    }

    private void updateData() {
        String snapshotUrl = this.getSnapshotURL();
        if (snapshotUrl != null) {
            RootstrapWizardData.clearSnapshots();
            RootstrapWizardData.addSnapshot(snapshotUrl);
        }
    }

    public boolean canFinish() {
        return this.validateData;
    }

    public String getSnapshotURL() {
        String baseUrl = this.urlCombo.getText();
        if (!baseUrl.endsWith("/")) {
            baseUrl = String.valueOf(baseUrl) + "/";
        }
        String snapshot = this.snapshotUrl.getText();
        try {
            URL url = new URL(baseUrl);
            URL snapshotUrl = new URL(url, snapshot);
            return snapshotUrl.toExternalForm();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void validPageComplete() {
        if (this.urlCombo.getText().isEmpty()) {
            this.pageNotCompleted(this.resources.getString("RootstrapPage5.Error.inputBaseUrl"));
        } else if (this.snapshotUrl.getText().isEmpty()) {
            this.pageNotCompleted(this.resources.getString("RootstrapPage5.Error.selectSnapshot"));
        } else {
            this.pageCompleted();
        }
    }

    private void pageNotCompleted(String errorMsg) {
        this.validateData = false;
        this.setErrorMessage(errorMsg);
        this.setPageComplete(false);
    }

    private void pageCompleted() {
        this.validateData = true;
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private String[] getAndupdateSnapshotList(String url) {
        String[] snapshots = SnapshotListParser.parse(url.trim());
        return snapshots;
    }

    private void createSnapshotListTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 50;
        gridLayout.marginHeight = 50;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(composite, 2048);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        if (this.tableViewer != null) {
            this.table = this.tableViewer.getTable();
            this.table.setLinesVisible(true);
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            if (tableViewerColumn != null) {
                TableColumn tblclmnPixel100 = tableViewerColumn.getColumn();
                layout.setColumnData((Widget)tblclmnPixel100, (ColumnLayoutData)new ColumnPixelData(350, true, true));
                tblclmnPixel100.setText("Snapshot List");
                this.tableViewer.setLabelProvider((IBaseLabelProvider)new SnapshotListTableViewerProvider());
                this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                String url = this.predefinedUrl[1];
                String[] snapshots = this.getAndupdateSnapshotList(url);
                this.tableViewer.setInput((Object)snapshots);
                this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            String select = (String)o;
                            RootstrapSettingPage5.this.snapshotUrl.setText(select);
                            RootstrapSettingPage5.this.updateData();
                            ++n2;
                        }
                    }
                });
            }
        }
    }

    private static class SnapshotListTableViewerProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SnapshotListTableViewerProvider() {
        }

        public Image getColumnImage(Object arg0, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                String str = (String)element;
                switch (columnIndex) {
                    case 0: {
                        return str.toString();
                    }
                }
            }
            return null;
        }
    }
}

