/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyManager;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildListComparator;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUI;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.PlatformProjectNature;
import org.tizen.nativeplatform.templateengine.process.SetDefaultBuildOptions;

public class PlatformProjectConverter
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    protected IProject project;
    protected final Logger logger = LoggerFactory.getLogger(PlatformProjectConverter.class);

    public PlatformProjectConverter() {
    }

    public PlatformProjectConverter(IProject selectedProject) {
        this.project = selectedProject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(boolean openDialog) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project);
        if (info != null) {
            IProjectType type = info.getManagedProject().getProjectType();
            if (type != null && type.getId().equals("org.tizen.nativebuild.target.sbi.gcc45.platform")) {
                if (openDialog) {
                    int result = DialogUtil.openQuestionDialog((String)"This project is a Platform Project.\nDo you want to continue?");
                    if (result != 64) return;
                    if (this.convert(info, true)) return;
                    DialogUtil.openErrorDialog((String)"Failed to convert the project.");
                    return;
                } else {
                    if (this.convert(info, true)) return;
                    this.logger.error("Failed to convert the project.");
                }
                return;
            } else {
                if (this.convert(info, true)) return;
                DialogUtil.openErrorDialog((String)"Failed to convert the project.");
            }
            return;
        } else {
            if (this.convert(info, false)) return;
            DialogUtil.openErrorDialog((String)"Failed to convert the project.");
        }
    }

    public void run(IAction action) {
        this.run(true);
    }

    private boolean convert(IManagedBuildInfo info, boolean isManagedProject) {
        IBuildPropertyManager bpm = ManagedBuildManager.getBuildPropertyManager();
        IBuildPropertyType bpt = bpm.getPropertyType("org.eclipse.cdt.build.core.buildArtefactType");
        IBuildPropertyValue[] vs = bpt.getSupportedValues();
        Arrays.sort(vs, BuildListComparator.getInstance());
        CfgHolder[] cfgs = null;
        IBuildPropertyValue[] iBuildPropertyValueArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildPropertyValue v = iBuildPropertyValueArray[n2];
            if (v.getId().equals("org.tizen.nativeide.buildArtefactType.platform")) {
                IToolChain[] tcs = ManagedBuildManager.getExtensionsToolChains((String)"org.eclipse.cdt.build.core.buildArtefactType", (String)v.getId(), (boolean)false);
                cfgs = CfgHolder.cfgs2items((IConfiguration[])ManagedBuildManager.getExtensionConfigurations((IToolChain)tcs[0], (String)"org.eclipse.cdt.build.core.buildArtefactType", (String)v.getId()));
            }
            ++n2;
        }
        ManagedProject mProj = null;
        try {
            int n3;
            if (isManagedProject) {
                IConfiguration[] configs;
                IConfiguration defaultConfig = info.getDefaultConfiguration();
                IManagedProject managedProj = defaultConfig.getManagedProject();
                IConfiguration[] iConfigurationArray = configs = managedProj.getConfigurations();
                int n4 = configs.length;
                n3 = 0;
                while (n3 < n4) {
                    IConfiguration config = iConfigurationArray[n3];
                    Configuration c = (Configuration)config;
                    IFolder f = this.project.getFolder(c.getName());
                    if (f.exists()) {
                        f.delete(true, null);
                    }
                    managedProj.removeConfiguration(c.getId());
                    ++n3;
                }
                this.project.setPersistentProperty(SetDefaultBuildOptions.DEFAULTFRAMEWORK_KEY, "");
                IProjectType projType = ManagedBuildManager.getProjectType((String)"org.tizen.nativebuild.target.sbi.gcc45.platform");
                mProj = new ManagedProject((IResource)this.project, projType);
                mProj.setProjectType(projType);
                mProj.setName(projType.getName());
            } else {
                ManagedBuildInfo in = ManagedBuildManager.createBuildInfo((IResource)this.project);
                IProjectType projType = ManagedBuildManager.getProjectType((String)"org.tizen.nativebuild.target.sbi.gcc45.platform");
                mProj = new ManagedProject((IResource)this.project, projType);
                if (in != null) {
                    in.setManagedProject((IManagedProject)mProj);
                }
            }
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription des = mngr.getProjectDescription(this.project, true);
            if (des == null) {
                des = mngr.createProjectDescription(this.project, false, true);
            }
            if (cfgs != null) {
                CfgHolder[] cfgHolderArray = cfgs;
                n3 = cfgs.length;
                int projType = 0;
                while (projType < n3) {
                    CfgHolder cfg = cfgHolderArray[projType];
                    Configuration cf = (Configuration)cfg.getConfiguration();
                    String id = ManagedBuildManager.calculateChildId((String)cf.getId(), null);
                    Configuration config = new Configuration(mProj, cf, id, false, true);
                    CConfigurationData data = config.getConfigurationData();
                    ICConfigurationDescription cfgDes = des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
                    config.setConfigurationDescription(cfgDes);
                    config.exportArtifactInfo();
                    IBuilder bld = config.getEditableBuilder();
                    if (bld != null) {
                        bld.setManagedBuildOn(true);
                    }
                    config.setName(cfg.getName());
                    config.setArtifactName(mProj.getDefaultArtifactName());
                    config.setManagedBuildOn(false);
                    ++projType;
                }
            }
            des.setCdtProjectCreated();
            CProjectNature.addCNature((IProject)this.project, null);
            CCProjectNature.addCCNature((IProject)this.project, null);
            PlatformProjectNature.addNatureToProject((IProject)this.project, null);
            mngr.setProjectDescription(this.project, des);
            ManagedBuildManager.saveBuildInfo((IProject)this.project, (boolean)true);
            HashMap<String, String> data = new HashMap<String, String>();
            String projName = this.project.getName();
            projName = projName != null ? projName.trim() : "";
            data.put("projectName", projName);
            String location = this.project.getLocation().toOSString();
            if (location == null) {
                location = "";
            }
            data.put("location", location);
            Template[] ts = TemplateEngineUI.getDefault().getTemplates("org.tizen.nativeide.buildArtefactType.platform");
            Template targetTemplate = null;
            Template[] templateArray = ts;
            int n5 = ts.length;
            int n6 = 0;
            while (n6 < n5) {
                Template t = templateArray[n6];
                if (t.getTemplateId().equals("PlatformProject")) {
                    targetTemplate = t;
                }
                ++n6;
            }
            if (targetTemplate != null) {
                targetTemplate.getValueStore().putAll(data);
                targetTemplate.getProcessHandler().processAll(null);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to convert platform project", (Throwable)e);
            return false;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection _selection;
        Object obj = null;
        if (selection instanceof TreeSelection && (_selection = (TreeSelection)selection) != null) {
            obj = _selection.getFirstElement();
        }
        if (obj != null && obj instanceof IProject) {
            this.project = (IProject)obj;
        }
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow arg0) {
    }
}

