/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.CommonBuildTargetManager;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;

public class PlatformBuildTargetManager
extends CommonBuildTargetManager {
    private static Logger logger = LoggerFactory.getLogger(PlatformBuildTargetManager.class);

    public String getDefaultToolchainId(String rootstrapId, String projectType) {
        String toolchainID = PlatformConfigurationManager.getToolChainId(rootstrapId, projectType);
        if (toolchainID != null) {
            return toolchainID;
        }
        logger.warn("Cannot find toolchain from projectType : " + projectType);
        return null;
    }

    public String getDefaultRootstrapId(String platformName, String[] archs) {
        PluginManager pm = PluginManager.getInstance();
        String toolChainType = "platform";
        List rsList = pm.getRootstrapList();
        for (Rootstrap rs : rsList) {
            String profile = rs.getProfile().toLowerCase();
            String version = rs.getProfileVersion().toLowerCase();
            String supportType = rs.getSupportToolchainType();
            if (supportType == null || "" == supportType || !(platformName == null ? supportType.endsWith(toolChainType) && this.containValue(archs, rs.getArchitecture()) : supportType.endsWith(toolChainType) && this.containValue(archs, rs.getArchitecture()) && platformName.toLowerCase().startsWith(profile) && platformName.toLowerCase().endsWith(version))) continue;
            return rs.getId();
        }
        return null;
    }
}

