/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.command.launcher;

import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;

public class LaunchCommandCancelThread
extends Thread {
    private IPkgCommander commander;
    private IProgressMonitor monitor;
    private boolean running = true;

    public LaunchCommandCancelThread(IPkgCommander commander, IProgressMonitor monitor) {
        this.commander = commander;
        this.monitor = monitor;
    }

    public void setTerminated() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.monitor.isCanceled()) {
                if (this.commander.getOutputReceiver() != null) {
                    this.commander.getOutputReceiver().processNewLine("Execution canceled");
                }
                this.commander.cancelExecution();
                this.monitor.subTask("Execution cancelled");
                this.running = false;
            }
            try {
                LaunchCommandCancelThread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.running = false;
            }
        }
    }
}

