/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.ui.shortcut;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.internal.ui.launch.CApplicationLaunchShortcut;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.LauncherInstances;
import org.tizen.nativeplatform.launcher.command.provider.IDebugCommandProvider;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.util.ArrayUtil;

public abstract class PlatformProjectCommonLaunchShortcut
extends CApplicationLaunchShortcut {
    protected String programPath = null;
    protected boolean reinstallOp = true;
    protected IDevice device = null;
    protected PkgCommandTarget target = null;
    protected IPackageUtil pkgUtil = null;
    private boolean result;
    protected boolean isCoredump = false;
    private final String PROJECT_SOURCE_CONTAINER = "Project Source mapping";
    private final String PLATFORM_SOURCE_CONTAINER = "Platform Source mapping";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ISourceLookupDirector fLocator;

    public void launch(IProject project, String mode) {
        this.searchAndLaunch(new Object[]{project}, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        this.searchAndLaunch(new Object[]{editor.getEditorInput()}, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    protected void searchAndLaunch(Object[] elements, String mode) {
        if (ArrayUtil.isEmpty((Object[])elements)) {
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)TizenLaunchMessages.PROJECT_NOT_SELECTED);
            return;
        }
        IDevice device = null;
        if (elements == null) {
            DialogUtil.openErrorDialog((String)TizenLaunchMessages.CANNOT_CONNECT_TO_DEVICE);
            return;
        }
        if (elements.length > 0 && elements[0] instanceof IProject) {
            device = PlatformLaunchUtil.getDefaultLaunchTarget((IProject)((IProject)elements[0]));
        }
        if (device == null && !this.isCoredump) {
            DialogUtil.openErrorDialog((String)TizenLaunchMessages.CANNOT_CONNECT_TO_DEVICE);
            return;
        }
        this.pkgUtil = PlatformInstances.getPackageUtil();
        if (elements != null && elements.length > 0) {
            int nElements = elements.length;
            int i = 0;
            while (i < nElements) {
                ILaunchConfiguration config;
                IProject project;
                IResource r;
                if (elements[i] instanceof IAdaptable && (r = (IResource)((IAdaptable)elements[i]).getAdapter(IResource.class)) != null && (project = r.getProject()) != null && (config = this.findLaunchConfiguration(project, mode)) != null) {
                    DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
                }
                ++i;
            }
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IProject project, String mode) {
        IDevice device = PlatformLaunchUtil.getDefaultLaunchTarget((IProject)project);
        if (device == null && !this.isCoredump) {
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)TizenLaunchMessages.NO_TARGET);
            return null;
        }
        ILaunchConfiguration configuration = null;
        configuration = this.createConfiguration(project, mode);
        return configuration;
    }

    protected void setPkgCommandTarget(IProject project) {
        IConfiguration config = PlatformConfigurationManager.getDefaultConfiguration((IProject)project);
        String targetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)config);
        String rootId = SmartBuildInterface.getInstance().getRootstrapIDFromTargetID(targetId);
        PlatformRootstrap rootstrap = RootstrapProxy.getProxy().getRootstrap(rootId);
        this.target = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), this.device, rootstrap);
    }

    abstract boolean needCheckDeviceRootOn();

    protected abstract ILaunchConfiguration createConfiguration(IProject var1, String var2);

    protected void setSourceContainer(IProject project, ILaunchConfigurationWorkingCopy configuration) {
        PlatformRootstrap rootstrap = this.target.getRootstrap();
        MappingSourceContainer prjMappingContainer = new MappingSourceContainer("Project Source mapping");
        MapEntrySourceContainer entry = new MapEntrySourceContainer();
        String[] infos = PlatformLaunchUtil.getProjectInfo((IProject)project);
        if (infos == null) {
            return;
        }
        String backend = String.format("/usr/src/debug/%s-%s", infos[0], infos[1]);
        String local = project.getLocation().toOSString();
        entry.setBackendPath((IPath)new Path(backend));
        entry.setLocalPath((IPath)new Path(local));
        prjMappingContainer.addMapEntry(entry);
        MappingSourceContainer platformMappingContainer = new MappingSourceContainer("Platform Source mapping");
        MapEntrySourceContainer entry2 = new MapEntrySourceContainer();
        backend = "/usr";
        PlatformConfigurationManager.getDefaultConfiguration((IProject)project);
        IDebugCommandProvider iDebugCommandProvider = LauncherInstances.getDebugCommandProvider();
        if (iDebugCommandProvider != null) {
            local = iDebugCommandProvider.getRootstrapDebugSrcPath(rootstrap);
        }
        entry2.setBackendPath((IPath)new Path(backend));
        entry2.setLocalPath((IPath)new Path(local));
        platformMappingContainer.addMapEntry(entry2);
        if (this.fLocator != null) {
            this.fLocator.dispose();
            this.fLocator = null;
        }
        try {
            String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            String type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (type == null) {
                type = configuration.getType().getSourceLocatorId();
            }
            if (type == null) {
                return;
            }
            IPersistableSourceLocator locator = this.getLaunchManager().newSourceLocator(type);
            if (!(locator instanceof AbstractSourceLookupDirector)) {
                memento = null;
                type = configuration.getType().getSourceLocatorId();
                if (type == null) {
                    return;
                }
                locator = this.getLaunchManager().newSourceLocator(type);
                if (!(locator instanceof AbstractSourceLookupDirector)) {
                    return;
                }
            }
            this.fLocator = (AbstractSourceLookupDirector)locator;
            if (memento == null) {
                this.fLocator.initializeDefaults((ILaunchConfiguration)configuration);
            } else {
                this.fLocator.initializeFromMemento(memento, (ILaunchConfiguration)configuration);
            }
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            ISourceContainer[] newContainers = new ISourceContainer[]{prjMappingContainer, platformMappingContainer};
            this.fLocator.setSourceContainers(newContainers);
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, this.fLocator.getMemento());
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, this.fLocator.getId());
        }
        catch (CoreException e) {
            this.logger.error("failed to set SourceContainer", (Throwable)e);
        }
    }

    protected void setAttributes(ILaunchConfigurationWorkingCopy wc, IProject project) {
        this.setProjectAttr(wc, project);
        this.setWorkingDirAttr(wc);
        this.setDebuggerAttr(wc);
        this.setBuildAttr(wc, project);
    }

    protected void setProjectAttr(ILaunchConfigurationWorkingCopy wc, IProject project) {
        wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        wc.setMappedResources(new IResource[]{project});
    }

    protected void setWorkingDirAttr(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
    }

    protected void setOptionsAttr(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", this.reinstallOp);
        wc.setAttribute("org.tizen.platform.launch.FROM_SHORTCUT_ATTR", true);
    }

    protected void setDebuggerAttr(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "org.tizen.nativecommon.launch.TizenDebugger");
        wc.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, "org.tizen.nativeplatform.launch.PlatformCommandFactory");
        wc.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
        wc.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
    }

    protected void setBuildAttr(ILaunchConfigurationWorkingCopy wc, IProject project) {
        wc.setAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 0);
        ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
        if (projDes != null) {
            String buildConfigID = projDes.getActiveConfiguration().getId();
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
        }
    }

    protected boolean checkPackaging(final IProject project) {
        final IConfiguration config = PlatformConfigurationManager.getDefaultConfiguration((IProject)project);
        String selectedRootstrapArch = RootstrapProxy.getProxy().getSelectedRootstrap().getArchitecture();
        boolean needsPackaging = false;
        List pkgs = this.pkgUtil.getPackages(project, config, selectedRootstrapArch);
        needsPackaging = pkgs == null || pkgs.isEmpty();
        File dir = project.getFile(config.getName()).getLocation().toFile();
        if (!needsPackaging) {
            boolean bl = needsPackaging = !dir.exists();
        }
        if (needsPackaging) {
            if (PlatformLaunchUtil.questionPackaging((IProject)project)) {
                if (!this.buildProject(project, config)) {
                    DialogUtil.openErrorDialog((String)"Fail to build package. Try to build manually");
                    return false;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommonPackageUtil.cachePkgChecksum((IProject)project, (IConfiguration)config);
                    }
                });
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean checkInitializedRootstrap() {
        return this.target != null && this.target.getRootstrap().checkInitialized();
    }

    protected boolean buildProject(final IProject project, final IConfiguration config) {
        Shell shell = this.getAvaiableShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        PlatformProjectCommonLaunchShortcut.this.result = CommonPackageUtil.build((IProject)project, (IConfiguration)config, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.logger.error("failed to build project", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            this.logger.error("failed to build project", (Throwable)e);
            return false;
        }
        return this.result;
    }

    protected Shell getAvaiableShell() {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = PlatformLaunchUtil.getAvaiableShell();
        }
        return shell;
    }
}

