/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.rpm;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativeplatform.launcher.rpm.IPkgStatusUpdater;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.PkgInstallTypes;

public class RpmStatusUpdater
implements IPkgStatusUpdater {
    private PkgCommandTarget target;

    public RpmStatusUpdater(PkgCommandTarget target) {
        this.target = target;
    }

    @Override
    public List<PkgStatus> updateStatus(CmdTargetTypes type, List<IPackage> list) {
        return this.updateStatus(this.target.getCommander(type), list);
    }

    private List<PkgStatus> updateStatus(IPkgCommander commander, List<IPackage> list) {
        ArrayList<PkgStatus> result = new ArrayList<PkgStatus>();
        if (commander == null) {
            return result;
        }
        for (IPackage pkg : list) {
            PkgStatus status = new PkgStatus(pkg);
            String[] installedVer = commander.getVer(pkg.getName());
            String newVer = pkg.getVer();
            status.setNewVer(newVer);
            status.setChecked(true);
            if (newVer == null || newVer.isEmpty()) {
                status.setChecked(false);
            }
            if (installedVer == null || installedVer.length <= 0) {
                status.setInstallInfo(PkgInstallTypes.NOT_INSTALLED);
            } else {
                status.setInstalledVer(installedVer[0]);
                if (installedVer[0].equals(newVer)) {
                    status.setInstallInfo(PkgInstallTypes.INSTALLED);
                } else {
                    status.setInstallInfo(PkgInstallTypes.DIFFERENT_VERSION);
                }
            }
            result.add(status);
        }
        return result;
    }
}

