/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.launcher.coredump.model.CoredumpModel;
import org.tizen.nativeplatform.launcher.delegate.ILaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.launcher.wizards.PlatformCoredumpLaunchWizard;
import org.tizen.nativeplatform.launcher.wizards.PlatformLaunchWizardDialog;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.types.CmdTargetTypes;

public class CoredumpLaunchConfigurationProcessor
implements ILaunchConfigurationProcessor {
    private ILaunchConfiguration launchConfig;
    private IProject project;
    private String mode;
    private IProgressMonitor monitor;
    private Shell shell;
    private PkgCommandTarget target;
    private PlatformRootstrap rootstrap;

    public CoredumpLaunchConfigurationProcessor(Shell shell, ILaunchConfiguration launchConfig, IProject project, String mode, PkgCommandTarget target, IProgressMonitor monitor) {
        this.shell = shell;
        this.launchConfig = launchConfig;
        this.project = project;
        this.mode = mode;
        this.target = target;
        this.monitor = monitor;
    }

    @Override
    public boolean process() throws CoreException {
        boolean needSetConfiguration;
        boolean bl = needSetConfiguration = !this.isSetProgramPath(this.launchConfig);
        if (needSetConfiguration) {
            return this.internalProcess(this.monitor);
        }
        this.checkChangedConfiguration(this.monitor);
        return true;
    }

    private boolean internalProcess(IProgressMonitor monitor) throws CoreException {
        return this.setLaunchConfiguration((IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private boolean setLaunchConfiguration(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        final ILaunchConfigurationWorkingCopy wc = this.launchConfig.getWorkingCopy();
        final IConfiguration config = PlatformConfigurationManager.getDefaultConfiguration((IProject)this.project);
        try {
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    PlatformCoredumpLaunchWizard wizard = new PlatformCoredumpLaunchWizard(CoredumpLaunchConfigurationProcessor.this.shell, CoredumpLaunchConfigurationProcessor.this.project, config, CoredumpLaunchConfigurationProcessor.this.target, CoredumpLaunchConfigurationProcessor.this.mode);
                    PlatformLaunchWizardDialog dlg = new PlatformLaunchWizardDialog(CoredumpLaunchConfigurationProcessor.this.shell, wizard);
                    dlg.create();
                    if (dlg.open() == 0) {
                        String programPath = dlg.getProgramPath();
                        String coredumpPath = "";
                        String originCoredumpfilePath = "";
                        String originCsfilePath = "";
                        String coredumpLocation = "";
                        CoredumpModel cmodel = dlg.getCoredumpModel();
                        if (cmodel != null) {
                            coredumpPath = dlg.getCoredumpModel().getPath();
                            originCoredumpfilePath = dlg.getCoredumpModel().getOriginCorefilePath();
                            originCsfilePath = dlg.getCoredumpModel().getOriginCsfilePath();
                            coredumpLocation = dlg.getCoredumpModel().getLocation().toString();
                        }
                        CoredumpLaunchConfigurationProcessor.this.rootstrap = dlg.getSelectedRootstrap();
                        CoredumpLaunchConfigurationProcessor.this.target.setRootstrap(CoredumpLaunchConfigurationProcessor.this.rootstrap);
                        String rootstrapName = CoredumpLaunchConfigurationProcessor.this.rootstrap.getName();
                        CoredumpLaunchConfigurationProcessor.this.setOptionAttributes(wc, programPath, coredumpPath, originCoredumpfilePath, originCsfilePath, coredumpLocation, rootstrapName);
                    }
                }
            });
        }
        finally {
            monitor.done();
        }
        return this.isSetProgramPath(this.launchConfig);
    }

    protected void setOptionAttributes(ILaunchConfigurationWorkingCopy wc, String programPath, String coredumpPath, String originCoredumpfilePath, String originCsfilePath, String coredumpLocation, String rootstrapName) {
        if (programPath != null) {
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programPath);
        }
        if (coredumpPath != null) {
            wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", coredumpPath);
        }
        if (originCoredumpfilePath != null) {
            wc.setAttribute("org.tizen.platform.launch.ORIGIN_COREFILE_ATTR", originCoredumpfilePath);
        }
        if (originCsfilePath != null) {
            wc.setAttribute("org.tizen.platform.launch.ORIGIN_CSFILE_ATTR", originCsfilePath);
        }
        if (coredumpLocation != null) {
            wc.setAttribute("org.tizen.platform.launch.COREFILE_LOC_ATTR", coredumpLocation);
        }
        if (rootstrapName != null) {
            wc.setAttribute("org.tizen.platform.launch.ROOTSTRAP_ATTR", rootstrapName);
        }
        try {
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            e.printStackTrace();
        }
    }

    protected void checkChangedConfiguration(IProgressMonitor monitor) throws CoreException {
    }

    protected boolean isSetProgramPath(ILaunchConfiguration wc) throws CoreException {
        String path = wc.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        return !path.isEmpty();
    }

    protected void killIfRunningApplication(String appId) throws CoreException {
        IPkgCommander commander = this.target.getCommander(CmdTargetTypes.DEVICE);
        boolean isRunning = commander.isRunningApp(appId);
        if (isRunning) {
            commander.killApp(appId);
        }
    }

    protected void newCoreException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.tizen.nativeplatform", message, exception);
        throw new CoreException((IStatus)status);
    }

    protected void checkCancelProcess(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            this.newCoreException(PlatformLaunchMessages.CANCELED_LAUNCH, null);
        }
    }
}

