/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.nativeplatform.pkg.model.PkgStatus;

public class ShowPackageStatusDialog
extends Dialog {
    private final String BUNDLE_NAME = String.valueOf(ShowPackageStatusDialog.class.getPackage().getName()) + ".LaunchWizardUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private int x = 0;
    private int y = 0;
    private final int width = 800;
    private final int height = 700;
    private TableViewer bsViewer;
    private TableViewer dvViewer;
    private List<PkgStatus> bsPackages = new ArrayList<PkgStatus>();
    private List<PkgStatus> dvPackages = new ArrayList<PkgStatus>();
    private List<PkgStatus> selectedBsPackages = new ArrayList<PkgStatus>();
    private List<PkgStatus> selectedDvPackages = new ArrayList<PkgStatus>();

    public ShowPackageStatusDialog(Shell parentShell, List<PkgStatus> bsPkgs, List<PkgStatus> dvPkgs) {
        super(parentShell);
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - 800) / 2;
        this.y = bounds.y + (bounds.height - 700) / 2;
        this.bsPackages = bsPkgs;
        this.dvPackages = dvPkgs;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.resources.getString("PkgDialog.Title"));
        newShell.setLocation(this.x, this.y);
        newShell.setSize(800, 700);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createDescComposite(composite);
        this.createBuildSystemLabelComposite(composite);
        this.createBuildSystemComposite(composite);
        this.createDeviceLabelComposite(composite);
        this.createDeviceComposite(composite);
        this.tableRefresh();
        return null;
    }

    private void createDescComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        Label message = new Label(composite, 0);
        message.setText(this.resources.getString("PkgDialog.Desc"));
    }

    protected void okPressed() {
        PkgStatus pkgStatus;
        TableItem item;
        this.selectedBsPackages.clear();
        this.selectedDvPackages.clear();
        int recentTableIndex = this.bsViewer.getTable().getItemCount();
        int i = 0;
        while (i < recentTableIndex) {
            item = null;
            item = this.bsViewer.getTable().getItem(i);
            pkgStatus = (PkgStatus)item.getData();
            if (pkgStatus.isChecked()) {
                this.selectedBsPackages.add(pkgStatus);
            }
            ++i;
        }
        recentTableIndex = this.dvViewer.getTable().getItemCount();
        i = 0;
        while (i < recentTableIndex) {
            item = null;
            item = this.dvViewer.getTable().getItem(i);
            pkgStatus = (PkgStatus)item.getData();
            if (pkgStatus.isChecked()) {
                this.selectedDvPackages.add(pkgStatus);
            }
            ++i;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public List<PkgStatus> getSelectedBsPkgs() {
        return this.selectedBsPackages;
    }

    public List<PkgStatus> getSelectedDvPkgs() {
        return this.selectedDvPackages;
    }

    private void createBuildSystemLabelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        Label tableDesc = new Label(composite, 0);
        tableDesc.setText(this.resources.getString("PkgDialog.Label.Buildsystem"));
    }

    private void createBuildSystemComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.bsViewer = new TableViewer(composite, 2848);
        this.createColumns(composite, this.bsViewer);
        Table packageTable = this.bsViewer.getTable();
        packageTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    PkgStatus pkgStatus;
                    pkgStatus.setChecked(!(pkgStatus = (PkgStatus)event.item.getData()).isChecked());
                }
            }
        });
        packageTable.setHeaderVisible(true);
        packageTable.setLinesVisible(true);
        this.bsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.bsViewer.setInput(this.bsPackages);
    }

    private void createDeviceLabelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        Label tableDesc = new Label(composite, 0);
        tableDesc.setText(this.resources.getString("PkgDialog.Label.Device"));
    }

    private void createDeviceComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.dvViewer = new TableViewer(composite, 2848);
        this.createColumns(composite, this.dvViewer);
        Table packageTable = this.dvViewer.getTable();
        packageTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    PkgStatus pkgStatus;
                    pkgStatus.setChecked(!(pkgStatus = (PkgStatus)event.item.getData()).isChecked());
                }
            }
        });
        packageTable.setHeaderVisible(true);
        packageTable.setLinesVisible(true);
        this.dvViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dvViewer.setInput(this.dvPackages);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Continue", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Package Name", "Arch", "New Version", "Installed Version", "Status"};
        int[] bounds = new int[]{250, 60, 150, 150, 150};
        TableViewerColumn colPackage = this.createTableViewerColumn(viewer, titles[0], bounds[0], 0);
        colPackage.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkgStatus = (PkgStatus)element;
                return pkgStatus.getPackage().getName();
            }
        });
        TableViewerColumn colArch = this.createTableViewerColumn(viewer, titles[1], bounds[1], 0);
        colArch.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkgStatus = (PkgStatus)element;
                return pkgStatus.getPackage().getArch();
            }
        });
        TableViewerColumn colNewVer = this.createTableViewerColumn(viewer, titles[2], bounds[2], 0);
        colNewVer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkgStatus = (PkgStatus)element;
                return pkgStatus.getNewVer();
            }
        });
        TableViewerColumn colInsVer = this.createTableViewerColumn(viewer, titles[3], bounds[3], 0);
        colInsVer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkgStatus = (PkgStatus)element;
                return pkgStatus.getInstalledVer();
            }
        });
        TableViewerColumn colStatus = this.createTableViewerColumn(viewer, titles[4], bounds[4], 0);
        colStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkgStatus = (PkgStatus)element;
                String status = pkgStatus.getInstallInfo().toString();
                return status;
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int Style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, Style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void tableRefresh() {
        PkgStatus pkgStatus;
        TableItem item;
        int recentTableIndex = this.bsViewer.getTable().getItemCount();
        int i = 0;
        while (i < recentTableIndex) {
            item = null;
            item = this.bsViewer.getTable().getItem(i);
            pkgStatus = (PkgStatus)item.getData();
            item.setChecked(pkgStatus.isChecked());
            ++i;
        }
        recentTableIndex = this.dvViewer.getTable().getItemCount();
        i = 0;
        while (i < recentTableIndex) {
            item = null;
            item = this.dvViewer.getTable().getItem(i);
            pkgStatus = (PkgStatus)item.getData();
            item.setChecked(pkgStatus.isChecked());
            ++i;
        }
    }
}

