/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap;

import java.util.HashSet;
import java.util.Set;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.rootstrap.IRootstrapChangedListener;

public class RootstrapListenerManager {
    protected static final Set<IRootstrapChangedListener> changedListener = new HashSet<IRootstrapChangedListener>();

    public static void addListener(IRootstrapChangedListener listener) {
        changedListener.add(listener);
    }

    public static void removeListener(IRootstrapChangedListener listener) {
        changedListener.remove(listener);
    }

    public static void updateSubtitle(String content) {
        for (IRootstrapChangedListener tl : changedListener) {
            if (tl == null) continue;
            tl.updateSubTitle(content);
        }
    }

    public static void updateToolbarEnable() {
        for (IRootstrapChangedListener tl : changedListener) {
            if (tl == null) continue;
            tl.updateToolbarEnable();
        }
    }

    public static void notifyChangedRootstrap() {
        for (IRootstrapChangedListener tl : changedListener) {
            if (tl == null) continue;
            tl.rootstrapChanged();
        }
    }

    public static void updateRootstrapDescription(PlatformRootstrap rootstrap) {
        for (IRootstrapChangedListener tl : changedListener) {
            if (tl == null) continue;
            tl.updateRootstrapDescription(rootstrap);
        }
    }
}

