/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.rpm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.PkgInfo;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;

public class RpmDebugPackagesResolver {
    private IProgressMonitor monitor;
    private PkgCommandTarget target;
    private IPkgCommander rootstrapCommander;
    private IPkgCommander deviceCommander;

    public RpmDebugPackagesResolver(PkgCommandTarget target, IProgressMonitor monitor) {
        this.target = target;
        this.rootstrapCommander = target.getRootstrapCommander();
        this.deviceCommander = target.getDeviceCommander();
        this.monitor = monitor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resolve(String command) {
        PkgInfo pInfo;
        String[] debugPkgs;
        this.monitor.beginTask("", 2);
        this.monitor.subTask("Checking the package is installed to rootstrap...");
        ICommandStatus status = null;
        Map provides = this.deviceCommander.getWhatProvides(command, IPkgCommander.TOOL.RPM);
        ArrayList<String> installablePackages = new ArrayList<String>();
        String pkgName = "";
        String pkgList = "";
        String installedPkgList = "";
        String notFoundPkgList = "";
        StringBuffer msg = new StringBuffer();
        boolean notFoundPkgs = false;
        if (provides != null && !provides.isEmpty()) {
            Iterator iterator = provides.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                pkgName = key = (String)iterator.next();
            }
        }
        if (pkgName.isEmpty()) {
            msg.append("Failed to find package which provides next command:");
            msg.append("\n");
            msg.append(" - ");
            msg.append(command);
            msg.append("\n\n");
            msg.append("You should install binary and debug packages to rootstrap for debugging.");
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Error", (String)msg.toString());
            return false;
        }
        if (!this.rootstrapCommander.checkPkgInstalled(pkgName)) {
            PkgInfo pInfo2 = this.rootstrapCommander.getPkgInfo(pkgName, IPkgCommander.TOOL.ZYPPER);
            if (pInfo2 != null) {
                installablePackages.add(pkgName);
                pkgList = String.valueOf(pkgList) + String.format("- %s\n", pkgName);
            } else {
                notFoundPkgs = true;
                notFoundPkgList = String.valueOf(notFoundPkgList) + String.format("- %s\n", pkgName);
            }
        } else {
            installedPkgList = String.valueOf(installedPkgList) + String.format("- %s\n", pkgName);
        }
        String[] stringArray = debugPkgs = PlatformLaunchUtil.getDebugPackageName((IPkgCommander)this.deviceCommander, (String)pkgName);
        int n = debugPkgs.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            if (pkg != null && !pkg.isEmpty()) {
                if (!this.rootstrapCommander.checkPkgInstalled(pkg)) {
                    PkgInfo pInfo3 = this.rootstrapCommander.getPkgInfo(pkg, IPkgCommander.TOOL.ZYPPER);
                    if (pInfo3 != null) {
                        installablePackages.add(pkg);
                        pkgList = String.valueOf(pkgList) + String.format("- %s\n", pkg);
                    } else {
                        notFoundPkgs = true;
                        notFoundPkgList = String.valueOf(notFoundPkgList) + String.format("- %s\n", pkg);
                    }
                } else {
                    installedPkgList = String.valueOf(installedPkgList) + String.format("- %s\n", pkg);
                }
            }
            ++n2;
        }
        String develPkg = PlatformLaunchUtil.getDevelPackageName((IPkgCommander)this.rootstrapCommander, (String)pkgName);
        if (develPkg != null && !develPkg.isEmpty() && !this.rootstrapCommander.checkPkgInstalled(develPkg) && (pInfo = this.rootstrapCommander.getPkgInfo(develPkg, IPkgCommander.TOOL.ZYPPER)) != null) {
            installablePackages.add(develPkg);
            pkgList = String.valueOf(pkgList) + String.format("- %s\n", develPkg);
        }
        this.monitor.worked(1);
        if (!installablePackages.isEmpty()) {
            if (notFoundPkgs) {
                msg.append("There are not debug packages in repositories:\n");
                msg.append(notFoundPkgList);
                msg.append("\n");
            }
            msg.append("Found debug packages for \"");
            msg.append(pkgName);
            msg.append("\" package:");
            msg.append("\n");
            msg.append(pkgList);
            msg.append("\n");
            msg.append("Do you want to install it to rootstrap?");
            msg.append("\n");
            msg.append("(These packages should be installed for debugging)");
            int result = DialogUtil.openQuestionDialog((String)msg.toString());
            if (result != 64) return false;
            this.monitor.subTask("Install packages...");
            String[] installPkgs = installablePackages.toArray(new String[0]);
            status = this.rootstrapCommander.installRemotePkg(installPkgs, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!status.isOk()) {
                return false;
            }
            for (String pkg : installablePackages) {
                if (this.rootstrapCommander.checkPkgInstalled(pkg)) continue;
                return false;
            }
        } else if (notFoundPkgs) {
            msg.append("There are not debug packages in repositories:");
            msg.append("\n");
            msg.append(notFoundPkgList);
            msg.append("\n");
            msg.append("You should install binary and debug packages to rootstrap for debugging.");
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Error", (String)msg.toString());
            return false;
        }
        this.monitor.worked(1);
        this.monitor.done();
        return true;
    }
}

