/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativeplatform.linux.rootstrap.core.RootstrapImporter;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.view.ui.RootstrapView;

public class ActionImportRootstrap
extends Action {
    protected final String BUNDLE_NAME = String.valueOf(ActionImportRootstrap.class.getPackage().getName()) + ".RootstrapUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(ActionImportRootstrap.class);
    protected Shell shell;
    protected RootstrapView view;

    public ActionImportRootstrap(RootstrapView view, Shell shell) {
        this.view = view;
        this.shell = shell;
        this.setId(this.resources.getString("View.Import.Rootstrap.ToolTip"));
        this.setText(this.resources.getString("View.Import.Rootstrap.ToolTip"));
        Image img = ImageUtil.getImage((String)"org.tizen.nativeplatform.linux", (String)"icons/rootstrap/import.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)img));
    }

    public void run() {
        FileDialog fd = new FileDialog(this.shell, 4096);
        fd.setText(this.resources.getString("FileDlg.Title.Import"));
        String[] extensions = new String[]{"*.tar"};
        fd.setFilterExtensions(extensions);
        String resultFilePath = fd.open();
        this.view.setGeneratedRootstrap(null);
        if (resultFilePath != null) {
            if (!resultFilePath.endsWith(".tar")) {
                resultFilePath = String.valueOf(resultFilePath) + ".tar";
            }
            final String selectedFilePath = resultFilePath;
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.view.getShell());
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(ActionImportRootstrap.this.resources.getString("Action.Msg.Progress.Importing"), -1);
                        PlatformRootstrap generatedRootstrap = RootstrapImporter.importRootstrap(selectedFilePath, monitor);
                        ActionImportRootstrap.this.view.setGeneratedRootstrap(generatedRootstrap);
                    }
                });
            }
            catch (InvocationTargetException e) {
                this.logger.error(this.resources.getString("Action.Msg.Error.ImportFailed"), (Throwable)e);
                DialogUtil.openErrorDialog((String)String.format("%s\n * %s", this.resources.getString("Action.Msg.Error.ImportFailed"), e.getMessage()));
                return;
            }
            catch (InterruptedException e) {
                this.logger.error(this.resources.getString("Action.Msg.Error.ImportFailed"), (Throwable)e);
                DialogUtil.openErrorDialog((String)String.format("%s\n * %s", this.resources.getString("Action.Msg.Error.ImportFailed"), e.getMessage()));
                return;
            }
        }
        if (this.view.getGeneratedRootstrap() == null) {
            return;
        }
        RootstrapInstances.getRootstrapManager().addRootstrap(this.view.getGeneratedRootstrap());
        DialogUtil.openMessageDialog((Shell)this.view.getShell(), (String)this.resources.getString("Action.Msg.Info.ImportOK"));
    }
}

