/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkgmgr.PkgMgrInitializer;
import org.tizen.nativeplatform.pkgmgr.ui.RPMPackageDialog;
import org.tizen.nativeplatform.repo.commander.LocalRepoMounter;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.IDevice;

public class PackageManagerAction
extends Action {
    protected final String BUNDLE_NAME = String.valueOf(PackageManagerAction.class.getPackage().getName()) + ".RootstrapUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(PackageManagerAction.class);
    protected IProject project;
    protected Shell shell;
    protected PlatformRootstrap selectedRootstrap;

    public PackageManagerAction(Shell shell, IProject project, PlatformRootstrap selectedRootstrap) {
        this.project = project;
        this.shell = shell;
        this.selectedRootstrap = selectedRootstrap;
    }

    public void run() {
        this.action();
    }

    protected void action() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                boolean initialized = PackageManagerAction.this.selectedRootstrap.checkInitialized();
                if (!initialized) {
                    DialogUtil.openMessageDialog((String)String.format(PackageManagerAction.this.resources.getString("Action.Msg.Info.Init"), PackageManagerAction.this.selectedRootstrap.getName()));
                    return;
                }
                IDevice device = ConnectionPlugin.getDefault().getCurrentDevice();
                final PkgCommandTarget cmdTarget = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), device, PackageManagerAction.this.selectedRootstrap);
                RPMPackageDialog dlg = new RPMPackageDialog(PackageManagerAction.this.shell, cmdTarget);
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(PackageManagerAction.this.shell);
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("", 1);
                            try {
                                PkgMgrInitializer initializer = new PkgMgrInitializer(cmdTarget);
                                initializer.fastInitData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    PackageManagerAction.this.logger.error(PackageManagerAction.this.resources.getString("Action.Msg.Error.InitFailed.PkgMgr"), (Throwable)e);
                    DialogUtil.openErrorDialog((String)String.format("%s\n * %s\n * %s", PackageManagerAction.this.resources.getString("Action.Msg.Error.InitFailed.PkgMgr"), e.getMessage(), "If no response for long time, check your proxy setting."));
                    return;
                }
                catch (InterruptedException e) {
                    PackageManagerAction.this.logger.error(PackageManagerAction.this.resources.getString("Action.Msg.Error.InitFailed.PkgMgr"), (Throwable)e);
                    DialogUtil.openErrorDialog((String)String.format("%s\n * %s\n * %s", PackageManagerAction.this.resources.getString("Action.Msg.Error.InitFailed.PkgMgr"), e.getMessage(), "If no response for long time, check your proxy setting."));
                    return;
                }
                dlg.open();
                dialog = new ProgressMonitorDialog(PackageManagerAction.this.shell);
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask((this).PackageManagerAction.this.resources.getString("Action.Msg.Progress.Finalizing.PkgMgr"), 3);
                            try {
                                monitor.subTask((this).PackageManagerAction.this.resources.getString("Action.Msg.Progress.Umount.rootstrap"));
                                LocalRepoMounter.clearMounted((IProgressMonitor)monitor);
                                monitor.worked(1);
                                monitor.subTask((this).PackageManagerAction.this.resources.getString("Action.Msg.Progress.Refresh.rootstrap"));
                                RootstrapInstances.getRootstrapManager().updateRootstrap((this).PackageManagerAction.this.selectedRootstrap);
                                monitor.worked(1);
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    PackageManagerAction.this.logger.error(PackageManagerAction.this.resources.getString("Action.Msg.Error.FiniFailed.PkgMgr"), (Throwable)e);
                    DialogUtil.openErrorDialog((String)String.format("%s\n * %s", PackageManagerAction.this.resources.getString("Action.Msg.Error.FiniFailed.PkgMgr"), e.getMessage()));
                    return;
                }
                catch (InterruptedException e) {
                    PackageManagerAction.this.logger.error(PackageManagerAction.this.resources.getString("Action.Msg.Error.FiniFailed.PkgMgr"), (Throwable)e);
                    DialogUtil.openErrorDialog((String)String.format("%s\n * %s", PackageManagerAction.this.resources.getString("Action.Msg.Error.FiniFailed.PkgMgr"), e.getMessage()));
                    return;
                }
            }

            @Override
            public boolean doCheckEnable() {
                return true;
            }
        });
    }

    protected void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    protected static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }
}

