/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.linux.rootstrap.core.RootstrapRemover;
import org.tizen.nativeplatform.linux.rootstrap.core.RootstrapXMLGenerator;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.util.RootstrapUtil;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;

public class RootstrapGenerator {
    public static PlatformRootstrap generate(String name, String arch, String version, List<Repository> repositories, IPath confFile, boolean immediateGen, IProgressMonitor monitor) throws InterruptedException {
        RootstrapXMLGenerator xmlGenerator;
        boolean initialized = false;
        String id = name;
        ArrayList<String> repos = new ArrayList<String>();
        for (Repository repo : repositories) {
            repos.add(repo.getUri());
        }
        if (immediateGen) {
            if (RootstrapGenerator.generateRootstrap(RootstrapUtil.getUserRootstrapPath((String)id), repos, arch, confFile, monitor)) {
                initialized = true;
            } else {
                return null;
            }
        }
        if ((xmlGenerator = new RootstrapXMLGenerator(id, name, arch, version, repos, confFile)).generate()) {
            PluginManager pm = PluginManager.getInstance();
            pm.reInit();
            Rootstrap rs = pm.getRootstrap(id);
            rs.setDefault(false);
            return new PlatformRootstrap(rs.getDocument(), rs.getFile(), initialized);
        }
        if (immediateGen) {
            RootstrapRemover.remove(id, arch);
        }
        return null;
    }

    private static boolean generateRootstrap(String rootstrapPath, List<String> reposURLs, String arch, IPath confFile, IProgressMonitor monitor) throws InterruptedException {
        String[] proxyInfo;
        File rootstrapDir = new File(rootstrapPath);
        String id = rootstrapDir.getName();
        String tempDirPath = null;
        tempDirPath = PlatformInstances.getBuildCommandUtil().makeTempDirectory();
        PlatformRootstrap latestTempRootstrap = new PlatformRootstrap(id, id, arch, tempDirPath, null, "", false);
        RootstrapRemover.setLatestTempRootstrap(latestTempRootstrap);
        String rogen = RootstrapUtil.getRogenBinPath();
        String baseArch = RootstrapUtil.getBaseArchitecture((String)arch);
        String urlData = "";
        for (String url : reposURLs) {
            urlData = String.valueOf(urlData) + (urlData.isEmpty() ? url : "," + url);
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        Map env = sbi.getEnvMap();
        if (PreferencesManager.isProxyUsed() && (proxyInfo = PreferencesManager.getProxyParsedURL()) != null) {
            String protocol = proxyInfo[0];
            String host = proxyInfo[1];
            String port = proxyInfo[2];
            String envKey = String.format("%s_proxy", protocol);
            String envValue = String.format("%s://%s:%s", protocol, host, port);
            env.put(envKey, envValue);
        }
        String command = String.format("\\\"%s\\\" -n %s -a %s -u %s -p rpm --ctrl GBS -g TizenPlatform", rogen, id, baseArch, urlData);
        if (confFile != null && !confFile.isEmpty()) {
            command = String.valueOf(command) + String.format(" -d %s", confFile.toOSString());
        }
        if (rootstrapDir.exists()) {
            if (!HostCommandLauncher.executeSudoWithExpect((String)command, (String)rootstrapDir.getParent(), (Map)env, (String)"Platform Internal", (IProgressMonitor)monitor)) {
                return false;
            }
        } else {
            if (!HostCommandLauncher.executeSudoWithExpect((String)command, (String)tempDirPath, (Map)env, (String)"Platform Internal", (IProgressMonitor)monitor)) {
                return false;
            }
            String rootstrapBasePath = rootstrapDir.getParent();
            HostCommandLauncher.execute((String)String.format("mkdir -p %s", rootstrapBasePath));
            HostCommandLauncher.executeSudo((String)String.format("sudo -S mv %s/%s %s/", tempDirPath, id, rootstrapBasePath));
        }
        return true;
    }

    public static boolean generate(PlatformRootstrap rootstrap, IProgressMonitor monitor) throws InterruptedException {
        String[] proxyInfo;
        File rootstrapDir = new File(rootstrap.getPath());
        String id = rootstrapDir.getName();
        String tempDirPath = null;
        tempDirPath = PlatformInstances.getBuildCommandUtil().makeTempDirectory();
        PlatformRootstrap latestTempRootstrap = new PlatformRootstrap(rootstrap.getDocument(), rootstrap.getFile(), false);
        RootstrapRemover.setLatestTempRootstrap(latestTempRootstrap);
        String rogen = RootstrapUtil.getRogenBinPath();
        String baseArch = RootstrapUtil.getBaseArchitecture((String)rootstrap.getArchitecture());
        String urlData = "";
        for (String url : rootstrap.getJustRepoURLs()) {
            urlData = String.valueOf(urlData) + (urlData.isEmpty() ? url : "," + url);
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        Map env = sbi.getEnvMap();
        if (PreferencesManager.isProxyUsed() && (proxyInfo = PreferencesManager.getProxyParsedURL()) != null) {
            String protocol = proxyInfo[0];
            String host = proxyInfo[1];
            String port = proxyInfo[2];
            String envKey = String.format("%s_proxy", protocol);
            String envValue = String.format("%s://%s:%s", protocol, host, port);
            env.put(envKey, envValue);
        }
        String command = String.format("\\\"%s\\\" -n %s -a %s -u %s -p rpm --ctrl GBS -g TizenPlatform", rogen, id, baseArch, urlData);
        IPath confFile = rootstrap.getConfFile();
        if (confFile != null && !confFile.isEmpty()) {
            command = String.valueOf(command) + String.format(" -d %s", confFile.toOSString());
        }
        if (rootstrapDir.exists()) {
            if (!HostCommandLauncher.executeSudoWithExpect((String)command, (String)rootstrapDir.getParent(), (Map)env, (String)"Platform Internal", (IProgressMonitor)monitor)) {
                return false;
            }
        } else {
            if (!HostCommandLauncher.executeSudoWithExpect((String)command, (String)tempDirPath, (Map)env, (String)"Platform Internal", (IProgressMonitor)monitor)) {
                return false;
            }
            String rootstrapBasePath = rootstrapDir.getParent();
            HostCommandLauncher.execute((String)String.format("mkdir -p %s", rootstrapBasePath));
            HostCommandLauncher.executeSudo((String)String.format("sudo -S mv %s/%s %s/", tempDirPath, id, rootstrapBasePath));
        }
        return true;
    }
}

