/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.rootstrap.util.RootstrapConstants;
import org.tizen.nativeplatform.rootstrap.util.SnapshotBuildXMLParser2;

public class SnapshotParser {
    public static final int CONNECT_TIMEOUT = 2000;
    public static final String BUILD_XML = "builddata/build.xml";
    public static final Logger logger = LoggerFactory.getLogger(SnapshotParser.class);

    private static boolean isSupportedArch(String arch) {
        for (String sarch : RootstrapConstants.SUPPORTED_ARCH) {
            if (!sarch.equals(arch)) continue;
            return true;
        }
        return false;
    }

    public static List<Architecture> parsePkgUrl2(String url, IProgressMonitor monitor) {
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        try {
            URL packageUrl = new URL(url);
            String path = packageUrl.getPath();
            Path urlPath = new Path(path);
            monitor.beginTask("", urlPath.segmentCount());
            if (!SnapshotParser.ping(url)) {
                SnapshotParser.openErrorDialog("Connection Error:\n" + url);
                ArrayList<Architecture> arrayList = new ArrayList<Architecture>();
                return arrayList;
            }
            ArrayList<Architecture> archs = new ArrayList<Architecture>();
            String arch = new Path(url).removeLastSegments(1).lastSegment();
            if (SnapshotParser.isSupportedArch(arch)) {
                Architecture archModel = new Architecture(arch);
                archModel.addRepository(url);
                archs.add(archModel);
            } else {
                SnapshotParser.openErrorDialog("Can not find architecture [" + arch + "]:\n" + url);
            }
            ArrayList<Architecture> arrayList = archs;
            return arrayList;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        finally {
            monitor.done();
        }
        SnapshotParser.openErrorDialog("Please check repository validation:\n" + url);
        return new ArrayList<Architecture>();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Architecture> parsePkgUrl(String url, IProgressMonitor monitor) {
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        try {
            packageUrl = new URL(url);
            protocol = packageUrl.getProtocol();
            path = packageUrl.getPath();
            host = packageUrl.getHost();
            port = packageUrl.getPort();
            parentUrl = null;
            urlPath = new Path(path);
            monitor.beginTask("", urlPath.segmentCount());
            if (!SnapshotParser.ping(url)) {
                SnapshotParser.openErrorDialog("Connection Error:\n" + url);
                var16_10 = new ArrayList<Architecture>();
                return var16_10;
            }
            ** GOTO lbl31
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        finally {
            monitor.done();
        }
        SnapshotParser.openErrorDialog("Can not find build.xml:\n" + url);
        return new ArrayList<Architecture>();
        while (!SnapshotParser.ping((buildXmlUrl = new URL(parentUrl = new URL(protocol, host, port, (urlPath = urlPath.removeLastSegments(1)).toString()), "builddata/build.xml")).toString())) {
            monitor.worked(1);
lbl31:
            // 2 sources

            if (urlPath.hasTrailingSeparator()) continue;
        }
        if (parentUrl == null) {
            parentUrl = new URL(protocol, host, port, urlPath.toString());
            SnapshotParser.logger.error("Failed to create parentUrl.");
        }
        archs = SnapshotParser.parse(parentUrl.toString(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        _archs = new ArrayList<Architecture>();
        _archs.addAll(archs);
        i = 0;
        while (i < archs.size()) {
            fileCheck = false;
            for (String repo : archs.get(i).getRepositories()) {
                if (!new Path(url).equals((Object)new Path(repo))) continue;
                fileCheck = true;
                break;
            }
            if (!fileCheck) {
                _archs.remove(archs.get(i));
            }
            ++i;
        }
        var16_11 = _archs;
        monitor.done();
        return var16_11;
    }

    public static List<Architecture> parse(String url, IProgressMonitor monitor) {
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        try {
            monitor.beginTask("", 2);
            monitor.subTask("Checking connection...");
            if (!SnapshotParser.ping(url)) {
                SnapshotParser.openErrorDialog("Connection Error:\n" + url);
                ArrayList<Architecture> arrayList = new ArrayList<Architecture>();
                return arrayList;
            }
            URL snapshotUrl = new URL(url);
            URL buildXmlUrl = new URL(snapshotUrl, BUILD_XML);
            if (!SnapshotParser.ping(buildXmlUrl.toString())) {
                SnapshotParser.openErrorDialog("Can not find build.xml:\n" + buildXmlUrl.toString());
                ArrayList<Architecture> arrayList = new ArrayList<Architecture>();
                return arrayList;
            }
            monitor.worked(1);
            monitor.subTask("Parsing build.xml file...");
            BufferedInputStream in = new BufferedInputStream(buildXmlUrl.openStream());
            List<Architecture> list = SnapshotBuildXMLParser2.parse(snapshotUrl, in);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            monitor.done();
        }
        return new ArrayList<Architecture>();
    }

    private static boolean ping(String url) {
        url = url.replaceFirst("^https", "http");
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void openErrorDialog(final String error) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                DialogUtil.openErrorDialog((String)error);
            }
        });
    }
}

