/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.rootstrap.IRootstrapManager;
import org.tizen.nativeplatform.rootstrap.PlatformRootstrapStore;
import org.tizen.nativeplatform.rootstrap.RootstrapInitializer;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.RootstrapSelectionManager;

public class CommonRootstrapManager {
    public static List<PlatformRootstrap> getRootstraps() {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        return iRootstrapManager != null ? iRootstrapManager.getRootstraps() : null;
    }

    public static PlatformRootstrap getRootstrap(String id) {
        for (PlatformRootstrap r : CommonRootstrapManager.getRootstraps()) {
            if (!r.getId().equals(id)) continue;
            return r;
        }
        return null;
    }

    public static PlatformRootstrap getDefaultRootstrap(String arch) {
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            String[] archs = PlatformConfigurationManager.ARCHGROUP_X86;
            if (PlatformConfigurationManager.isArmArch((String)arch)) {
                archs = PlatformConfigurationManager.ARCHGROUP_ARM;
            }
            if (!r.isDefault() || !PlatformConfigurationManager.containValue((String[])archs, (String)r.getArchitecture())) continue;
            return r;
        }
        return null;
    }

    public static PlatformRootstrap getSelectedRootstrap() {
        return RootstrapSelectionManager.getSelectedRootstrap();
    }

    public static boolean isInitialized(String rootId) {
        PlatformRootstrap root = CommonRootstrapManager.getRootstrap(rootId);
        if (root != null) {
            return root.isInitialized();
        }
        return false;
    }

    public static boolean checkInitialized(String rootId) {
        PlatformRootstrap root = CommonRootstrapManager.getRootstrap(rootId);
        if (root != null) {
            return root.checkInitialized();
        }
        return false;
    }

    public static boolean existsRootstrap(String id) {
        for (PlatformRootstrap r : CommonRootstrapManager.getRootstraps()) {
            if (!r.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsRootstrap(String id, String selectedName) {
        for (PlatformRootstrap r : CommonRootstrapManager.getRootstraps()) {
            if (r.getId().equals(selectedName) || !r.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static List<PlatformRootstrap> getRootstraps(int listType) {
        ArrayList<PlatformRootstrap> totalList = new ArrayList<PlatformRootstrap>();
        if ((listType & 2) != 0) {
            CommonRootstrapManager.mergeListExceptDuplicated(CommonRootstrapManager.getInitializedRootstrap(), totalList);
        }
        if ((listType & 4) != 0) {
            CommonRootstrapManager.mergeListExceptDuplicated(CommonRootstrapManager.getNonInitializedRootstrap(), totalList);
        }
        if ((listType & 8) != 0) {
            CommonRootstrapManager.mergeListExceptDuplicated(CommonRootstrapManager.getX86Rootstrap(), totalList);
        }
        if ((listType & 0x10) != 0) {
            CommonRootstrapManager.mergeListExceptDuplicated(CommonRootstrapManager.getArmRootstrap(), totalList);
        }
        return totalList;
    }

    public static List<PlatformRootstrap> getArmRootstrap() {
        RootstrapInitializer.checkInitialized();
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            String arch = r.getArchitecture();
            if (!PlatformConfigurationManager.containValue((String[])PlatformConfigurationManager.ARCHGROUP_ARM, (String)arch)) continue;
            list.add(r);
        }
        return list;
    }

    public static List<PlatformRootstrap> getX86Rootstrap() {
        RootstrapInitializer.checkInitialized();
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            String arch = r.getArchitecture();
            if (!PlatformConfigurationManager.containValue((String[])PlatformConfigurationManager.ARCHGROUP_X86, (String)arch)) continue;
            list.add(r);
        }
        return list;
    }

    public static List<PlatformRootstrap> getInitializedRootstrap() {
        RootstrapInitializer.checkInitialized();
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            if (!r.isInitialized()) continue;
            list.add(r);
        }
        return list;
    }

    public static List<PlatformRootstrap> getNonInitializedRootstrap() {
        RootstrapInitializer.checkInitialized();
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            if (r.isInitialized()) continue;
            list.add(r);
        }
        return list;
    }

    private static void mergeListExceptDuplicated(List<PlatformRootstrap> source, List<PlatformRootstrap> target) {
        for (PlatformRootstrap r : source) {
            if (target.contains(r)) continue;
            target.add(r);
        }
    }
}

