/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.view.ui;

import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.rootstrap.IRootstrapChangedListener;
import org.tizen.nativeplatform.rootstrap.IRootstrapManager;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.RootstrapListenerManager;
import org.tizen.nativeplatform.rootstrap.RootstrapSelectionManager;
import org.tizen.nativeplatform.rootstrap.view.ui.IRootstrapViewProvider;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class RootstrapView
extends ViewPart {
    private TableViewer tableViewer;
    private final int COL_IDX_ROOTNAME = 0;
    private final int COL_IDX_ARCH = 1;
    private Text rootDescText;
    private MenuManager menuMgr;
    private PlatformRootstrap generatedRootstrap;
    private final int MINIMUM_VIEW_WIDTH = 300;
    private IProject selectedProject;
    private IProject project;
    private Shell shell;
    private Label subTitle;
    private Composite parentComposite;
    private static final String PLATFORM_PERSPECTIVE_ID = "org.tizen.nativeplatform.perspective";
    private final String BUNDLE_NAME = String.valueOf(RootstrapView.class.getPackage().getName()) + ".RootstrapUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(RootstrapView.class);
    private IRootstrapChangedListener cListener = new IRootstrapChangedListener(){

        @Override
        public void rootstrapChanged() {
            if (RootstrapView.this.tableViewer != null && !RootstrapView.this.tableViewer.getControl().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RootstrapView.this.tableViewer.refresh();
                    }
                });
            }
        }

        @Override
        public void updateRootstrapDescription(final PlatformRootstrap rootstrap) {
            if (RootstrapView.this.tableViewer != null && !RootstrapView.this.tableViewer.getControl().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (rootstrap != null) {
                            String desc = RootstrapView.this.getRootstrapDescription(rootstrap);
                            RootstrapView.this.rootDescText.setText(desc);
                        } else {
                            RootstrapView.this.rootDescText.setText("");
                        }
                    }
                });
            }
        }

        @Override
        public void updateToolbarEnable() {
            if (RootstrapView.this.tableViewer != null && !RootstrapView.this.tableViewer.getControl().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RootstrapView.this.updateToolbar();
                    }
                });
            }
        }

        @Override
        public void updateSubTitle(String content) {
            RootstrapView.this.setConnectionInfoLabel(content);
        }
    };
    private ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            String perspectiveID = sourcepart.getSite().getPage().getPerspective().getId();
            if (!perspectiveID.equals(RootstrapView.PLATFORM_PERSPECTIVE_ID)) {
                return;
            }
            if (!("Project Explorer".equals(sourcepart.getTitle()) || "Navigator".equals(sourcepart.getTitle()) || sourcepart instanceof IEditorPart)) {
                return;
            }
            RootstrapView.this.setProject(sourcepart, selection);
            RootstrapView.this.project = ProjectUtil.getProject((Object)sourcepart, (Object)selection);
            RootstrapView.this.disposeAllControl(RootstrapView.this.parentComposite);
            if (RootstrapView.this.project != null) {
                if (!RootstrapView.this.isSupportedProject(RootstrapView.this.project)) {
                    RootstrapView.this.createDescriptionComposite(String.format(RootstrapView.this.resources.getString("View.Desc.Notsupported"), RootstrapView.this.project.getName()), RootstrapView.this.parentComposite);
                    RootstrapView.this.parentComposite.layout(true, true);
                    RootstrapView.this.setEnableToolbar(false);
                    return;
                }
                RootstrapView.this.createMainComposite(RootstrapView.this.parentComposite);
                RootstrapView.this.parentComposite.layout(true, true);
                RootstrapView.this.setEnableToolbar(true);
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)RootstrapView.this.project);
                if (info != null) {
                    IConfiguration config = info.getDefaultConfiguration();
                    String targetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)config);
                    SmartBuildInterface sbi = SmartBuildInterface.getInstance();
                    if (targetId == null) {
                        RootstrapSelectionManager.resetSelectedRootstrap();
                        RootstrapView.this.tableViewer.refresh();
                    } else {
                        String rootId = sbi.getRootstrapIDFromTargetID(targetId);
                        RootstrapSelectionManager.setSelectedRootstrap(rootId);
                        RootstrapListenerManager.notifyChangedRootstrap();
                    }
                }
            } else {
                RootstrapView.this.createDescriptionComposite(RootstrapView.this.resources.getString("View.Desc.SelectProj"), RootstrapView.this.parentComposite);
                RootstrapView.this.parentComposite.layout(true, true);
                RootstrapView.this.setEnableToolbar(false);
                return;
            }
        }
    };

    public void setTitle(String str) {
        this.setPartName(str);
    }

    public Shell getShell() {
        return this.shell;
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        this.shell = this.getViewSite().getShell();
        RootstrapListenerManager.addListener(this.cListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener(this.listener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.tizen.ide.common.connection_explorer_context");
        this.createToolBar(parent);
        if (this.project == null) {
            this.createDescriptionComposite(this.resources.getString("View.Desc.SelectProj"), parent);
            this.setEnableToolbar(false);
        } else if (!this.isSupportedProject(this.project)) {
            this.createDescriptionComposite(String.format(this.resources.getString("View.Desc.Notsupported"), this.project.getName()), parent);
            this.setEnableToolbar(false);
        } else {
            this.createMainComposite(parent);
        }
    }

    private void disposeAllControl(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private boolean isSupportedProject(IProject project) {
        return PlatformProjectUtil.isTizenPlatformProject((IProject)project);
    }

    private void createMainComposite(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.createConnectionInfoTitleComposite(parent);
        this.createRootstrapTableComposite(parent);
        this.createRootstrapDescComposite(parent);
        this.initContextMenu();
    }

    private void createDescriptionComposite(String text, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    private void createConnectionInfoTitleComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(500, 15));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        composite.setLayout((Layout)layout);
        this.subTitle = new Label(composite, 0);
        GridData gridData = new GridData(768);
        this.subTitle.setLayoutData((Object)gridData);
        this.subTitle.setText("");
    }

    public Object getAdapter(Class adapter) {
        if (ISizeProvider.class == adapter) {
            return new ISizeProvider(){

                public int getSizeFlags(boolean width) {
                    return 1156;
                }

                public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
                    return width ? 300 : preferredResult;
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public void setFocus() {
    }

    private void createToolBar(Composite composite) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        IRootstrapViewProvider provider = RootstrapInstances.getRootstrapViewProvider(this);
        provider.fillToolbar(toolbarManager);
    }

    private void setEnableToolbar(boolean enable) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        IContributionItem[] iContributionItemArray = toolbarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem) {
                ((ActionContributionItem)item).getAction().setEnabled(enable);
            }
            ++n2;
        }
        toolbarManager.update(true);
    }

    private void createRootstrapTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(composite, 68096);
        Table table = this.tableViewer.getTable();
        GridData tableGridData = new GridData(1810);
        table.setLayoutData((Object)tableGridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setResizable(true);
        column.setText(this.resources.getString("View.Table.Column.Rootstrap"));
        column.setWidth(250);
        column.addSelectionListener((SelectionListener)new RootstraptableSelectionAdapter());
        column = new TableColumn(table, 0);
        column.setResizable(true);
        column.setText(this.resources.getString("View.Table.Column.Arch"));
        column.setWidth(50);
        column.addSelectionListener((SelectionListener)new RootstraptableSelectionAdapter());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableViewerProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            this.tableViewer.setInput(iRootstrapManager.getRootstraps());
        }
        this.tableViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Table table = RootstrapView.this.tableViewer.getTable();
                TableItem[] item = table.getSelection();
                if (item.length > 0) {
                    PlatformRootstrap selected = (PlatformRootstrap)item[0].getData();
                    RootstrapView.this.rootDescText.setText(RootstrapView.this.getRootstrapDescription(selected));
                } else {
                    RootstrapView.this.rootDescText.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private String getRootstrapDescription(PlatformRootstrap rootstrap) {
        String archLine = String.format(this.resources.getString("View.Desc.Arch"), this.getArchitectureCategory(rootstrap.getArchitecture()), rootstrap.getArchitecture());
        String statusLine = String.format(this.resources.getString("View.Desc.Status"), rootstrap.checkInitialized() ? "OK" : "Not Intialized");
        StringBuffer sbUrlLine = new StringBuffer(this.resources.getString("View.Desc.Repos"));
        for (String url : rootstrap.getJustRepoURLs()) {
            sbUrlLine.append(String.format("%n  - %s", url));
        }
        return String.valueOf(archLine) + "\n" + statusLine + "\n" + sbUrlLine.toString();
    }

    private void createRootstrapDescComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label descriptionLabel = new Label(composite, 0);
        GridData gridData = new GridData(32);
        descriptionLabel.setLayoutData((Object)gridData);
        descriptionLabel.setText(this.resources.getString("View.Description.Label"));
        this.rootDescText = new Text(composite, 2826);
        gridData = new GridData(1808);
        gridData.heightHint = 50;
        this.rootDescText.setLayoutData((Object)gridData);
    }

    public void setConnectionInfoLabel(String str) {
        this.subTitle.setText(str);
    }

    private void initContextMenu() {
        this.menuMgr = new MenuManager(this.resources.getString("View.Contextmenu.Title"));
        this.menuMgr.setRemoveAllWhenShown(true);
        final IRootstrapViewProvider provider = RootstrapInstances.getRootstrapViewProvider(this);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                provider.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.tableViewer);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items = manager.getItems();
                if (items != null) {
                    IContributionItem[] iContributionItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem item = iContributionItemArray[n2];
                        if (!(item instanceof Separator) && !item.getId().startsWith("platform.rootstrap.")) {
                            manager.remove(item);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public void updateToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        IRootstrapViewProvider provider = RootstrapInstances.getRootstrapViewProvider(this);
        provider.updateToolbarEnable(toolbarManager);
        toolbarManager.update(true);
    }

    public void setGeneratedRootstrap(PlatformRootstrap rootstrap) {
        this.generatedRootstrap = rootstrap;
    }

    public PlatformRootstrap getGeneratedRootstrap() {
        return this.generatedRootstrap;
    }

    public void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private String getArchitectureCategory(String arch) {
        if (arch.toLowerCase().contains("arm")) {
            return "arm";
        }
        return "x86";
    }

    public IProject getIproject() {
        return this.selectedProject;
    }

    private void setProject(Object sourcePart, Object selection) {
        IProject tempProj = null;
        if (selection instanceof IStructuredSelection) {
            tempProj = this.getProject(((IStructuredSelection)selection).toArray());
        }
        this.selectedProject = tempProj;
    }

    private IProject getProject(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r;
            Object element = objectArray[n2];
            if (element instanceof IAdaptable && (r = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
                return r.getProject();
            }
            ++n2;
        }
        return null;
    }

    private static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }

    private class RootstraptableSelectionAdapter
    extends SelectionAdapter {
        private RootstraptableSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            final int column = RootstrapView.this.tableViewer.getTable().indexOf((TableColumn)e.widget);
            RootstrapView.this.tableViewer.getTable().setSortColumn((TableColumn)e.widget);
            if (RootstrapView.this.tableViewer.getTable().getSortDirection() == 1024) {
                RootstrapView.this.tableViewer.getTable().setSortDirection(128);
            } else {
                RootstrapView.this.tableViewer.getTable().setSortDirection(1024);
            }
            RootstrapView.this.tableViewer.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    PlatformRootstrap entry_1 = (PlatformRootstrap)e1;
                    PlatformRootstrap entry_2 = (PlatformRootstrap)e2;
                    switch (column) {
                        case 0: {
                            if (RootstrapView.this.tableViewer.getTable().getSortDirection() == 1024) {
                                return entry_1.getText().compareTo(entry_2.getText());
                            }
                            return entry_2.getText().compareTo(entry_1.getText());
                        }
                        case 1: {
                            if (RootstrapView.this.tableViewer.getTable().getSortDirection() == 1024) {
                                return entry_1.getArchitecture().compareTo(entry_2.getArchitecture());
                            }
                            return entry_2.getArchitecture().compareTo(entry_1.getArchitecture());
                        }
                    }
                    return entry_1.getText().compareTo(entry_2.getText());
                }
            });
        }
    }

    private class TableViewerProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableViewerProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            PlatformRootstrap t;
            boolean checked;
            if (element instanceof PlatformRootstrap && (checked = (t = (PlatformRootstrap)element).isChecked()) && columnIndex == 0) {
                Image checkIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/successed.png");
                return checkIcon;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PlatformRootstrap) {
                PlatformRootstrap t = (PlatformRootstrap)element;
                String name = t.getText();
                String arch = t.getArchitecture();
                switch (columnIndex) {
                    case 0: {
                        return name;
                    }
                    case 1: {
                        return RootstrapView.this.getArchitectureCategory(arch);
                    }
                }
            }
            return null;
        }
    }
}

