/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.rootstrap.IRootstrapManager;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.util.RootstrapConstants;
import org.tizen.nativeplatform.rootstrap.util.SnapshotParser;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapSettingPage1;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapSettingPage2;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;
import org.tizen.nativeplatform.util.GBSArchitectureChecker;

public class RootstrapGenWizard
extends Wizard
implements IPageChangingListener,
IPageChangedListener {
    protected IProject project;
    protected IConfiguration config;
    protected PkgCommandTarget target;
    protected ILaunchConfiguration launchConfig;
    protected PlatformRootstrap generatedRootstrap;
    protected Shell shell;
    protected String defaultProfile;
    protected RootstrapSettingPage1 page1 = null;
    protected RootstrapSettingPage2 page2 = null;
    protected static final String SETTING_PAGE_1ST = "setting_page1st";
    protected static final String SETTING_PAGE_2ND = "setting_page2nd";
    protected final String BUNDLE_NAME = String.valueOf(RootstrapGenWizard.class.getPackage().getName()) + ".RootstrapWizardUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public RootstrapGenWizard(Shell shell, Map<String, List<String>> profileMap, boolean supportLocalRepo) {
        this(shell, profileMap, supportLocalRepo, null);
    }

    public RootstrapGenWizard(Shell shell, Map<String, List<String>> profileMap, boolean supportLocalRepo, String defaultProfile) {
        this.shell = shell;
        RootstrapWizardData.clearData();
        RootstrapWizardData.setSupportLocalRepo(supportLocalRepo);
        RootstrapWizardData.setProfileMap(profileMap);
        RootstrapWizardData.setDefaultProfile(defaultProfile);
    }

    public boolean performCancel() {
        if (RootstrapWizardData.getConsoleMgr() != null) {
            RootstrapWizardData.getConsoleMgr().removeConsole();
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        String rootstrapName = RootstrapWizardData.getRootstrapName();
        String arch = GBSArchitectureChecker.changeToSupportedArchitecture((String)RootstrapWizardData.getRootstrapArch());
        List<String> repositoryURLs = RootstrapWizardData.getRepositories();
        List repoURLs = RepoManager.createRepoList(repositoryURLs);
        boolean immediateGen = RootstrapWizardData.isGenImmediately();
        Path buildConfFile = new Path(RootstrapWizardData.getConfFilePath());
        boolean result = this.genRootstrap(rootstrapName, arch, repoURLs, immediateGen, (IPath)buildConfFile);
        return result;
    }

    private boolean genRootstrap(final String name, final String arch, final List<Repository> repoURLs, final boolean immediateGen, final IPath buildConfFile) {
        ConsoleManager consoleManager;
        IWizardContainer container = this.getContainer();
        try {
            try {
                container.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(RootstrapGenWizard.this.resources.getString("Wizard.Msg.Gen"), -1);
                        HostCommandLauncher.addConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
                        IRootstrapManager iRootstrapManaber = RootstrapInstances.getRootstrapManager();
                        if (iRootstrapManaber != null) {
                            RootstrapGenWizard.this.generatedRootstrap = iRootstrapManaber.generateRootstrap(name, arch, "1.0", repoURLs, immediateGen, buildConfFile, monitor);
                            if (RootstrapGenWizard.this.generatedRootstrap == null) {
                                throw new InterruptedException(RootstrapGenWizard.this.resources.getString("Wizard.Error.CheckLog"));
                            }
                            iRootstrapManaber.afterGenRootstrap(RootstrapGenWizard.this.generatedRootstrap, immediateGen, monitor);
                        }
                    }
                });
            }
            catch (Exception e) {
                DialogUtil.openErrorDialog((String)(String.valueOf(this.resources.getString("Wizard.Error.Gen")) + "\n" + e.getMessage()));
                IRootstrapManager iRootstrapManaber = RootstrapInstances.getRootstrapManager();
                if (iRootstrapManaber != null) {
                    iRootstrapManaber.removeLatestTempDirForRootstrap();
                }
                HostCommandLauncher.removeConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
                return false;
            }
        }
        finally {
            IRootstrapManager iRootstrapManaber = RootstrapInstances.getRootstrapManager();
            if (iRootstrapManaber != null) {
                iRootstrapManaber.removeLatestTempDirForRootstrap();
            }
            HostCommandLauncher.removeConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
        }
        IRootstrapManager iRootstrapManaber = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManaber != null) {
            iRootstrapManaber.addRootstrap(this.generatedRootstrap);
        }
        if ((consoleManager = RootstrapWizardData.getConsoleMgr()) != null) {
            consoleManager.removeConsole();
        }
        return true;
    }

    public void addPages() {
        this.page1 = new RootstrapSettingPage1(SETTING_PAGE_1ST, this.shell, this.project, this.config);
        this.page2 = new RootstrapSettingPage2(SETTING_PAGE_2ND, this.shell);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
        dialog.addPageChangingListener((IPageChangingListener)this);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean canFinish() {
        return RootstrapWizardData.validate();
    }

    public void pageChanged(PageChangedEvent event) {
        WizardPage selectedPage = (WizardPage)event.getSelectedPage();
        if (selectedPage.getName().equals(SETTING_PAGE_1ST)) {
            RootstrapSettingPage1 page = (RootstrapSettingPage1)selectedPage;
            page.updatePageCompleted();
        } else if (selectedPage.getName().equals(SETTING_PAGE_2ND)) {
            RootstrapSettingPage2 page = (RootstrapSettingPage2)selectedPage;
            page.updatePageCompleted();
        }
    }

    public RootstrapSettingPage1 getPage1() {
        return this.page1;
    }

    public RootstrapSettingPage2 getPage2() {
        return this.page2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePageChanging(final PageChangingEvent event) {
        WizardPage currentPage = (WizardPage)event.getCurrentPage();
        WizardPage targetPage = (WizardPage)event.getTargetPage();
        if (!currentPage.getName().equals(SETTING_PAGE_1ST) || !targetPage.getName().equals(SETTING_PAGE_2ND)) return;
        if (RootstrapWizardData.isRemoteRepoEnabled()) {
            IWizardContainer container = this.getContainer();
            try {
                try {
                    container.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            int snapshotLength = RootstrapWizardData.getSnapshots().size();
                            monitor.beginTask(RootstrapGenWizard.this.resources.getString("Wizard.Msg.Parse"), snapshotLength);
                            try {
                                this.setArchitectures(monitor);
                                this.setArchStrings();
                                if (RootstrapWizardData.getArchStrings().isEmpty()) {
                                    this.setDefaultArchs();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                SWTUtil.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        DialogUtil.openErrorDialog((String)e.getMessage());
                                    }
                                });
                                RootstrapGenWizard.this.cancelChanging(event);
                            }
                        }

                        private boolean setArchitectures(IProgressMonitor monitor) throws MalformedURLException, IOException, InterruptedException {
                            RootstrapWizardData.getArchitectures().clear();
                            for (final String url : RootstrapWizardData.getSnapshots()) {
                                String protocol = new URL(url).getProtocol();
                                if (!RootstrapGenWizard.this.isSupportedProtocol(protocol)) {
                                    SWTUtil.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            DialogUtil.openErrorDialog((String)("Only support http and https:\n" + url));
                                        }
                                    });
                                    continue;
                                }
                                if (url.endsWith("packages") || url.endsWith("packages/")) {
                                    RootstrapWizardData.addArchitectures(SnapshotParser.parsePkgUrl(url, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                                    continue;
                                }
                                RootstrapWizardData.addArchitectures(SnapshotParser.parse(url, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                            }
                            return true;
                        }

                        private void setArchStrings() {
                            RootstrapWizardData.getArchStrings().clear();
                            for (Architecture arch : RootstrapWizardData.getArchitectures()) {
                                if (RootstrapWizardData.getArchStrings().contains(arch.getArch())) continue;
                                RootstrapWizardData.addArchString(arch.getArch());
                            }
                        }

                        private void setDefaultArchs() {
                            RootstrapWizardData.addArchString("armv7l");
                            RootstrapWizardData.addArchString("i586");
                        }
                    });
                    return;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    if (!event.doit) return;
                    this.page2.updatePageForRemoteRepo();
                    return;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    if (!event.doit) return;
                    this.page2.updatePageForRemoteRepo();
                    return;
                }
            }
            finally {
                if (event.doit) {
                    this.page2.updatePageForRemoteRepo();
                }
            }
        } else {
            String localRepoPath = RootstrapWizardData.getLocalrepoPath();
            RootstrapWizardData.getArchStrings().clear();
            List availableArchs = RepoManager.getValidator((String)localRepoPath).availableArchs();
            RootstrapWizardData.getArchStrings().addAll(availableArchs);
            this.page2.updatePageForLocalRepo();
        }
    }

    public void cancelChanging(PageChangingEvent event) {
        event.doit = false;
    }

    public boolean isSupportedProtocol(String protocol) {
        for (String p : RootstrapConstants.SUPPORTED_URL_PROTOCOL) {
            if (!p.equals(protocol)) continue;
            return true;
        }
        return false;
    }
}

