/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build.gbs;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativeplatform.builder.PlatformInstances;
import org.tizen.nativeplatform.builder.build.IBuildCommandProvider;
import org.tizen.nativeplatform.builder.build.gbs.GBSOption;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;

public class GBSOptionManager {
    private static List<GBSOption> options = new ArrayList<GBSOption>();
    private static boolean initialized = false;
    public static double MIN_GBS_VERSION = 0.16;

    public static void addOption(GBSOption op) {
        options.add(op);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static List<GBSOption> getOptions() {
        return options;
    }

    public static GBSOption getOption(String op) {
        for (GBSOption o : options) {
            if (!o.getOption().startsWith(op)) continue;
            return o;
        }
        return null;
    }

    public static void initOptions() {
        options.clear();
        IBuildCommandProvider provider = PlatformInstances.getBuildCommandProvider(null, IBuildCommandProvider.BUILDTOOL.GBS.toString());
        boolean checkTool = provider.checkTool();
        if (!checkTool) {
            return;
        }
        String command = String.format("%s build --help", provider.getCommandName());
        String output = "";
        try {
            output = HostCommandLauncher.executeOutput((String)command);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean startArgs = false;
        String[] stringArray = output.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (startArgs) {
                String desc;
                String option;
                String[] values = (s = s.trim()).split("  +");
                if (values.length > 1) {
                    option = values[0].trim();
                    desc = values[1].trim();
                    GBSOption op = new GBSOption(option, desc, false);
                    options.add(op);
                } else if (values.length == 1 && !values[0].trim().startsWith("-")) {
                    GBSOption op = options.get(options.size() - 1);
                    desc = values[0].trim();
                    String newDesc = "";
                    newDesc = !op.getDesc().isEmpty() ? String.valueOf(op.getDesc()) + " " + desc : desc;
                    op.setDesc(newDesc);
                } else if (values.length == 1 && values[0].trim().startsWith("-")) {
                    option = values[0].trim();
                    GBSOption op = new GBSOption(option, "", false);
                    options.add(op);
                }
            }
            if (s.startsWith("optional arguments:")) {
                startArgs = true;
            }
            ++n2;
        }
        provider = null;
        GBSOptionManager.setInitialize(true);
    }

    public static void setInitialize(boolean value) {
        initialized = value;
    }
}

