/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.PackageProvider;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.pkgmgr.PkgMgrInitializer;
import org.tizen.nativeplatform.pkgmgr.ui.AddRepoDialog;
import org.tizen.nativeplatform.pkgmgr.ui.CommonTab;
import org.tizen.nativeplatform.pkgmgr.ui.ModifyRepoDialog;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.repo.model.RepositoryProvider;
import org.tizen.nativeplatform.types.CmdTargetTypes;

public class BuildsystemTab
extends CommonTab {
    private PkgCommandTarget target = null;

    public BuildsystemTab(Shell shell, TabFolder folder, PkgCommandTarget target) {
        super(shell, folder, target.getCommander(CmdTargetTypes.HOST), target.getCommander(CmdTargetTypes.ROOTSTRAP));
        this.target = target;
    }

    @Override
    protected CopyOnWriteArrayList<Repository> getRepositoryList() {
        return RepositoryProvider.INSTANCE.getBuildsystemRepos();
    }

    @Override
    public void updateRepositoryInfo() {
        PkgMgrInitializer initializer = new PkgMgrInitializer(this.target);
        initializer.updateRootstrapRepoInfo();
    }

    @Override
    public void updateRepository() {
        PkgMgrInitializer initializer = new PkgMgrInitializer(this.target);
        initializer.updateRootstrapRepo();
    }

    public void createTab() {
        this.createCommonTab(String.valueOf(resources.getString("PkgMgr.Tab.Buildsystem")) + " [" + this.target.getRootstrap().getName() + "]");
    }

    @Override
    protected boolean handleAddRepositoryButton() {
        boolean supportLocalrepo = false;
        AddRepoDialog dialog = new AddRepoDialog(this.shell, resources.getString("PkgMgr.Tab.Buildsystem"), supportLocalrepo);
        if (dialog.open() != 0) {
            return false;
        }
        String url = dialog.getRepositoryURL();
        Repository repo = this.target.getRootstrap().getRepository(url);
        if (repo != null) {
            DialogUtil.openMessageDialog((String)String.format(resources.getString("PkgMgr.Msg.Repo.Exists"), repo.getName()));
            return false;
        }
        this.target.getRootstrap().addRepoURL(url);
        return true;
    }

    @Override
    protected boolean handleModifyRepositoryButton() {
        int selectedIdx = this.repoViewer.getTable().getSelectionIndex();
        if (selectedIdx == -1) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Message.Select.OnePackage"));
            return false;
        }
        boolean supportLocalrepo = false;
        Repository selectedRepository = (Repository)this.repoViewer.getTable().getItem(selectedIdx).getData();
        ModifyRepoDialog dialog = new ModifyRepoDialog(this.shell, resources.getString("PkgMgr.Tab.Buildsystem"), selectedRepository.getName(), selectedRepository.getUri(), supportLocalrepo);
        if (dialog.open() != 0) {
            return false;
        }
        if (dialog.isDirty()) {
            String newUrl = dialog.getRepositoryURL();
            Repository repo = this.target.getRootstrap().getRepository(newUrl);
            if (repo != null) {
                DialogUtil.openMessageDialog((String)String.format(resources.getString("PkgMgr.Msg.Repo.Exists"), repo.getName()));
                return false;
            }
            return this.target.getRootstrap().modifyRepoURL(selectedRepository.getUri(), dialog.getRepositoryURL());
        }
        return true;
    }

    @Override
    protected boolean handleRemoveRepositoryButton() {
        int selectedIdx = this.repoViewer.getTable().getSelectionIndex();
        if (selectedIdx == -1) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Message.Select.OnePackage"));
            return false;
        }
        Repository selectedRepository = (Repository)this.repoViewer.getTable().getItem(selectedIdx).getData();
        this.target.getRootstrap().removeRepoURL(selectedRepository.getUri());
        return true;
    }

    @Override
    protected boolean handleMoveupRepositoryButton() {
        int selectedIdx = this.repoViewer.getTable().getSelectionIndex();
        if (selectedIdx == -1) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Message.Select.OnePackage"));
            return false;
        }
        Repository selectedRepository = (Repository)this.repoViewer.getTable().getItem(selectedIdx).getData();
        return this.target.getRootstrap().moveupRepository(selectedRepository.getUri());
    }

    @Override
    protected boolean handleMovedownRepositoryButton() {
        int selectedIdx = this.repoViewer.getTable().getSelectionIndex();
        if (selectedIdx == -1) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Message.Select.OnePackage"));
            return false;
        }
        Repository selectedRepository = (Repository)this.repoViewer.getTable().getItem(selectedIdx).getData();
        return this.target.getRootstrap().movedownRepository(selectedRepository.getUri());
    }

    @Override
    protected void handleUpgradeButton() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        if (this.isRepoChanged) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Info.Refresh.First"));
            return;
        }
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(resources.getString("PkgMgr.Message.Upgrade"), -1);
                    ICommandStatus status = BuildsystemTab.this.commander.upgrade(monitor);
                    if (status != null && !status.isOk()) {
                        throw new InterruptedException();
                    }
                    BuildsystemTab.this.updatePackageInfo(null);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.UpgradeFailed")) + "(" + e.toString() + ")"));
        }
        catch (InterruptedException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.UpgradeFailed")) + "(" + e.toString() + ")"));
        }
    }

    @Override
    protected List<PkgStatus> getSelectedPkgList(boolean remove) {
        CopyOnWriteArrayList<PkgStatus> selectedList = PackageProvider.INSTANCE.getSelectedBuildsystemPkgs(remove);
        return selectedList;
    }

    @Override
    protected List<PkgStatus> getPackageList() {
        return PackageProvider.INSTANCE.getBuildsystemPkgs();
    }
}

