/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.PackageProvider;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.pkgmgr.PkgMgrInitializer;
import org.tizen.nativeplatform.pkgmgr.ui.AddRepoDialog;
import org.tizen.nativeplatform.pkgmgr.ui.CommonTab;
import org.tizen.nativeplatform.pkgmgr.ui.ModifyRepoDialog;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.repo.model.RepositoryProvider;
import org.tizen.nativeplatform.types.CmdTargetTypes;

public class DeviceTab
extends CommonTab {
    private PkgCommandTarget target = null;
    private List<Repository> repositories = new ArrayList<Repository>();

    public DeviceTab(Shell shell, TabFolder folder, PkgCommandTarget target) {
        super(shell, folder, target.getCommander(CmdTargetTypes.HOST), target.getCommander(CmdTargetTypes.DEVICE));
        this.target = target;
        this.repositories.clear();
        this.repositories.addAll(this.getRepositoryList());
    }

    @Override
    protected CopyOnWriteArrayList<Repository> getRepositoryList() {
        return RepositoryProvider.INSTANCE.getDeviceRepos();
    }

    @Override
    public void updateRepositoryInfo() {
        PkgMgrInitializer initializer = new PkgMgrInitializer(this.target);
        initializer.updateDeviceRepoInfo(this.repositories);
    }

    @Override
    public void updateRepository() {
        PkgMgrInitializer initializer = new PkgMgrInitializer(this.target);
        initializer.updateDeviceRepo();
    }

    public boolean resetRepositoryInfo() {
        this.commander.resetRepo();
        int idx = 0;
        for (Repository repo : this.repositories) {
            String name;
            ICommandStatus status;
            if ((status = this.commander.addRepo(name = String.format("url%d", idx++), repo.getUri())).isOk()) continue;
            return false;
        }
        return true;
    }

    public void createTab() {
        this.createCommonTab(String.valueOf(resources.getString("PkgMgr.Tab.Device")) + " [" + this.target.getDevice().getSerialNumber() + "]");
    }

    private String findUrlName() {
        int idx = 0;
        String name = "";
        idx = 0;
        while (idx < this.repositories.size()) {
            name = String.format("url%d", idx);
            boolean exists = false;
            for (Repository repo : this.repositories) {
                if (!repo.getName().equals(name)) continue;
                exists = true;
            }
            if (!exists) {
                return name;
            }
            ++idx;
        }
        name = String.format("url%d", idx);
        return name;
    }

    @Override
    protected boolean handleAddRepositoryButton() {
        AddRepoDialog dialog = new AddRepoDialog(this.shell, resources.getString("PkgMgr.Tab.Buildsystem"), false);
        if (dialog.open() != 0) {
            return false;
        }
        String name = this.findUrlName();
        String url = dialog.getRepositoryURL();
        for (Repository repo : this.repositories) {
            if (!repo.getUri().equals(url)) continue;
            DialogUtil.openMessageDialog((String)String.format(resources.getString("PkgMgr.Msg.Repo.Exists"), repo.getName()));
            return false;
        }
        this.repositories.add(new Repository(name, url));
        return true;
    }

    @Override
    protected boolean handleModifyRepositoryButton() {
        int selectedIdx = this.repoViewer.getTable().getSelectionIndex();
        if (selectedIdx == -1) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Message.Select.OnePackage"));
            return false;
        }
        Repository selectedRepository = (Repository)this.repoViewer.getTable().getItem(selectedIdx).getData();
        ModifyRepoDialog dialog = new ModifyRepoDialog(this.shell, resources.getString("PkgMgr.Tab.Device"), selectedRepository.getName(), selectedRepository.getUri(), false);
        if (dialog.open() != 0) {
            return false;
        }
        String newUrl = dialog.getRepositoryURL();
        for (Repository repo : this.repositories) {
            if (!repo.getUri().equals(newUrl)) continue;
            DialogUtil.openMessageDialog((String)String.format(resources.getString("PkgMgr.Msg.Repo.Exists"), repo.getName()));
            return false;
        }
        for (Repository repo : this.repositories) {
            if (!selectedRepository.getUri().equals(repo.getUri())) continue;
            repo.setUri(newUrl);
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleRemoveRepositoryButton() {
        int selectedIdx = this.repoViewer.getTable().getSelectionIndex();
        if (selectedIdx == -1) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Message.Select.OnePackage"));
            return false;
        }
        Repository selectedRepository = (Repository)this.repoViewer.getTable().getItem(selectedIdx).getData();
        int idx = 0;
        boolean found = false;
        for (Repository repo : this.repositories) {
            if (selectedRepository.getUri().equals(repo.getUri())) {
                found = true;
                break;
            }
            ++idx;
        }
        if (found) {
            this.repositories.remove(idx);
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleMoveupRepositoryButton() {
        int selectedIdx = this.repoViewer.getTable().getSelectionIndex();
        if (selectedIdx == -1) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Message.Select.OnePackage"));
            return false;
        }
        Repository selectedRepository = (Repository)this.repoViewer.getTable().getItem(selectedIdx).getData();
        int idx = 0;
        Repository targetRepository = null;
        for (Repository repo : this.repositories) {
            if (selectedRepository.getUri().equals(repo.getUri())) {
                targetRepository = repo;
                break;
            }
            ++idx;
        }
        if (idx <= 0) {
            return false;
        }
        this.repositories.add(idx - 1, targetRepository);
        this.repositories.remove(idx + 1);
        return true;
    }

    @Override
    protected boolean handleMovedownRepositoryButton() {
        int selectedIdx = this.repoViewer.getTable().getSelectionIndex();
        if (selectedIdx == -1) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Message.Select.OnePackage"));
            return false;
        }
        Repository selectedRepository = (Repository)this.repoViewer.getTable().getItem(selectedIdx).getData();
        int idx = 0;
        int maxIdx = this.repositories.size() - 1;
        Repository targetRepository = null;
        for (Repository repo : this.repositories) {
            if (selectedRepository.getUri().equals(repo.getUri())) {
                targetRepository = repo;
                break;
            }
            ++idx;
        }
        if (idx >= maxIdx) {
            return false;
        }
        this.repositories.add(idx + 2, targetRepository);
        this.repositories.remove(idx);
        return true;
    }

    @Override
    protected void handleUpgradeButton() {
        DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Msg.Upgrade.Notsupported"));
    }

    @Override
    protected List<PkgStatus> getSelectedPkgList(boolean remove) {
        CopyOnWriteArrayList<PkgStatus> selectedList = PackageProvider.INSTANCE.getSelectedDevicePkgs(remove);
        return selectedList;
    }

    @Override
    protected List<PkgStatus> getPackageList() {
        return PackageProvider.INSTANCE.getDevicePkgs();
    }
}

