/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.nativeplatform.launcher.wizard.pages.CoredumpPackageTableSelectionAdapter;
import org.tizen.nativeplatform.launcher.wizard.pages.PackageData;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchCommonPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCommonLaunchWizard;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.util.CommonPackageUtil;

public class PlatformLaunchSettingPkgPage
extends PlatformLaunchCommonPage {
    private final String BUNDLE_NAME = String.valueOf(PlatformLaunchSettingPkgPage.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private PlatformCommonLaunchWizard wizard;
    private TableViewer packageTableDevice;
    private TableViewer packageTableRootstrap;
    private boolean enableDeviceGroup = true;
    private boolean enableRootstrapGroup = true;
    private boolean onlyInstall = false;
    private IProject project = null;
    private List<Button> deviceToolButtons = new ArrayList<Button>();
    private List<Button> rootstrapToolButtons = new ArrayList<Button>();
    private static final String PROP_KEY_DEVICE_PREFIX = "D|";
    private static final String PROP_KEY_ROOTSTRAP_PREFIX = "R|";
    private static final String PROP_VALUE_NOTINSTALL = "na";

    public PlatformLaunchSettingPkgPage(PlatformCommonLaunchWizard wizard, Shell shell, String pageName, IProject project, IConfiguration config, PkgCommandTarget cmdTarget) {
        super(pageName, shell, project, config, cmdTarget);
        this.wizard = wizard;
        this.setTitle(this.resources.getString("PkgSelectionPage.Title"));
        this.setDescription(this.resources.getString("PkgSelectionPage.Desc"));
        this.setPlatformPackages();
        this.project = project;
    }

    public void disableDeviceGroup() {
        this.enableDeviceGroup = false;
    }

    public void disableRootstrapGroup() {
        this.enableRootstrapGroup = false;
    }

    public void setOnlyInstallPackage() {
        this.onlyInstall = true;
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.createTableComposite(composite);
        this.setControl((Control)composite);
        this.validatePage();
    }

    private void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 300;
        composite.setLayoutData((Object)gridData);
        this.createButtons(composite);
        if (this.enableDeviceGroup) {
            this.createDeviceTable(composite);
            this.setInputDeviceTable();
        }
        if (this.enableRootstrapGroup) {
            this.createRootstrapTable(composite);
            this.setInputRootstrapTable();
        }
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = this.wizard.isPlatformVersion3() ? 2 : 3;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(768);
        Button selectRpmBt = new Button(composite, 0);
        selectRpmBt.setText(this.resources.getString("PkgSelectionPage.Button.SelectRPM"));
        selectRpmBt.setLayoutData((Object)gridData);
        selectRpmBt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PlatformLaunchSettingPkgPage.this.toolButtonClickHandler("rpm");
            }
        });
        if (!this.wizard.isPlatformVersion3()) {
            Button selectPkgcmdBt = new Button(composite, 0);
            selectPkgcmdBt.setText(this.resources.getString("PkgSelectionPage.Button.SelectPkgcmd"));
            selectPkgcmdBt.setLayoutData((Object)gridData);
            selectPkgcmdBt.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    PlatformLaunchSettingPkgPage.this.toolButtonClickHandler("pkgcmd");
                }
            });
        }
        Button notInstallBt = new Button(composite, 0);
        notInstallBt.setText(this.resources.getString("PkgSelectionPage.Button.NotInstAll"));
        notInstallBt.setLayoutData((Object)gridData);
        notInstallBt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PlatformLaunchSettingPkgPage.this.toolButtonClickHandler(PlatformLaunchSettingPkgPage.this.resources.getString("PkgSelectionPage.Button.NotInst"));
            }
        });
    }

    private void toolButtonClickHandler(String text) {
        ArrayList<Button> allButtons = new ArrayList<Button>();
        allButtons.addAll(this.deviceToolButtons);
        if (!text.equals("pkgcmd")) {
            allButtons.addAll(this.rootstrapToolButtons);
        }
        for (Button bt : allButtons) {
            if (bt.getText().equals(text)) {
                bt.setSelection(true);
                bt.notifyListeners(13, new Event());
                continue;
            }
            bt.setSelection(false);
        }
    }

    private void createDeviceTable(Composite composite) {
        Group deviceGroup = new Group(composite, 0);
        deviceGroup.setLayout((Layout)new FillLayout());
        deviceGroup.setLayoutData((Object)new GridData(1808));
        deviceGroup.setText(this.resources.getString("deviceGroup.Name"));
        this.packageTableDevice = new TableViewer((Composite)deviceGroup, 68352);
        this.packageTableDevice.setData("target", (Object)"device");
        Table table = this.packageTableDevice.getTable();
        this.createPackageTableColumns((Composite)deviceGroup, this.packageTableDevice, !this.wizard.isPlatformVersion3());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.packageTableDevice.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createRootstrapTable(Composite composite) {
        Group rootstrapGroup = new Group(composite, 0);
        rootstrapGroup.setLayout((Layout)new FillLayout());
        rootstrapGroup.setLayoutData((Object)new GridData(1808));
        rootstrapGroup.setText(this.resources.getString("rootstrapGroup.Name"));
        this.packageTableRootstrap = new TableViewer((Composite)rootstrapGroup, 68352);
        this.packageTableRootstrap.setData("target", (Object)"rootstrap");
        Table table2 = this.packageTableRootstrap.getTable();
        this.createPackageTableColumns((Composite)rootstrapGroup, this.packageTableRootstrap, false);
        table2.setHeaderVisible(true);
        table2.setLinesVisible(true);
        this.packageTableRootstrap.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    public void validatePage() {
        this.setPageComplete(true);
        if (this.onlyInstall) {
            this.wizard.setEnableFinish(true);
        } else {
            this.wizard.setEnableFinish(false);
        }
    }

    private PackageData getDevicePkgData(IPackage pkg) {
        PackageData d = null;
        String tool = this.getPersistentProperty(PROP_KEY_DEVICE_PREFIX + pkg.getName());
        if (tool == null) {
            if (CommonPackageUtil.isAppPkg((IProject)this.platformProject, (IPackage)pkg)) {
                pkg.setTool("pkgcmd");
            } else {
                pkg.setTool("rpm");
            }
            d = new PackageData(pkg);
            d.setInstallation(true);
        } else if (tool.equals(PROP_VALUE_NOTINSTALL)) {
            pkg.setTool("rpm");
            d = new PackageData(pkg);
            d.setInstallation(false);
        } else {
            pkg.setTool(tool);
            d = new PackageData(pkg);
            d.setInstallation(true);
        }
        return d;
    }

    private PackageData getRootstrapPkgData(IPackage pkg) {
        PackageData d = null;
        String tool = this.getPersistentProperty(PROP_KEY_ROOTSTRAP_PREFIX + pkg.getName());
        if (tool == null) {
            pkg.setTool("rpm");
            d = new PackageData(pkg);
            d.setInstallation(true);
        } else if (tool.equals(PROP_VALUE_NOTINSTALL)) {
            pkg.setTool("rpm");
            d = new PackageData(pkg);
            d.setInstallation(false);
        } else {
            pkg.setTool(tool);
            d = new PackageData(pkg);
            d.setInstallation(true);
        }
        return d;
    }

    private void setInputDeviceTable() {
        ArrayList<PackageData> deviceInput = new ArrayList<PackageData>();
        for (IPackage pkg : this.devicePackages) {
            PackageData d = this.getDevicePkgData(pkg);
            if (d == null) continue;
            deviceInput.add(d);
        }
        this.packageTableDevice.setInput(deviceInput);
        this.setCheckAllItems(this.packageTableDevice);
    }

    private void setInputRootstrapTable() {
        ArrayList<PackageData> rootstrapInput = new ArrayList<PackageData>();
        for (IPackage pkg : this.rootstrapPackages) {
            PackageData d = this.getRootstrapPkgData(pkg);
            if (d == null) continue;
            rootstrapInput.add(d);
        }
        this.packageTableRootstrap.setInput(rootstrapInput);
        this.setCheckAllItems(this.packageTableRootstrap);
    }

    private void setCheckAllItems(TableViewer viewer) {
        TableItem[] items;
        TableItem[] tableItemArray = items = viewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(true);
            ++n2;
        }
    }

    public List<IPackage> getCheckedDevicePackage() {
        return this.getCheckedPackages(this.packageTableDevice);
    }

    public List<IPackage> getUncheckedDevicePackage() {
        return this.getUncheckedPackages(this.packageTableDevice);
    }

    public List<IPackage> getCheckedRootstrapPackage() {
        return this.getCheckedPackages(this.packageTableRootstrap);
    }

    public List<IPackage> getUncheckedRootstrapPackage() {
        return this.getUncheckedPackages(this.packageTableRootstrap);
    }

    private List<IPackage> getCheckedPackages(TableViewer viewer) {
        ArrayList<IPackage> pkgs = new ArrayList<IPackage>();
        if (viewer != null) {
            TableItem[] items;
            TableItem[] tableItemArray = items = viewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                PackageData data = (PackageData)item.getData();
                if (data.beInstalled()) {
                    pkgs.add(data.getPkg());
                }
                ++n2;
            }
        }
        return pkgs;
    }

    public List<IPackage> getUncheckedPackages(TableViewer viewer) {
        ArrayList<IPackage> pkgs = new ArrayList<IPackage>();
        if (viewer != null) {
            TableItem[] items;
            TableItem[] tableItemArray = items = viewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                PackageData data = (PackageData)item.getData();
                if (!data.beInstalled()) {
                    pkgs.add(data.getPkg());
                }
                ++n2;
            }
        }
        return pkgs;
    }

    private void createPackageTableColumns(Composite parent, TableViewer viewer, boolean enablePkgCmd) {
        String[] titles = new String[]{"Package Name", "Install Tool"};
        int[] bounds = new int[]{350, 200};
        CoredumpPackageTableSelectionAdapter adapter = new CoredumpPackageTableSelectionAdapter(viewer);
        this.createNameColumn(viewer, adapter, titles[0], bounds[0], 0);
        this.createToolColumn(viewer, adapter, titles[1], bounds[1], 0, enablePkgCmd);
    }

    private TableViewerColumn createToolColumn(final TableViewer viewer, SelectionAdapter adapter, String title, int bound, int Style, final boolean enablePkgCmd) {
        TableViewerColumn colTool = new TableViewerColumn(viewer, 0);
        colTool.getColumn().setWidth(bound);
        colTool.getColumn().setText(title);
        colTool.getColumn().setResizable(true);
        colTool.getColumn().setMoveable(true);
        colTool.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                TableItem item = (TableItem)cell.getItem();
                final PackageData data = (PackageData)item.getData();
                Composite buttonPane = new Composite((Composite)viewer.getTable(), 0);
                buttonPane.setBackground(item.getParent().getBackground());
                buttonPane.setBackgroundMode(1);
                RowLayout l = new RowLayout();
                l.marginHeight = 0;
                l.marginWidth = 0;
                l.marginTop = 0;
                l.marginBottom = 0;
                buttonPane.setLayout((Layout)l);
                buttonPane.setLayoutData((Object)new GridData(32));
                Button rpmButton = new Button(buttonPane, 16);
                rpmButton.setText("rpm");
                rpmButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent event) {
                        String tool = ((Button)event.getSource()).getText();
                        data.getPkg().setTool(tool);
                        data.setInstallation(true);
                    }
                });
                Button pkgcmdButton = null;
                if (enablePkgCmd) {
                    pkgcmdButton = new Button(buttonPane, 16);
                    pkgcmdButton.setText("pkgcmd");
                    pkgcmdButton.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent arg0) {
                        }

                        public void widgetSelected(SelectionEvent event) {
                            String tool = ((Button)event.getSource()).getText();
                            data.getPkg().setTool(tool);
                            data.setInstallation(true);
                        }
                    });
                }
                Button notInstallButton = new Button(buttonPane, 16);
                notInstallButton.setText(PlatformLaunchSettingPkgPage.this.resources.getString("PkgSelectionPage.Button.NotInst"));
                notInstallButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent event) {
                        data.setInstallation(false);
                    }
                });
                if (!data.beInstalled()) {
                    notInstallButton.setSelection(true);
                    notInstallButton.notifyListeners(13, new Event());
                } else if (data.getPkg().getTool().equals("rpm")) {
                    rpmButton.setSelection(true);
                    rpmButton.notifyListeners(13, new Event());
                } else if (data.getPkg().getTool().equals("pkgcmd") && pkgcmdButton != null) {
                    pkgcmdButton.setSelection(true);
                    pkgcmdButton.notifyListeners(13, new Event());
                }
                String viewerTarget = (String)viewer.getData("target");
                if (viewerTarget != null) {
                    if (viewerTarget.equals("device")) {
                        PlatformLaunchSettingPkgPage.this.deviceToolButtons.add(rpmButton);
                        PlatformLaunchSettingPkgPage.this.deviceToolButtons.add(pkgcmdButton);
                        PlatformLaunchSettingPkgPage.this.deviceToolButtons.add(notInstallButton);
                    } else if (viewerTarget.equals("rootstrap")) {
                        PlatformLaunchSettingPkgPage.this.rootstrapToolButtons.add(rpmButton);
                        PlatformLaunchSettingPkgPage.this.rootstrapToolButtons.add(notInstallButton);
                    }
                }
                TableEditor editor = new TableEditor(viewer.getTable());
                editor.grabHorizontal = true;
                editor.grabVertical = true;
                editor.setEditor((Control)buttonPane, item, 1);
                editor.layout();
            }
        });
        return colTool;
    }

    private TableViewerColumn createNameColumn(TableViewer viewer, SelectionAdapter adapter, String title, int bound, int Style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, Style);
        TableColumn column = viewerColumn.getColumn();
        column.addSelectionListener((SelectionListener)adapter);
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PackageData data = (PackageData)element;
                return data.getPkg().getName();
            }
        });
        return viewerColumn;
    }

    private void setPersistentProperty(String propertyName, String value) {
        QualifiedName name = new QualifiedName("org.tizen.nativeplatform.launcher", propertyName);
        try {
            this.project.setPersistentProperty(name, value);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String getPersistentProperty(String propertyName) {
        String result = null;
        QualifiedName name = new QualifiedName("org.tizen.nativeplatform.launcher", propertyName);
        try {
            result = this.project.getPersistentProperty(name);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void savePkgInstallInfo() {
        if (this.packageTableDevice != null) {
            this.internalSavePkgInstallInfo(this.packageTableDevice.getTable().getItems(), PROP_KEY_DEVICE_PREFIX);
        }
        if (this.packageTableRootstrap != null) {
            this.internalSavePkgInstallInfo(this.packageTableRootstrap.getTable().getItems(), PROP_KEY_ROOTSTRAP_PREFIX);
        }
    }

    private void internalSavePkgInstallInfo(TableItem[] items, String prefixName) {
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            PackageData data = (PackageData)item.getData();
            String name = data.getPkg().getName();
            name = String.valueOf(prefixName) + name;
            String tool = data.getPkg().getTool();
            boolean beinstalled = data.beInstalled();
            if (!beinstalled) {
                this.setPersistentProperty(name, PROP_VALUE_NOTINSTALL);
            } else {
                this.setPersistentProperty(name, tool);
            }
            ++n2;
        }
    }

    public final class CellEditingSupport
    extends EditingSupport {
        private ComboBoxViewerCellEditor cellEditor;

        private CellEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = null;
            this.cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
            this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.cellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            String[] input = new String[]{"pkgcmd", "rpm"};
            this.cellEditor.setInput((Object)input);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof PackageData) {
                PackageData data = (PackageData)element;
                return data.getPkg().getTool();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof PackageData && value instanceof String) {
                PackageData data = (PackageData)element;
                String newValue = (String)value;
                if (!data.getPkg().getTool().equals(newValue)) {
                    data.getPkg().setTool(newValue);
                    this.getViewer().refresh();
                }
            }
        }
    }
}

