/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.hyperlink;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.ui.editor.hyperlink.Messages;
import org.eclipse.osgi.util.NLS;

public class DownloadJob
extends Job {
    private IFile file;
    private URLConnection content;
    private boolean fileOverride;

    public DownloadJob(IFile file, URLConnection content, boolean override) {
        super(NLS.bind((String)Messages.SourcesFileDownloadHyperlink_4, (Object)file.getName()));
        this.file = file;
        this.content = content;
        this.fileOverride = override;
    }

    public DownloadJob(IFile file, URLConnection content) {
        this(file, content, false);
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)Messages.SourcesFileDownloadHyperlink_4, (Object)this.file.getName()), this.content.getContentLength());
        try {
            int b;
            File tempFile = File.createTempFile(this.file.getName(), "");
            FileOutputStream fos = new FileOutputStream(tempFile);
            BufferedInputStream is = new BufferedInputStream(this.content.getInputStream());
            boolean canceled = false;
            while ((b = ((InputStream)is).read()) != -1) {
                if (monitor.isCanceled()) {
                    canceled = true;
                    break;
                }
                fos.write(b);
                monitor.worked(1);
            }
            ((InputStream)is).close();
            fos.close();
            if (!canceled) {
                if (this.fileOverride) {
                    this.file.setContents((InputStream)new FileInputStream(tempFile), true, false, monitor);
                } else {
                    this.file.create((InputStream)new FileInputStream(tempFile), true, monitor);
                }
            }
            tempFile.delete();
        }
        catch (CoreException e) {
            SpecfileLog.logError(e);
            return Status.CANCEL_STATUS;
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

