/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.action;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.view.ui.RootstrapChangeConfFileDialog;

public class RootstrapModifyConfAction
extends Action {
    protected final String BUNDLE_NAME = String.valueOf(RootstrapModifyConfAction.class.getPackage().getName()) + ".RootstrapUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(RootstrapModifyConfAction.class);
    protected IProject project;
    protected TableViewer viewer;
    protected Shell shell;

    public RootstrapModifyConfAction(Shell shell, IProject project, TableViewer viewer) {
        this.shell = shell;
        this.project = project;
        this.viewer = viewer;
    }

    public void run() {
        this.action();
    }

    protected void action() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                Table table = RootstrapModifyConfAction.this.viewer.getTable();
                TableItem[] item = table.getSelection();
                PlatformRootstrap selected = (PlatformRootstrap)item[0].getData();
                RootstrapChangeConfFileDialog dlg = new RootstrapChangeConfFileDialog(RootstrapModifyConfAction.this.shell, selected);
                if (dlg.open() == 0) {
                    IPath filePath = dlg.getBuildConfFile();
                    selected.setConfFile(filePath);
                    RootstrapInstances.getRootstrapManager().updateRootstrap(selected);
                }
            }

            @Override
            public boolean doCheckEnable() {
                return true;
            }
        });
    }

    private void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    private static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }
}

