/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.core;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.build.model.SBIModel;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.linux.rootstrap.core.RootstrapRemover;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.rootstrap.CommonRootstrapManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;

public class RootstrapImporter {
    protected static final String URL_SEP_REGEXP = "[|]";

    public static PlatformRootstrap importRootstrap(String tarFilePath, IProgressMonitor monitor) throws InterruptedException {
        PlatformRootstrap platformRootstrap;
        PlatformRootstrap result = null;
        String pluginPath = null;
        String rootstrapPath = null;
        String tempDirPath = PlatformInstances.getBuildCommandUtil().makeTempDirectory();
        try {
            if (!HostCommandLauncher.execute((String)String.format("tar xvf %s", tarFilePath), (String)tempDirPath, (String)"Platform Internal", (IProgressMonitor)monitor)) {
                RootstrapRemover.cleanUpRootstrap(pluginPath, rootstrapPath);
                throw new InterruptedException("Extracting rootsrap failed!");
            }
            File tempDir = new File(tempDirPath);
            File[] xmlFiles = tempDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            if (xmlFiles == null || xmlFiles.length == 0) {
                RootstrapRemover.cleanUpRootstrap(pluginPath, rootstrapPath);
                throw new InterruptedException("There is no SBI plugin file(*.xml)");
            }
            String pluginFilePath = xmlFiles[0].getPath().toString();
            String pluginFileName = new File(pluginFilePath).getName();
            String pluginId = pluginFileName.split("\\.xml")[0];
            if (CommonRootstrapManager.getRootstrap((String)pluginId) != null) {
                RootstrapRemover.cleanUpRootstrap(pluginPath, rootstrapPath);
                throw new InterruptedException("There already exists the rootrap with same id!");
            }
            pluginPath = new Path(SmartBuildInterface.getInstance().getPluginPath()).append(pluginFileName).toOSString();
            HostCommandLauncher.execute((String)String.format("cp %s %s", pluginFilePath, pluginPath));
            try {
                SBIModel.reinitialize();
            }
            catch (SBIException sBIException) {
                RootstrapRemover.cleanUpRootstrap(pluginPath, rootstrapPath);
                throw new InterruptedException("SBIModel initialization failed!");
            }
            result = RootstrapImporter.createRootstrapFromSBIPlugin(pluginId);
            if (result == null) {
                RootstrapRemover.cleanUpRootstrap(pluginPath, rootstrapPath);
                throw new InterruptedException("Loading SBI plugin failed!");
            }
            rootstrapPath = result.getPath();
            File baseDirDir = new File(rootstrapPath).getParentFile();
            if (baseDirDir != null && !baseDirDir.exists()) {
                if (!baseDirDir.mkdirs()) {
                    throw new InterruptedException(String.format("Failed to make directory: %s", baseDirDir.toString()));
                }
            } else if (new File(rootstrapPath).exists()) {
                HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", rootstrapPath), null);
            }
            if (baseDirDir != null && !baseDirDir.exists()) {
                if (!HostCommandLauncher.execute((String)String.format("tar xvf %s/rootstrap1.tar.gz", tempDirPath), (String)baseDirDir.getPath(), (String)"Platform Internal", (IProgressMonitor)monitor)) {
                    RootstrapRemover.cleanUpRootstrap(pluginPath, rootstrapPath);
                    throw new InterruptedException("Extracting rootsrap failed!");
                }
                if (!HostCommandLauncher.executeSudo((String)String.format("sudo -S tar xvf %s/rootstrap2.tar.gz", tempDirPath), (String)baseDirDir.getPath(), (String)"Platform Internal", (IProgressMonitor)monitor)) {
                    RootstrapRemover.cleanUpRootstrap(pluginPath, rootstrapPath);
                    throw new InterruptedException("Extracting rootsrap failed!");
                }
            }
            platformRootstrap = result;
        }
        catch (Throwable throwable) {
            HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath), null);
            throw throwable;
        }
        HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath), null);
        return platformRootstrap;
    }

    private static PlatformRootstrap createRootstrapFromSBIPlugin(String id) {
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rootstrap = pm.getRootstrap(id);
        if (rootstrap == null) {
            return null;
        }
        ArrayList<Repository> reposURLs = new ArrayList<Repository>();
        String urlStr = rootstrap.getPropertyValue("REPOSITORY_URLS");
        if (urlStr != null) {
            int idx = 0;
            String[] stringArray = urlStr.split(URL_SEP_REGEXP);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                String name = String.format("url%d", idx++);
                if (RepoManager.isLocalUrl((String)url)) {
                    reposURLs.add(new Repository(name, url.trim(), RepoManager.LOCAL_REPO_TYPE));
                } else {
                    reposURLs.add(new Repository(name, url.trim(), RepoManager.REMOTE_REPO_TYPE));
                }
                ++n2;
            }
        }
        return new PlatformRootstrap(rootstrap.getDocument(), rootstrap.getFile(), true);
    }
}

