/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TableColumn;
import org.tizen.nativeplatform.repo.model.Repository;

public class RepoTableSelectionAdapter
extends SelectionAdapter {
    private TableViewer repoViewer;
    private int selectedColumn = 0;

    public RepoTableSelectionAdapter(TableViewer v) {
        this.repoViewer = v;
    }

    public void widgetSelected(SelectionEvent e) {
        this.selectedColumn = this.repoViewer.getTable().indexOf((TableColumn)e.widget);
        this.repoViewer.getTable().setSortColumn((TableColumn)e.widget);
        if (this.repoViewer.getTable().getSortDirection() == 1024) {
            this.repoViewer.getTable().setSortDirection(128);
        } else {
            this.repoViewer.getTable().setSortDirection(1024);
        }
        this.repoViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int result = 0;
                Repository entry_1 = (Repository)e1;
                Repository entry_2 = (Repository)e2;
                switch (RepoTableSelectionAdapter.this.selectedColumn) {
                    case 0: {
                        if (RepoTableSelectionAdapter.this.repoViewer.getTable().getSortDirection() == 1024) {
                            result = entry_1.getName().compareTo(entry_2.getName());
                            break;
                        }
                        result = entry_2.getName().compareTo(entry_1.getName());
                        break;
                    }
                    case 1: {
                        if (RepoTableSelectionAdapter.this.repoViewer.getTable().getSortDirection() == 1024) {
                            result = entry_1.getUri().compareTo(entry_2.getUri());
                            break;
                        }
                        result = entry_2.getUri().compareTo(entry_1.getUri());
                        break;
                    }
                }
                return result;
            }
        });
    }
}

