/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.imports;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.project.model.SourceProject;
import org.tizen.common.sign.model.AuthorSignatureXml;
import org.tizen.common.sign.model.DistributorSignatureXml;
import org.tizen.common.ui.wizards.imports.ImportTypeManager;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.builder.build.PlatformProjectConverter;
import org.tizen.nativeplatform.project.wizard.imports.Messages;

public class PlatformProjectImportWizardPage
extends WizardDataTransferPage {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String METADATA_FOLDER = ".metadata";
    private ILeveledImportStructureProvider structureProvider;
    private static final String STORE_DIRECTORIES = "WizardProjectsImportPage.STORE_DIRECTORIES";
    private static final String STORE_ARCHIVES = "WizardProjectsImportPage.STORE_ARCHIVES";
    private static final String STORE_NESTED_PROJECTS = "WizardProjectsImportPage.STORE_NESTED_PROJECTS";
    private static final String STORE_COPY_PROJECT_ID = "WizardProjectsImportPage.STORE_COPY_PROJECT_ID";
    private static final String STORE_ARCHIVE_SELECTED = "WizardProjectsImportPage.STORE_ARCHIVE_SELECTED";
    private Combo directoryPathField;
    private Combo archivePathField;
    private CheckboxTreeViewer projectsList;
    private Button nestedProjectsCheckbox;
    private boolean nestedProjects = false;
    private boolean lastNestedProjects = false;
    private Button copyCheckbox;
    private boolean copyFiles = false;
    private boolean lastCopyFiles = false;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private Button projectFromDirectoryRadio;
    private Button projectFromArchiveRadio;
    private Button browseDirectoriesButton;
    private Button browseArchivesButton;
    private IProject[] wsProjects;
    private static final String[] FILE_DEFAULT_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private String initialPath;
    private String lastPath;
    private long lastModified;
    private WorkingSetGroup workingSetGroup;
    private IStructuredSelection currentSelection;
    List<IProject> createdProjects;
    private Label tcLabel;
    private Combo tcCombo;
    private Composite rootComp;
    private Composite migrationComp;
    private boolean bMigrateMode = false;

    public PlatformProjectImportWizardPage() {
        this("wizardExternalProjectsPage", null, null);
    }

    public PlatformProjectImportWizardPage(String pageName) {
        this(pageName, null, null);
    }

    public PlatformProjectImportWizardPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.initialPath = initialPath;
        this.currentSelection = currentSelection;
        this.setPageComplete(false);
    }

    public void setMigrateMode(boolean bMigrateMode) {
        this.bMigrateMode = bMigrateMode;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.rootComp = parent;
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        ArrayList<Control> nonMigrateCtrlList = new ArrayList<Control>();
        Composite projectsRoot = this.createProjectsRoot(workArea);
        nonMigrateCtrlList.add((Control)projectsRoot);
        this.createProjectsList(workArea);
        this.createOptionsGroup(workArea);
        this.createWorkingSetGroup(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
        this.updateProjectList(this.currentSelection);
        Control workingGroup = this.getChildGroupByText(workArea, WorkbenchMessages.WorkingSetGroup_WorkingSets_group);
        nonMigrateCtrlList.add(workingGroup);
        Control optionsGroup = this.getChildGroupByText(workArea, IDEWorkbenchMessages.WizardExportPage_options);
        nonMigrateCtrlList.add(optionsGroup);
        this.setDefaultDescription();
        this.checkMigrateMode(nonMigrateCtrlList);
    }

    private void checkMigrateMode(List<Control> list) {
        if (!this.bMigrateMode) {
            return;
        }
        for (Control control : list) {
            GridData zeroData = new GridData();
            zeroData.heightHint = 0;
            if (control instanceof Composite) {
                ((Composite)control).setVisible(false);
                control.setLayoutData((Object)zeroData);
                continue;
            }
            if (!(control instanceof Group)) continue;
            ((Group)control).setVisible(false);
            control.setLayoutData((Object)zeroData);
        }
    }

    private void setDefaultDescription() {
        this.setTitle(Messages.TIZEN_IMPORT_WIZARD_TITLE);
        if (this.bMigrateMode) {
            this.setDescription(Messages.TIZEN_CONVERT_WIZARD_DESCRIPTION);
        } else {
            this.setDescription(Messages.TIZEN_IMPORT_WIZARD_DESCRIPTION);
        }
    }

    private Control getChildGroupByText(Composite parent, String text) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childText;
            Control child = controlArray[n2];
            if (child instanceof Group && text.equals(childText = ((Group)child).getText())) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private void createWorkingSetGroup(Composite workArea) {
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup(workArea, this.currentSelection, workingSetIds);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.nestedProjectsCheckbox = new Button((Composite)optionsGroup, 32);
        this.nestedProjectsCheckbox.setText(DataTransferMessages.WizardProjectsImportPage_SearchForNestedProjects);
        this.nestedProjectsCheckbox.setLayoutData((Object)new GridData(768));
        this.nestedProjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.nestedProjects = PlatformProjectImportWizardPage.this.nestedProjectsCheckbox.getSelection();
                if (PlatformProjectImportWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    PlatformProjectImportWizardPage.this.updateProjectsList(PlatformProjectImportWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.copyCheckbox = new Button((Composite)optionsGroup, 32);
        this.copyCheckbox.setText(DataTransferMessages.WizardProjectsImportPage_CopyProjectsIntoWorkspace);
        this.copyCheckbox.setLayoutData((Object)new GridData(768));
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.copyFiles = PlatformProjectImportWizardPage.this.copyCheckbox.getSelection();
            }
        });
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(DataTransferMessages.WizardProjectsImportPage_ProjectsListTitle);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return PlatformProjectImportWizardPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectRecord element = (ProjectRecord)event.getElement();
                if (element.hasConflicts) {
                    PlatformProjectImportWizardPage.this.projectsList.setChecked((Object)element, false);
                } else {
                    PlatformProjectImportWizardPage.this.updatePlatformCombo();
                }
                PlatformProjectImportWizardPage.this.validatePage();
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private void setErrMessage(String message) {
        this.setMessage(message, 3);
    }

    private void setWarningMessage(String message) {
        this.setMessage(message, 2);
    }

    private boolean validatePage() {
        if (this.bMigrateMode) {
            return this.validateConvertWizard();
        }
        return this.validateMigrationWizard();
    }

    private boolean validateMigrationWizard() {
        if (this.projectsList.getCheckedElements().length > 0) {
            this.setDefaultMessage();
            this.setPageComplete(true);
            return true;
        }
        if (this.directoryPathField.getText().isEmpty()) {
            this.setErrMessage(Messages.TIZEN_IMPORT_WIZARD_DESCRIPTION);
        } else if (this.projectsList.getTree().getItems().length <= 0) {
            this.setErrMessage(Messages.TIZEN_IMPORT_WIZARD_ERROR_NO_PROJECTS_FOUND);
        } else if (this.projectsList.getCheckedElements().length <= 0) {
            this.setErrMessage(Messages.TIZEN_IMPORT_WIZARD_ERROR_SELECT_PROJECTS);
        } else {
            this.setDefaultMessage();
        }
        this.setPageComplete(false);
        return false;
    }

    private boolean validateConvertWizard() {
        if (this.projectsList.getCheckedElements().length > 0) {
            this.setDefaultMessage();
            this.setPageComplete(true);
            return true;
        }
        if (this.projectsList.getCheckedElements().length <= 0) {
            this.setErrMessage(Messages.TIZEN_IMPORT_WIZARD_ERROR_SELECT_PROJECTS);
        } else if (this.projectsList.getTree().getItems().length <= 0) {
            this.setErrMessage(Messages.TIZEN_IMPORT_WIZARD_ERROR_NO_PROJECTS_FOUND);
        } else {
            this.setDefaultMessage();
        }
        this.setPageComplete(false);
        return false;
    }

    private void setDefaultMessage() {
        if (this.bMigrateMode) {
            this.setMessage(Messages.TIZEN_CONVERT_WIZARD_DESCRIPTION);
        } else {
            this.setMessage(Messages.TIZEN_IMPORT_WIZARD_DESCRIPTION);
        }
    }

    protected Combo createSelection(Composite parent, String[] items, SelectionListener selectionListener) {
        Combo combo = new Combo(parent, 2060);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)combo).convertWidthInCharsToPixels(25);
        combo.setLayoutData((Object)directoryPathData);
        combo.setItems(items);
        if (combo.getItemCount() > 0) {
            combo.select(0);
        }
        if (selectionListener != null) {
            combo.addSelectionListener(selectionListener);
        }
        return combo;
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.DataTransfer_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < PlatformProjectImportWizardPage.this.selectedProjects.length) {
                    if (((PlatformProjectImportWizardPage)PlatformProjectImportWizardPage.this).selectedProjects[i].hasConflicts) {
                        PlatformProjectImportWizardPage.this.projectsList.setChecked((Object)PlatformProjectImportWizardPage.this.selectedProjects[i], false);
                    } else {
                        PlatformProjectImportWizardPage.this.projectsList.setChecked((Object)PlatformProjectImportWizardPage.this.selectedProjects[i], true);
                    }
                    ++i;
                }
                PlatformProjectImportWizardPage.this.updatePlatformCombo();
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.DataTransfer_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                PlatformProjectImportWizardPage.this.updatePlatformCombo();
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(DataTransferMessages.DataTransfer_refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PlatformProjectImportWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    PlatformProjectImportWizardPage.this.updateProjectsList(PlatformProjectImportWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private Composite createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(DataTransferMessages.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Combo(projectGroup, 2048);
        GridData directoryPathData = new GridData(768);
        directoryPathData.widthHint = new PixelConverter((Control)this.directoryPathField).convertWidthInCharsToPixels(25);
        this.directoryPathField.setLayoutData((Object)directoryPathData);
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(DataTransferMessages.WizardProjectsImportPage_ArchiveSelectTitle);
        this.projectFromArchiveRadio.setEnabled(false);
        this.archivePathField = new Combo(projectGroup, 2048);
        GridData archivePathData = new GridData(768);
        archivePathData.widthHint = new PixelConverter((Control)this.archivePathField).convertWidthInCharsToPixels(25);
        this.archivePathField.setLayoutData((Object)archivePathData);
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.browseArchivesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    PlatformProjectImportWizardPage.this.updateProjectsList(PlatformProjectImportWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PlatformProjectImportWizardPage.this.updateProjectsList(PlatformProjectImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.directoryPathField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.updateProjectsList(PlatformProjectImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    PlatformProjectImportWizardPage.this.updateProjectsList(PlatformProjectImportWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PlatformProjectImportWizardPage.this.updateProjectsList(PlatformProjectImportWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.archivePathField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.updateProjectsList(PlatformProjectImportWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformProjectImportWizardPage.this.archiveRadioSelected();
            }
        });
        return projectGroup;
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
            this.nestedProjectsCheckbox.setSelection(true);
            this.nestedProjectsCheckbox.setEnabled(false);
            this.copyCheckbox.setSelection(true);
            this.copyCheckbox.setEnabled(false);
        }
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
            this.nestedProjectsCheckbox.setEnabled(true);
            this.nestedProjectsCheckbox.setSelection(this.nestedProjects);
            this.copyCheckbox.setEnabled(true);
            this.copyCheckbox.setSelection(this.copyFiles);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (visible && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectList(final IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (!this.bMigrateMode) {
            return;
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    ArrayList files = new ArrayList();
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof IProject) {
                            IProject selectedProject = (IProject)obj;
                            PlatformProjectImportWizardPage.this.collectProjectFilesFromDirectory(files, selectedProject.getLocation().toFile(), null, monitor);
                        }
                        ++n2;
                    }
                    PlatformProjectImportWizardPage.this.selectedProjects = new ProjectRecord[files.size()];
                    int i = 0;
                    while (i < files.size()) {
                        ((PlatformProjectImportWizardPage)PlatformProjectImportWizardPage.this).selectedProjects[i] = new ProjectRecord((File)files.get(i));
                        ++i;
                    }
                    monitor.worked(50);
                    monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        ProjectRecord[] projects = this.getProjectRecords();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].hasConflicts) {
                this.projectsList.setChecked((Object)projects[i], true);
            }
            ++i;
        }
        this.setDefaultDescription();
        this.updatePlatformCombo();
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
    }

    public void updateProjectsList(final String path) {
        if (path == null || path.length() == 0) {
            this.setDefaultDescription();
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.updateProjectList(this.currentSelection);
            this.validatePage();
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified && this.lastNestedProjects == this.nestedProjects && this.lastCopyFiles == this.copyFiles) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        this.lastNestedProjects = this.nestedProjects;
        this.lastCopyFiles = this.copyFiles;
        final boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    PlatformProjectImportWizardPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList files = new ArrayList();
                    monitor.worked(10);
                    if (!dirSelected && ArchiveFileManipulations.isTarFile((String)path)) {
                        TarFile sourceTarFile = PlatformProjectImportWizardPage.this.getSpecifiedTarSourceFile(path);
                        if (sourceTarFile == null) {
                            return;
                        }
                        PlatformProjectImportWizardPage.this.structureProvider = (ILeveledImportStructureProvider)new TarLeveledStructureProvider(sourceTarFile);
                        Object child = PlatformProjectImportWizardPage.this.structureProvider.getRoot();
                        if (!PlatformProjectImportWizardPage.this.collectProjectFilesFromProvider(files, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        PlatformProjectImportWizardPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            ((PlatformProjectImportWizardPage)PlatformProjectImportWizardPage.this).selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (!dirSelected && ArchiveFileManipulations.isZipFile((String)path)) {
                        ZipFile sourceFile = PlatformProjectImportWizardPage.this.getSpecifiedZipSourceFile(path);
                        if (sourceFile == null) {
                            return;
                        }
                        PlatformProjectImportWizardPage.this.structureProvider = (ILeveledImportStructureProvider)new ZipLeveledStructureProvider(sourceFile);
                        Object child = PlatformProjectImportWizardPage.this.structureProvider.getRoot();
                        String[] supportedType = ImportTypeManager.getInstance().isSupportedPackage(path);
                        if (supportedType.length > 0) {
                            String filename = FileUtil.getFileNameFromPath((String)path);
                            String projectName = FileUtil.getFileNameWithoutExtension((String)filename);
                            PlatformProjectImportWizardPage.this.selectedProjects = new ProjectRecord[1];
                            ((PlatformProjectImportWizardPage)PlatformProjectImportWizardPage.this).selectedProjects[0] = new ProjectRecord(child, child, 0, projectName);
                        } else {
                            if (!PlatformProjectImportWizardPage.this.collectProjectFilesFromProvider(files, child, 0, monitor)) {
                                return;
                            }
                            Iterator filesIterator = files.iterator();
                            PlatformProjectImportWizardPage.this.selectedProjects = new ProjectRecord[files.size()];
                            int index = 0;
                            monitor.worked(50);
                            monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                            while (filesIterator.hasNext()) {
                                ((PlatformProjectImportWizardPage)PlatformProjectImportWizardPage.this).selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                            }
                        }
                    } else if (dirSelected && directory.isDirectory()) {
                        if (!PlatformProjectImportWizardPage.this.collectProjectFilesFromDirectory(files, directory, null, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        PlatformProjectImportWizardPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            File file = (File)filesIterator.next();
                            ((PlatformProjectImportWizardPage)PlatformProjectImportWizardPage.this).selectedProjects[index] = new ProjectRecord(file);
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        ProjectRecord[] projects = this.getProjectRecords();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].hasConflicts) {
                this.projectsList.setChecked((Object)projects[i], true);
            }
            ++i;
        }
        this.setDefaultDescription();
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private boolean collectProjectFilesFromDirectory(Collection<File> files, File directory, Set<String> directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(directory);
                if (!this.nestedProjects) {
                    return true;
                }
            }
            if (file.isDirectory() && "packaging".equals(file.getName())) {
                File[] subFiles = file.listFiles();
                int j = 0;
                while (j < subFiles.length) {
                    String ext = FilenameUtil.getExtension((String)subFiles[j].getName());
                    if ("spec".equals(ext)) {
                        files.add(directory);
                        if (!this.nestedProjects) {
                            return true;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                try {
                    String canonicalPath = contents[i].getCanonicalPath();
                    if (directoriesVisited.contains(canonicalPath)) break;
                    directoriesVisited.add(canonicalPath);
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, monitor);
                }
                catch (IOException exception) {
                    StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
                }
            }
            ++i;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection files, Object entry, int level, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)this.structureProvider.getLabel(entry)));
        ArrayList children = this.structureProvider.getChildren(entry);
        if (children == null) {
            children = new ArrayList(1);
        }
        for (Object child : children) {
            String elementLabel;
            if (this.structureProvider.isFolder(child)) {
                this.collectProjectFilesFromProvider(files, child, level + 1, monitor);
            }
            if (!(elementLabel = this.structureProvider.getLabel(child)).equals(".project")) continue;
            files.add(new ProjectRecord(child, entry, level));
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
            this.updatePlatformCombo();
        }
    }

    protected void updatePlatformCombo() {
        List<String> availableProfile = this.getAvailableProfile();
        availableProfile.isEmpty();
        this.validatePage();
    }

    private List<String> getAvailableProfile() {
        boolean isPackage = !this.projectFromDirectoryRadio.getSelection();
        ImportTypeManager typeManager = ImportTypeManager.getInstance();
        ArrayList<String> availableProfile = new ArrayList<String>();
        ProjectRecord[] projectRecordArray = this.selectedProjects;
        int n = this.selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectRecord pRecord = projectRecordArray[n2];
            if (this.projectsList.getChecked((Object)pRecord)) {
                List profileList = null;
                profileList = isPackage ? typeManager.getAvailableProfile(this.archivePathField.getText(), isPackage) : typeManager.getAvailableProfile(pRecord.projectSystemFile.getParent(), isPackage);
                if (availableProfile.isEmpty()) {
                    availableProfile.addAll(profileList);
                } else {
                    ArrayList<String> removeList = new ArrayList<String>();
                    for (String profile : availableProfile) {
                        if (profileList.contains(profile)) continue;
                        removeList.add(profile);
                    }
                    availableProfile.removeAll(removeList);
                }
            }
            ++n2;
        }
        return availableProfile;
    }

    private List<String> getAvailableVersion(String profile) {
        ImportTypeManager typeManager = ImportTypeManager.getInstance();
        ArrayList<String> availableVersionList = new ArrayList<String>();
        boolean isPackage = !this.projectFromDirectoryRadio.getSelection();
        ProjectRecord[] projectRecordArray = this.selectedProjects;
        int n = this.selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectRecord pRecord = projectRecordArray[n2];
            if (this.projectsList.getChecked((Object)pRecord)) {
                List versionList = null;
                versionList = isPackage ? typeManager.getAvailableVersion(this.archivePathField.getText(), profile, isPackage) : typeManager.getAvailableVersion(pRecord.projectSystemFile.getParent(), profile, isPackage);
                if (availableVersionList.isEmpty()) {
                    availableVersionList.addAll(versionList);
                } else {
                    ArrayList<String> removeList = new ArrayList<String>();
                    Iterator iterator = availableVersionList.iterator();
                    while (iterator.hasNext()) {
                        String cfr_ignored_0 = (String)iterator.next();
                        if (versionList.contains(profile)) continue;
                        removeList.add(profile);
                    }
                    availableVersionList.removeAll(removeList);
                }
            }
            ++n2;
        }
        return availableVersionList;
    }

    public SourceProject createModel(String path, boolean isPackage) {
        ImportTypeManager typeManager = ImportTypeManager.getInstance();
        String[] typeNames = isPackage ? typeManager.isSupportedPackage(path) : typeManager.isSupportedDirectory(path);
        String typeName = null;
        if (typeNames.length > 1) {
            typeName = typeNames[0];
        } else if (typeNames.length == 1) {
            typeName = typeNames[0];
        } else if (typeNames.length < 1) {
            typeName = "Unknown";
        }
        String platform = typeManager.getCurrentPlatform(typeName, path, isPackage);
        return new SourceProject(path, typeName, isPackage, platform);
    }

    protected void handleLocationArchiveButtonPressed() {
        List extensionPkgFilterList = ImportTypeManager.getInstance().getSupportedPackageFilter();
        extensionPkgFilterList.addAll(Arrays.asList(FILE_DEFAULT_IMPORT_MASK));
        FileDialog dialog = new FileDialog(this.archivePathField.getShell(), 0x10000000);
        dialog.setFilterExtensions(extensionPkgFilterList.toArray(new String[0]));
        dialog.setText(DataTransferMessages.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
            this.updatePlatformCombo();
        }
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] selected = this.projectsList.getCheckedElements();
        this.createdProjects = new ArrayList<IProject>();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int i = 0;
                    while (i < selected.length) {
                        PlatformProjectImportWizardPage.this.createExistingProject((ProjectRecord)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        PlatformProjectImportWizardPage.this.doAfterImport((ProjectRecord)selected[i], monitor);
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
        this.addToWorkingSets();
        return true;
    }

    private void updateDecorator() {
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IDecoratorManager dm = PlatformUI.getWorkbench().getDecoratorManager();
                dm.update("org.tizen.common.ui.decorator.projectinfodecorator");
            }
        });
    }

    protected void doAfterImport(ProjectRecord pRecord, IProgressMonitor monitor) throws InvocationTargetException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pRecord.getProjectName());
        PlatformProjectConverter convert = new PlatformProjectConverter(project);
        convert.run(false);
    }

    private void addToWorkingSets() {
        IWorkingSet[] selectedWorkingSets = this.workingSetGroup.getSelectedWorkingSets();
        if (selectedWorkingSets == null || selectedWorkingSets.length == 0) {
            return;
        }
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        for (IProject project : this.createdProjects) {
            workingSetManager.addToWorkingSets((IAdaptable)project, selectedWorkingSets);
        }
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
    }

    private List filterZipSourceList(List sources, String[] filterList) {
        ArrayList<ZipEntry> filteredResult = new ArrayList<ZipEntry>();
        for (Object source : sources) {
            if (!(source instanceof ZipEntry)) continue;
            ZipEntry zipSource = (ZipEntry)source;
            String name = zipSource.getName();
            if (ArrayUtil.contains((Object[])filterList, (Object)name)) {
                this.logger.debug("[Import] ZipSource filtered: {}", (Object)name);
                continue;
            }
            filteredResult.add(zipSource);
        }
        return filteredResult;
    }

    private void filterFileSourceList(File sourcePath, List sources, String[] filterList) {
        String[] stringArray = filterList;
        int n = filterList.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            boolean bRemoved = sources.remove(new File(sourcePath, filter));
            if (bRemoved) {
                this.logger.debug("[Import] FileSource filtered: {}", (Object)filter);
            }
            ++n2;
        }
        boolean bRemoved = sources.remove(new File(sourcePath, ".project"));
        if (bRemoved) {
            this.logger.debug("[Import] FileSource filtered: {}", (Object)".project");
        }
    }

    private String[] getFilterList() {
        String[] authorXmls = AuthorSignatureXml.getAvailableFilename();
        String[] distXmls = DistributorSignatureXml.getAvailableFilename();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(authorXmls));
        list.addAll(Arrays.asList(distXmls));
        this.logger.debug("[Import] Filter list: {}", list);
        return list.toArray(new String[0]);
    }

    private boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        URI locationURI;
        if (record.hasConflicts()) {
            return true;
        }
        String[] filterList = this.getFilterList();
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        this.createdProjects.add(project);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = null;
            if (record.projectSystemFile != null) {
                locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            }
            if (locationPath != null && Platform.getLocation().isPrefixOf(locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation(locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        if (record.projectArchiveFile != null) {
            List fileSystemObjects = this.structureProvider.getChildren(record.parent);
            this.structureProvider.setStrip(record.level);
            fileSystemObjects = this.filterZipSourceList(fileSystemObjects, filterList);
            ImportOperation operation = new ImportOperation(project.getFullPath(), this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider, (IOverwriteQuery)this, fileSystemObjects);
            operation.setContext(this.getShell());
            operation.run(monitor);
            return true;
        }
        File importSource = null;
        if (this.copyFiles && (locationURI = record.description.getLocationURI()) != null) {
            IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocationURI(project, locationURI);
            if (!result.isOK()) {
                throw new InvocationTargetException(new CoreException(result));
            }
            importSource = new File(locationURI);
            IProjectDescription desc = workspace.newProjectDescription(projectName);
            desc.setBuildSpec(record.description.getBuildSpec());
            desc.setComment(record.description.getComment());
            desc.setDynamicReferences(record.description.getDynamicReferences());
            desc.setNatureIds(record.description.getNatureIds());
            desc.setReferencedProjects(record.description.getReferencedProjects());
            record.description = desc;
        }
        try {
            try {
                monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, 100);
                project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
        if (this.copyFiles && importSource != null) {
            List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
            this.filterFileSourceList(importSource, filesToImport, filterList);
            ImportOperation operation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, filesToImport);
            operation.setContext(this.getShell());
            operation.setOverwriteResources(true);
            operation.setCreateContainerStructure(false);
            operation.run(monitor);
        }
        return true;
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> projectRecords = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (this.isProjectInWorkspacePath(this.selectedProjects[i].getProjectName()) && this.copyFiles || this.isProjectInWorkspace(this.selectedProjects[i].getProjectName())) {
                this.selectedProjects[i].hasConflicts = true;
            }
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    private boolean isProjectInWorkspacePath(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath wsPath = workspace.getRoot().getLocation();
        IPath localProjectPath = wsPath.append(projectName);
        return localProjectPath.toFile().exists();
    }

    private boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.restoreFromHistory(settings, STORE_DIRECTORIES, this.directoryPathField);
            this.restoreFromHistory(settings, STORE_ARCHIVES, this.archivePathField);
            this.nestedProjects = settings.getBoolean(STORE_NESTED_PROJECTS);
            this.nestedProjectsCheckbox.setSelection(this.nestedProjects);
            this.lastNestedProjects = this.nestedProjects;
            this.copyFiles = settings.getBoolean(STORE_COPY_PROJECT_ID);
            this.copyCheckbox.setSelection(this.copyFiles);
            this.lastCopyFiles = this.copyFiles;
        }
        if (this.initialPath == null && settings != null) {
            boolean archiveSelected = settings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!archiveSelected);
            this.projectFromArchiveRadio.setSelection(archiveSelected);
            if (archiveSelected) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        } else if (this.initialPath != null) {
            boolean dir = new File(this.initialPath).isDirectory();
            this.projectFromDirectoryRadio.setSelection(dir);
            this.projectFromArchiveRadio.setSelection(!dir);
            if (dir) {
                this.directoryPathField.setText(this.initialPath);
                this.directoryPathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
                this.directoryRadioSelected();
            } else {
                this.archivePathField.setText(this.initialPath);
                this.archivePathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
                this.archiveRadioSelected();
            }
        }
    }

    private void restoreFromHistory(IDialogSettings settings, String key, Combo combo) {
        String[] sourceNames = settings.getArray(key);
        if (sourceNames == null) {
            return;
        }
        int i = 0;
        while (i < sourceNames.length) {
            combo.add(sourceNames[i]);
            ++i;
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.saveInHistory(settings, STORE_DIRECTORIES, this.directoryPathField.getText());
            this.saveInHistory(settings, STORE_ARCHIVES, this.archivePathField.getText());
            settings.put(STORE_NESTED_PROJECTS, this.nestedProjectsCheckbox.getSelection());
            settings.put(STORE_COPY_PROJECT_ID, this.copyCheckbox.getSelection());
            settings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    private void saveInHistory(IDialogSettings settings, String key, String value) {
        String[] sourceNames = settings.getArray(key);
        if (sourceNames == null) {
            sourceNames = new String[]{};
        }
        sourceNames = this.addToHistory(sourceNames, value);
        settings.put(key, sourceNames);
    }

    public Button getCopyCheckbox() {
        return this.copyCheckbox;
    }

    public Button getNestedProjectsCheckbox() {
        return this.nestedProjectsCheckbox;
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    private final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            return ((ProjectRecord)element).getProjectLabel();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ProjectRecord projectRecord = (ProjectRecord)element;
            if (projectRecord.hasConflicts()) {
                return PlatformProjectImportWizardPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }
    }

    public class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        boolean hasConflicts;
        IProjectDescription description;

        ProjectRecord(File paramFile) {
            this.projectSystemFile = paramFile;
            this.setProjectName();
        }

        ProjectRecord(Object paramObject1, Object paramObject2, int paramInt) {
            this.projectArchiveFile = paramObject1;
            this.parent = paramObject2;
            this.level = paramInt;
            this.setProjectName();
        }

        ProjectRecord(Object paramObject1, Object paramObject2, int paramInt, String projectName) {
            this.projectArchiveFile = paramObject1;
            this.parent = paramObject2;
            this.level = paramInt;
            this.projectName = projectName;
        }

        private void setProjectName() {
            try {
                if (this.projectArchiveFile != null) {
                    InputStream stream = PlatformProjectImportWizardPage.this.structureProvider.getContents(this.projectArchiveFile);
                    if (stream == null) {
                        if (this.projectArchiveFile instanceof ZipEntry) {
                            Path path = new Path(((ZipEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        } else if (this.projectArchiveFile instanceof TarEntry) {
                            Path path = new Path(((TarEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        }
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(stream);
                        stream.close();
                        this.projectName = this.description.getName();
                    }
                }
                if (this.projectName == null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    this.projectName = path.segment(path.segmentCount() - 1);
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String path = this.projectSystemFile == null ? PlatformProjectImportWizardPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)path);
        }

        public boolean hasConflicts() {
            return this.hasConflicts;
        }
    }
}

