/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.preference;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.project.wizard.git.GitIndexUpdater;
import org.tizen.nativeplatform.project.wizard.preference.SiteConfigurationDialog;

public class SiteConfigurationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ArrayList<PreferencesManager.SiteConfiguration> siteConfigList;
    private TableViewer gitConfigTable;
    private Button addBt;
    private Button editBt;
    private Button updateBt;
    private Button setActiveBt;
    private Button removeBt;
    private final String BUNDLE_NAME = String.valueOf(SiteConfigurationPreferencePage.class.getPackage().getName()) + ".GitConfUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public SiteConfigurationPreferencePage() {
        this.siteConfigList = new ArrayList();
    }

    public void init(IWorkbench workbench) {
        this.updateData();
    }

    public void createControl(Composite parent) {
        Button applyButton;
        super.createControl(parent);
        Button defaultButton = this.getDefaultsButton();
        if (defaultButton != null) {
            defaultButton.setVisible(false);
        }
        if ((applyButton = this.getApplyButton()) != null) {
            applyButton.setVisible(false);
        }
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createGitDetailTableComposite(composite);
        return parent;
    }

    private void createGitDetailTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1810));
        this.createDetailTableComposite(composite);
        this.createGitButtonComposite(composite);
    }

    private void createDetailTableComposite(Composite composite) {
        this.gitConfigTable = new TableViewer(composite, 68352);
        Table table = this.gitConfigTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.gitConfigTable.setLabelProvider((IBaseLabelProvider)new TableViewerProvider());
        this.gitConfigTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableColumn column = new TableColumn(table, 0);
        column.setResizable(true);
        column.setText(this.resources.getString("GitConfPref.Column.Name"));
        column.setWidth(150);
        column = new TableColumn(table, 0);
        column.setResizable(true);
        column.setText(this.resources.getString("GitConfPref.Column.URI"));
        column.setWidth(250);
        column = new TableColumn(table, 0);
        column.setResizable(true);
        column.setText(this.resources.getString("GitConfPref.Column.Type"));
        column.setWidth(100);
        GridData tableGridData = new GridData(770);
        tableGridData.heightHint = 200;
        table.setLayoutData((Object)tableGridData);
        this.gitConfigTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int idx = SiteConfigurationPreferencePage.this.gitConfigTable.getTable().getSelectionIndex();
                if (idx != -1) {
                    SiteConfigurationPreferencePage.this.updateBt.setEnabled(true);
                    SiteConfigurationPreferencePage.this.editBt.setEnabled(true);
                    SiteConfigurationPreferencePage.this.setActiveBt.setEnabled(true);
                    SiteConfigurationPreferencePage.this.removeBt.setEnabled(true);
                } else {
                    SiteConfigurationPreferencePage.this.updateBt.setEnabled(false);
                    SiteConfigurationPreferencePage.this.editBt.setEnabled(false);
                    SiteConfigurationPreferencePage.this.setActiveBt.setEnabled(false);
                    SiteConfigurationPreferencePage.this.removeBt.setEnabled(false);
                }
            }
        });
        this.gitConfigTable.setInput(this.siteConfigList);
    }

    private void updateData() {
        this.siteConfigList = PreferencesManager.loadSiteConfigurations();
        if (this.gitConfigTable != null) {
            this.gitConfigTable.setInput(this.siteConfigList);
        }
    }

    private void createGitButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(130));
        this.addBt = new Button(composite, 8);
        this.addBt.setLayoutData((Object)new GridData(256));
        this.addBt.setText(this.resources.getString("GitConfPref.Button.Add"));
        this.addBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                SiteConfigurationDialog dialog = new SiteConfigurationDialog(SiteConfigurationPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    PreferencesManager.addSiteConfiguration((String)dialog.getSiteConfigName(), (String)dialog.getGitBaseURI(), (String)dialog.getGitListType(), (String)dialog.getGitListLocation());
                    SiteConfigurationPreferencePage.this.updateData();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.editBt = new Button(composite, 8);
        this.editBt.setLayoutData((Object)new GridData(256));
        this.editBt.setEnabled(false);
        this.editBt.setText(this.resources.getString("GitConfPref.Button.Edit"));
        this.editBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int idx = SiteConfigurationPreferencePage.this.gitConfigTable.getTable().getSelectionIndex();
                String siteConfigName = ((PreferencesManager.SiteConfiguration)SiteConfigurationPreferencePage.this.siteConfigList.get(idx)).getName();
                String gitBaseURI = ((PreferencesManager.SiteConfiguration)SiteConfigurationPreferencePage.this.siteConfigList.get(idx)).getBaseURI();
                String gitListType = ((PreferencesManager.SiteConfiguration)SiteConfigurationPreferencePage.this.siteConfigList.get(idx)).getListType();
                String gitListLocation = ((PreferencesManager.SiteConfiguration)SiteConfigurationPreferencePage.this.siteConfigList.get(idx)).getListLocation();
                SiteConfigurationDialog dialog = new SiteConfigurationDialog(SiteConfigurationPreferencePage.this.getShell(), siteConfigName, gitBaseURI, gitListType, gitListLocation);
                if (dialog.open() == 0) {
                    PreferencesManager.updateSiteConfiguration((int)SiteConfigurationPreferencePage.this.gitConfigTable.getTable().getSelectionIndex(), (String)dialog.getSiteConfigName(), (String)dialog.getGitBaseURI(), (String)dialog.getGitListType(), (String)dialog.getGitListLocation());
                    SiteConfigurationPreferencePage.this.updateData();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.updateBt = new Button(composite, 8);
        this.updateBt.setLayoutData((Object)new GridData(256));
        this.updateBt.setEnabled(false);
        this.updateBt.setText(this.resources.getString("GitConfPref.Button.Update"));
        this.updateBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                try {
                    new ProgressMonitorDialog(SiteConfigurationPreferencePage.this.getShell()).run(true, false, (IRunnableWithProgress)new GitIndexUpdater(SiteConfigurationPreferencePage.this.gitConfigTable.getTable().getSelectionIndex()));
                    DialogUtil.openMessageDialog((String)"Updating git index succeeded!");
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                    DialogUtil.openErrorDialog((String)("Failed to update git index:\n" + e1.getMessage()));
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    DialogUtil.openErrorDialog((String)("Failed to update git index:\n" + e1.getMessage()));
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.setActiveBt = new Button(composite, 8);
        this.setActiveBt.setLayoutData((Object)new GridData(256));
        this.setActiveBt.setEnabled(false);
        this.setActiveBt.setText(this.resources.getString("GitConfPref.Button.SetActive"));
        this.setActiveBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                PreferencesManager.setActiveSiteConfiguration((int)SiteConfigurationPreferencePage.this.gitConfigTable.getTable().getSelectionIndex());
                SiteConfigurationPreferencePage.this.updateData();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.removeBt = new Button(composite, 8);
        this.removeBt.setLayoutData((Object)new GridData(256));
        this.removeBt.setEnabled(false);
        this.removeBt.setText(this.resources.getString("GitConfPref.Button.Remove"));
        this.removeBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                PreferencesManager.removeSiteConfiguration((int)SiteConfigurationPreferencePage.this.gitConfigTable.getTable().getSelectionIndex());
                SiteConfigurationPreferencePage.this.updateData();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public boolean performOk() {
        return super.performOk();
    }

    private static class TableViewerProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableViewerProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PreferencesManager.SiteConfiguration config = (PreferencesManager.SiteConfiguration)element;
            switch (columnIndex) {
                case 0: {
                    if (config.isSetActive()) {
                        return String.valueOf(config.getName()) + " (Active)";
                    }
                    return config.getName();
                }
                case 1: {
                    return config.getBaseURI();
                }
                case 2: {
                    return config.getListType();
                }
            }
            return "";
        }
    }
}

