/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.nativeplatform.builder.build.IBuildCommandProvider;
import org.tizen.nativeplatform.builder.build.IBuildResultProcessor;

public class BuildCommandFactory {
    private static final String EXTENSION_ID = "org.tizen.nativeplatform.buildprovider";
    private static final String TAG_PROVIDER = "provider";
    private static final String TAG_RESULT_PROCESSOR = "resultProcessor";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TOOL = "tool";
    private static final String ATTR_OS = "os";
    private static final String ATTR_CLASS = "class";
    private String tool;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BuildCommandFactory() {
    }

    public BuildCommandFactory(String tool) {
        this.tool = tool;
    }

    public IBuildCommandProvider getProvider() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = ep.getExtensions();
        ArrayList<BuildCommandProxy> found = new ArrayList<BuildCommandProxy>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configElems = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configElems.length) {
                BuildCommandProxy proxy = this.parseType(configElems[j], TAG_PROVIDER);
                if (proxy != null) {
                    found.add(proxy);
                }
                ++j;
            }
            ++i;
        }
        BuildCommandProxy[] providers = found.toArray(new BuildCommandProxy[found.size()]);
        int i2 = 0;
        while (i2 < providers.length) {
            if (OSChecker.isLinux() || OSChecker.isUnix() ? (providers[i2].getOs().equals("linux") || providers[i2].getOs().equals("unix")) && providers[i2].getTool().toUpperCase().equals(this.tool) : OSChecker.isWindows() && (providers[i2].getOs().equals("windows") || providers[i2].getOs().equals("win")) && providers[i2].getTool().toUpperCase().equals(this.tool)) {
                return (IBuildCommandProvider)providers[i2].getProvider();
            }
            ++i2;
        }
        return null;
    }

    public IBuildResultProcessor getResultProcessor() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = ep.getExtensions();
        ArrayList<BuildCommandProxy> found = new ArrayList<BuildCommandProxy>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configElems = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configElems.length) {
                BuildCommandProxy proxy = this.parseType(configElems[j], TAG_RESULT_PROCESSOR);
                if (proxy != null) {
                    found.add(proxy);
                }
                ++j;
            }
            ++i;
        }
        BuildCommandProxy[] providers = found.toArray(new BuildCommandProxy[found.size()]);
        int i2 = 0;
        while (i2 < providers.length) {
            if (OSChecker.isLinux() || OSChecker.isUnix() ? (providers[i2].getOs().equals("linux") || providers[i2].getOs().equals("unix")) && providers[i2].getTool().toUpperCase().equals(this.tool) : OSChecker.isWindows() && (providers[i2].getOs().equals("windows") || providers[i2].getOs().equals("win")) && providers[i2].getTool().toUpperCase().equals(this.tool)) {
                return (IBuildResultProcessor)providers[i2].getProvider();
            }
            ++i2;
        }
        return null;
    }

    private BuildCommandProxy parseType(IConfigurationElement configElem, String tag) {
        if (!configElem.getName().equals(tag)) {
            return null;
        }
        try {
            return new BuildCommandProxy(configElem);
        }
        catch (Exception e) {
            String name = configElem.getAttribute(ATTR_NAME);
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load provider named" + name + " in " + configElem.getDeclaringExtension().getNamespace();
            this.logger.error(msg, (Throwable)e);
            return null;
        }
    }

    private static class BuildCommandProxy {
        private IConfigurationElement configElement;
        private String name;
        private String tool;
        private String id;
        private String os;
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());

        public BuildCommandProxy(IConfigurationElement configElem) {
            this.configElement = configElem;
            this.id = this.getAttribute(configElem, BuildCommandFactory.ATTR_ID, "");
            this.name = this.getAttribute(configElem, BuildCommandFactory.ATTR_NAME, this.id);
            this.os = this.getAttribute(configElem, BuildCommandFactory.ATTR_OS, "linux");
            this.tool = this.getAttribute(configElem, BuildCommandFactory.ATTR_TOOL, "gbs");
            this.getAttribute(configElem, BuildCommandFactory.ATTR_CLASS, null);
        }

        private String getAttribute(IConfigurationElement configElem, String name, String defaultValue) {
            String value = configElem.getAttribute(name);
            if (value != null) {
                return value;
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Missing" + name + "attribute");
        }

        public String getOs() {
            return this.os;
        }

        public String getTool() {
            return this.tool;
        }

        public Object getProvider() {
            Object obj = null;
            try {
                obj = this.configElement.createExecutableExtension(BuildCommandFactory.ATTR_CLASS);
            }
            catch (CoreException e) {
                String msg = "Failed to get provider: " + this.configElement.getAttribute(BuildCommandFactory.ATTR_CLASS) + " in type: " + this.id + " in plugin: " + this.configElement.getDeclaringExtension().getNamespace();
                this.logger.error(msg, (Throwable)e);
            }
            return obj;
        }
    }
}

