/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.rootstrap.PlatformRootstrapStore;
import org.tizen.nativeplatform.rootstrap.RootstrapListenerManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;

public class RootstrapInitializer {
    public static boolean init;

    public static synchronized void initialize() {
        PluginManager pm = PluginManager.getInstance();
        ArrayList cloneRootstrapList = new ArrayList(pm.getRootstrapList());
        for (Rootstrap r : cloneRootstrapList) {
            if (r == null || !r.getSupportToolchainType().equals("tizen.platform")) continue;
            File f = new File(r.getPath());
            boolean initialized = false;
            initialized = f.exists();
            Rootstrap rs = pm.getRootstrap(r.getId());
            if (rs == null) continue;
            PlatformRootstrap rootstrap = new PlatformRootstrap(rs.getDocument(), rs.getFile(), initialized);
            PlatformRootstrapStore.addRootstrap(rootstrap);
            pm.addRootstrap((Rootstrap)rootstrap);
            RootstrapListenerManager.notifyChangedRootstrap();
        }
        init = true;
    }

    public static void reinitialize(IProgressMonitor monitor) {
        init = false;
        PlatformRootstrapStore.clear();
        RootstrapInitializer.initialize();
    }

    public static void checkInitialized() {
        if (!init) {
            RootstrapInitializer.initialize();
        }
    }
}

