/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.git;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.project.wizard.git.GitDescManager;
import org.tizen.nativeplatform.project.wizard.git.model.GitDescription;
import org.tizen.nativeplatform.project.wizard.git.parser.GitIndexParserFactory;
import org.tizen.nativeplatform.project.wizard.git.parser.IGitIndexParser;

public class GitIndexUpdater
implements IRunnableWithProgress {
    private int idx;

    public GitIndexUpdater(int idx) {
        this.idx = idx;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Updating git index...", -1);
        try {
            PreferencesManager.SiteConfiguration config = PreferencesManager.loadSiteConfiguration((int)this.idx);
            IGitIndexParser parser = GitIndexParserFactory.getIndexParser(config);
            if (parser == null) {
                throw new InterruptedException("Failed to get git index parser");
            }
            if (!parser.prework(config)) {
                throw new InterruptedException(String.format("Path is invalid: %s", config.getListLocation()));
            }
            List<GitDescription> gitDescs = parser.parse(config);
            if (gitDescs != null) {
                String configName = config.getName();
                GitDescManager.removeDesc(configName);
                GitDescManager.setDescs(configName, gitDescs);
            }
        }
        finally {
            monitor.done();
        }
    }
}

