/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.LauncherInstances;
import org.tizen.nativeplatform.launcher.command.provider.IDebugCommandProvider;
import org.tizen.nativeplatform.launcher.delegate.ILaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.delegate.LaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.factory.PkgFilterFactory;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.IDevice;

public class PlatformLaunchDelegateForInstallAs
extends AbstractCLaunchDelegate {
    protected IConfiguration selectedConfig;
    protected IDevice currentDevice;
    protected PlatformRootstrap rootstrap;
    protected PkgCommandTarget target = null;
    protected int localDebugPort = -1;
    protected static final int defaultTimeOut = 60000;
    protected Shell shell;
    protected IProject project;
    protected boolean isLaunchFailed = false;
    protected boolean isCoredump = false;
    protected TizenLaunchCommand tizenCommand = null;
    protected IPackageUtil pkgUtil = LauncherInstances.getPackageUtil();
    protected IPkgFilter pkgFilter = PkgFilterFactory.getFilter(PlatformProjectUtil.getPkgType());
    protected static final String PROCESS_GET_PROCESS_ID_COMMAND = String.valueOf(TizenPlatformConstants.SDK_ROOT_COMMAND) + " process | grep '%s' | grep -v grep | awk '{print $1}'";
    protected static final String CHECK_RUNNING_GDBSERVER = String.format(TizenPlatformConstants.CMD_PROCESS, "gdb");
    protected static final String EMULATOR_PATH = InstallPathConfig.getEmulatorPath();
    protected static final String EMULATOR_CLI_BAT = String.valueOf(EMULATOR_PATH) + File.separatorChar + "bin" + File.separatorChar + "ecp-cli.bat";
    protected static final String EMULATOR_CLI_BIN = String.valueOf(EMULATOR_PATH) + File.separatorChar + "bin" + File.separatorChar + "ecp-cli";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected String getPluginID() {
        return null;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        UserLogger.start((String)"platform.launch");
        UserLogger.start((String)"platform.launch", (String)"pre.launch");
        this.isLaunchFailed = false;
        this.shell = LaunchUIPlugin.getShell();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IDebugCommandProvider iDebugCommandProvider;
            int totalWorks = 1;
            monitor.beginTask("", totalWorks);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
            this.project = this.getProject(config);
            if (!this.isCoredump) {
                this.checkPackageFiles(this.project, this.getBuildConfiguration(this.project));
            }
            this.activateProgressView();
            this.currentDevice = LaunchUtils.getCurrentDeployDevice();
            this.setPkgCommandTarget();
            this.tizenCommand = new TizenLaunchCommand(this.currentDevice, null);
            if (mode.equals("debug") && !this.isCoredump && (iDebugCommandProvider = LauncherInstances.getDebugCommandProvider()) != null) {
                iDebugCommandProvider.winCheckDebugsourceSync(this.shell, this.target.getRootstrap());
            }
            String targetPlatformVersion = null;
            boolean isPlatformVersion3 = false;
            try {
                targetPlatformVersion = this.currentDevice.getPlatformInfo().getPlatformVersion();
            }
            catch (IOException e) {
                this.logger.error("Failed to get platform version", (Throwable)e);
            }
            if ("3.0".equals(targetPlatformVersion)) {
                isPlatformVersion3 = true;
            }
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.tizen.platform.launch.TARGET_PLATFORM_VERSION", isPlatformVersion3);
            config = wc.doSave();
            ILaunchConfigurationProcessor processor = this.getConfigurationProcessor(this.shell, config, this.project, mode, this.target, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!processor.process()) {
                this.newCoreException(PlatformLaunchMessages.CANNOT_LAUNCH, null);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void newCoreException(String message, Throwable exception) throws CoreException {
        this.isLaunchFailed = true;
        Status status = new Status(4, "org.tizen.nativeplatform", message, exception);
        throw new CoreException((IStatus)status);
    }

    protected ILaunchConfigurationProcessor getConfigurationProcessor(Shell shell, ILaunchConfiguration launchConfig, IProject project, String mode, PkgCommandTarget target, IProgressMonitor monitor) {
        return new LaunchConfigurationProcessor(shell, launchConfig, project, mode, target, monitor, true);
    }

    protected void setPkgCommandTarget() {
        this.target = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), this.currentDevice, this.rootstrap);
    }

    protected void activateProgressView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProgressView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void checkPackageFiles(IProject project, IConfiguration config) throws CoreException {
        String[] xmls;
        boolean isEfl;
        File dir;
        String selectedRootstrapArch = RootstrapProxy.getProxy().getSelectedRootstrap().getArchitecture();
        List pkgs = this.pkgUtil.getPackages(project, config, selectedRootstrapArch);
        if (pkgs == null || pkgs.isEmpty()) {
            this.newCoreException("Can not find package(.rpm) file. Try to build again", null);
        }
        if (!(dir = project.getFile(config.getName()).getLocation().toFile()).exists()) {
            this.newCoreException(config + " directory does not exist. Try to build again", null);
        }
        if ((isEfl = CommonPackageUtil.checkXmls((IProject)project)) && (xmls = CommonPackageUtil.getXmls((IProject)project)) == null) {
            this.newCoreException("Can not find .xml file. Try to build again", null);
        }
    }

    protected IConfiguration getBuildConfiguration(IProject project) {
        return PlatformConfigurationManager.getDefaultConfiguration((IProject)project);
    }

    protected IProject getProject(ILaunchConfiguration config) throws CoreException {
        String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        if (projectName == null || projectName.equals("")) {
            this.newCoreException(PlatformLaunchMessages.CANNOT_FIND_PROJECT_NAME, null);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }
}

